/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ExpressionCompiler;
import com.saxonica.codegen.ReturnAction;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;

public abstract class PushExpressionCompiler
extends ExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression exp) {
        int n = compiler.getUniqueNumber();
        String vbl = "e" + n;
        String baseURI = this.getStaticBaseURI(exp);
        String outVar = PushExpressionCompiler.prepareToPush(n, compiler, baseURI);
        this.compilePush(compiler, exp);
        compiler.declare(Item.class, vbl, outVar + ".getFirstItem()", true);
        compiler.emit(outVar + ".close();");
        compiler.emit(outVar + ".reset();");
        compiler.popContextVariable();
        compiler.popOutputterVariable();
        return vbl;
    }

    public String compileToIterator(CompilerService compiler, Expression exp) {
        int n = compiler.getUniqueNumber();
        String vbl = "s" + n;
        String baseURI = this.getStaticBaseURI(exp);
        String outVar = PushExpressionCompiler.prepareToPush(n, compiler, baseURI);
        this.compilePush(compiler, exp);
        compiler.emit(outVar + ".close();");
        compiler.declare(SequenceIterator.class, vbl, outVar + ".iterate()", true);
        compiler.popContextVariable();
        compiler.popOutputterVariable();
        return vbl;
    }

    public static String prepareToPush(int n, CompilerService compiler, String baseURI) {
        String ctxVar = "ctx" + n;
        String outVar = "out" + n;
        String pipeVar = "pipe" + n;
        compiler.declare(XPathContext.class, ctxVar, compiler.getContextVariableName() + ".newMinorContext()", true);
        compiler.pushContextVariable(ctxVar);
        compiler.declare(SequenceOutputter.class, outVar, compiler.getContextVariableName() + ".getController().allocateSequenceOutputter(20)", true);
        if (baseURI != null) {
            compiler.emit(outVar + ".setSystemId(" + CompilerService.javaEscape(baseURI) + ");");
        }
        compiler.pushOutputterVariable(outVar);
        compiler.declare(PipelineConfiguration.class, pipeVar, compiler.getContextVariableName() + ".getController().makePipelineConfiguration()", true);
        compiler.emit(pipeVar + ".setHostLanguage(Configuration.XQUERY);");
        compiler.emit(outVar + ".setPipelineConfiguration(" + pipeVar + ");");
        compiler.emit(ctxVar + ".setTemporaryReceiver(" + outVar + ");");
        return outVar;
    }

    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression expr, ReturnAction result) {
        String iter = this.compileToIterator(compiler, expr);
        compiler.emit(result.output(compiler, "ExpressionTool.effectiveBooleanValue(" + iter + ")"));
        return result.getVariableName();
    }

    public String compileToCharSequence(CompilerService compiler, Expression exp) {
        throw new UnsupportedOperationException("PushExpressionCompiler.compileToString not implemented");
    }

    public String getStaticBaseURI(Expression exp) {
        return null;
    }
}

