/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.JavaAssignment;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PatternMatchExpression;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.LocationPathPattern;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;

public class PatternCompiler {
    public static void compileToEffectiveBooleanValue(CompilerService compiler, String nodeVar, Pattern pat, String booleanVar) {
        int n = compiler.getUniqueNumber();
        if (pat instanceof NodeTestPattern) {
            NodeTest nt = pat.getNodeTest();
            String ntVar = compiler.compileNodeTest(nt);
            compiler.assign(booleanVar, ntVar + ".matches(" + nodeVar + ")");
        } else if (pat instanceof LocationPathPattern) {
            Pattern upperPattern;
            Expression[] filters;
            NodeTest nt = pat.getNodeTest();
            int closers = 0;
            if (!(nt instanceof AnyNodeTest)) {
                String ntVar = compiler.compileNodeTest(nt);
                compiler.emit("if (!" + ntVar + ".matches(" + nodeVar + ")) {");
                compiler.assign(booleanVar, "false");
                compiler.emit("} else {");
                ++closers;
            }
            if ((filters = ((LocationPathPattern)pat).getFilters()) != null) {
                String contextVar = "ctx" + n;
                compiler.emit("final XPathContext " + contextVar + " = " + compiler.getContextVariableName() + ".newContext();");
                compiler.emit(contextVar + ".setCurrentIterator(SingletonIterator.makeIterator(" + nodeVar + "));");
                for (int f = 0; f < filters.length; ++f) {
                    if (filters[f] == null) continue;
                    compiler.compileToEffectiveBooleanValue(filters[f], new JavaAssignment(Boolean.TYPE, booleanVar));
                }
            }
            if ((upperPattern = ((LocationPathPattern)pat).getUpperPattern()) != null) {
                switch (((LocationPathPattern)pat).getUpwardsAxis()) {
                    case 9: {
                        String parentVar = "parent" + n;
                        compiler.declare(NodeInfo.class, parentVar, nodeVar + ".getParent()", true);
                        compiler.emit("if (" + parentVar + " == null) {");
                        compiler.assign(booleanVar, "false");
                        compiler.emit("} else {");
                        PatternCompiler.compileToEffectiveBooleanValue(compiler, parentVar, upperPattern, booleanVar);
                        ++closers;
                        break;
                    }
                    case 0: {
                        String parentVar = "parent" + n;
                        String ancestorMatchVar = "ancestorMatch" + n;
                        compiler.declare(Boolean.TYPE, ancestorMatchVar, "false", false);
                        compiler.declare(NodeInfo.class, parentVar, nodeVar + ".getParent()", false);
                        compiler.emit("while (true) {");
                        compiler.emit("if (" + parentVar + " == null)) break;");
                        compiler.compileToEffectiveBooleanValue((Expression)new PatternMatchExpression(upperPattern), new JavaAssignment(Boolean.TYPE, ancestorMatchVar));
                        compiler.emit("if (" + ancestorMatchVar + ") break;");
                        compiler.emit("} ");
                        compiler.emit("if (!" + ancestorMatchVar + ") {");
                        compiler.assign(booleanVar, "false");
                        compiler.emit("} else {");
                        compiler.emit(parentVar + " = " + parentVar + ".getParent();");
                        compiler.emit("}");
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported axis in compiled pattern");
                    }
                }
            }
            for (int i = 0; i < closers; ++i) {
                compiler.emit("}");
            }
        }
    }
}

