/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;

public class NumberFnCompiler
extends SingletonExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        int type;
        NumberFn exp = (NumberFn)expr;
        Expression arg = exp.getArguments()[0];
        String invar = compiler.compileToItem(arg);
        String outvar = "nr" + compiler.getUniqueNumber();
        compiler.declare(DoubleValue.class, outvar, null, false);
        boolean needCloser = false;
        if (Cardinality.allowsZero((int)arg.getCardinality())) {
            compiler.emit("if (" + invar + " == null) {");
            compiler.emit(outvar + " = DoubleValue.NaN;");
            compiler.emit("} else {");
            needCloser = true;
        }
        if ((type = arg.getItemType(compiler.getTypeHierarchy()).getPrimitiveType()) == 514) {
            compiler.emit(outvar + " = (" + compiler.cast(invar, BooleanValue.class) + ".getBooleanValue() ? 1.0e0 : 0.0e0);");
        } else if (type == 635 || type == 533 || type == 515 || type == 516) {
            compiler.emit(outvar + " = (DoubleValue)" + compiler.cast(invar, AtomicValue.class) + ".convert(BuiltInAtomicType.DOUBLE, " + compiler.getContextVariableName() + ");");
        } else if (type == 513 || type == 631) {
            compiler.emit("try {");
            compiler.emit(outvar + " = new DoubleValue(config.getConversionRules().getStringToDoubleConverter().stringToNumber(" + invar + ".getStringValueCS()));");
            compiler.emit("} catch (NumberFormatException e) {");
            compiler.emit(outvar + " = DoubleValue.NaN;");
            compiler.emit("}");
        } else {
            compiler.emit(outvar + " = NumberFn.convert(" + compiler.cast(invar, AtomicValue.class) + ", config);");
        }
        if (needCloser) {
            compiler.emit("}");
        }
        return outvar;
    }
}

