/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.functions.NormalizeUnicode;
import net.sf.saxon.serialize.codenorm.Normalizer;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public class NormalizeUnicodeCompiler
extends SingletonExpressionCompiler {
    public String compileToCharSequence(CompilerService compiler, Expression expr) {
        NormalizeUnicode exp = (NormalizeUnicode)expr;
        Expression[] operands = exp.getArguments();
        int n = compiler.getUniqueNumber();
        String resultVar = "norm" + n;
        boolean conditional = false;
        String argVar = compiler.compileToCharSequence(operands[0]);
        if (Cardinality.allowsZero((int)operands[0].getCardinality())) {
            conditional = true;
            compiler.declare(CharSequence.class, resultVar, null, false);
            compiler.emit("if (" + argVar + " == null) {");
            compiler.emit(resultVar + " = \"\";");
            compiler.emit("} else {");
        }
        String normalizerVar = "normalizer" + n;
        if (operands.length == 1) {
            compiler.declare(Normalizer.class, normalizerVar, "new net.sf.saxon.serialize.codenorm.Normalizer(\"NFC\")", true);
        } else if (Literal.isAtomic((Expression)operands[1]) && ((Literal)operands[1]).getValue() instanceof StringValue) {
            compiler.declare(Normalizer.class, normalizerVar, "new net.sf.saxon.serialize.codenorm.Normalizer(" + CompilerService.javaEscape(((StringValue)((Literal)operands[1]).getValue()).getStringValue()) + ")", true);
        } else {
            String formVar = compiler.compileToCharSequence(operands[1]);
            compiler.declare(Normalizer.class, normalizerVar, "new net.sf.saxon.serialize.codenorm.Normalizer(" + formVar + ")", true);
        }
        String valueExpression = normalizerVar + ".normalize(" + argVar + ")";
        if (conditional) {
            compiler.assign(resultVar, valueExpression);
            compiler.emit("}");
        } else {
            compiler.declare(CharSequence.class, resultVar, valueExpression, true);
        }
        return resultVar;
    }

    public String compileToItem(CompilerService compiler, Expression expr) {
        String csVar = this.compileToCharSequence(compiler, expr);
        return "new StringValue(" + csVar + ")";
    }
}

