/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.SequenceExpressionCompiler;
import com.saxonica.deploy.CompiledClosure;
import com.saxonica.expr.IndexedValue;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;

public class LetExpressionCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        LetExpression exp = (LetExpression)expr;
        this.compileAssignment(compiler, exp);
        return compiler.compileToIterator(exp.getAction());
    }

    public String compileToValueRepresentation(CompilerService compiler, Expression expr) {
        LetExpression exp = (LetExpression)expr;
        this.compileAssignment(compiler, exp);
        return compiler.compileToValueRepresentation(exp.getAction());
    }

    public void compileAsLoop(CompilerService compiler, Expression expr, LoopAction action) {
        LetExpression exp = (LetExpression)expr;
        this.compileAssignment(compiler, exp);
        compiler.compileAsLoop(exp.getAction(), action);
    }

    public void compilePush(CompilerService compiler, Expression expr) {
        LetExpression exp = (LetExpression)expr;
        this.compileAssignment(compiler, exp);
        compiler.compilePush(exp.getAction());
    }

    public String compileToItem(CompilerService compiler, Expression expr) {
        LetExpression exp = (LetExpression)expr;
        this.compileAssignment(compiler, exp);
        return compiler.compileToItem(exp.getAction());
    }

    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression expr, ReturnAction options) {
        LetExpression exp = (LetExpression)expr;
        this.compileAssignment(compiler, exp);
        return compiler.compileToEffectiveBooleanValue(exp.getAction(), options);
    }

    public String compileToCharSequence(CompilerService compiler, Expression expr) {
        LetExpression exp = (LetExpression)expr;
        this.compileAssignment(compiler, exp);
        return compiler.compileToCharSequence(exp.getAction());
    }

    private void compileAssignment(CompilerService compiler, LetExpression exp) {
        Expression rhs = exp.getSequence();
        int card = rhs.getCardinality();
        String varName = "variable" + exp.getLocalSlotNumber();
        String xpathName = exp.getVariableName();
        if (Cardinality.allowsMany((int)card)) {
            compiler.emitComment("let $" + xpathName + " := ...");
            if (exp.isIndexedVariable()) {
                String iterVar = compiler.compileToIterator(rhs);
                compiler.declare(IndexedValue.class, varName, "new IndexedValue(" + iterVar + ")", true);
                compiler.registerLocalVariable(IndexedValue.class, varName);
            } else if (exp.getNominalReferenceCount() == 1) {
                TypeHierarchy th = compiler.getTypeHierarchy();
                String iterVar = compiler.compileToIterator(rhs);
                compiler.declare(CompiledClosure.class, varName, "new CompiledClosure(" + iterVar + ", " + rhs.getItemType(th).getPrimitiveType() + ", " + rhs.getCardinality() + ")", true);
                compiler.registerLocalVariable(CompiledClosure.class, varName);
            } else {
                String inVar = compiler.compileToValueRepresentation(rhs);
                compiler.declare(ValueRepresentation.class, varName, inVar, true);
            }
        } else if (Cardinality.allowsZero((int)card)) {
            String itemVar = compiler.compileToItem(rhs);
            compiler.emitComment("let $" + xpathName + " := ...");
            compiler.declare(ValueRepresentation.class, varName, "(" + itemVar + " == null ? (ValueRepresentation)EmptySequence.getInstance() : (ValueRepresentation)" + itemVar + ")", true);
        } else {
            String itemVar = compiler.compileToItem(rhs);
            compiler.emitComment("let $" + xpathName + " := ...");
            compiler.declare(Item.class, varName, itemVar, true);
        }
        compiler.setXPathVariableName(exp.getLocalSlotNumber(), varName);
    }
}

