/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.ToBooleanCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.IntegerRangeTest;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;

public class IntegerRangeTestCompiler
extends ToBooleanCompiler {
    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression expr, ReturnAction result) {
        String maxTest;
        String minTest;
        IntegerRangeTest exp = (IntegerRangeTest)expr;
        TypeHierarchy th = compiler.getTypeHierarchy();
        String valueVar = compiler.compileToItem(exp.getValueExpression());
        Expression minExp = exp.getMinValueExpression();
        Expression maxExp = exp.getMaxValueExpression();
        if (Literal.isAtomic((Expression)minExp) && ((Literal)minExp).getValue() instanceof Int64Value) {
            minTest = "(int)(" + compiler.cast(valueVar, NumericValue.class) + ".longValue()) >= " + ((AtomicValue)((Literal)minExp).getValue()).getStringValue();
        } else {
            String minVar = compiler.compileToItem(minExp);
            minTest = compiler.cast(valueVar, NumericValue.class) + ".compareTo(" + minVar + ") >= 0";
        }
        if (Literal.isAtomic((Expression)maxExp) && ((Literal)maxExp).getValue() instanceof Int64Value) {
            maxTest = "(int)(" + compiler.cast(valueVar, NumericValue.class) + ".longValue()) <= " + ((AtomicValue)((Literal)maxExp).getValue()).getStringValue();
        } else {
            String maxVar = compiler.compileToItem(maxExp);
            maxTest = compiler.cast(valueVar, IntegerValue.class) + ".compareTo(" + maxVar + ") <= 0";
        }
        String typeTest = th.isSubType(exp.getValueExpression().getItemType(th), (ItemType)BuiltInAtomicType.INTEGER) ? "" : compiler.cast(valueVar, NumericValue.class) + ".isWholeNumber() && ";
        compiler.emit(result.output(compiler, typeTest + minTest + " && " + maxTest));
        return result.getVariableName();
    }
}

