/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.ValueCompiler;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.Value;

public class Int64ValueCompiler
extends ValueCompiler {
    public String compileToEffectiveBooleanValue(CompilerService compiler, Value expr, ReturnAction result) {
        compiler.emit(result.output(compiler, ((Int64Value)expr).compareTo(0L) == 0 ? "false" : "true"));
        return result.getVariableName();
    }

    public String toJavaExpression(AtomicValue value, CompilerService compiler) {
        Int64Value v = (Int64Value)value;
        AtomicType t = v.getTypeLabel();
        if (t.equals(BuiltInAtomicType.INTEGER)) {
            return "new Int64Value(" + v.toString() + "L)";
        }
        String typeVar = compiler.compileItemType((ItemType)t);
        return "Int64Value.makeDerived(" + v.toString() + "L, (AtomicType)" + typeVar + ")";
    }

    public Class getJavaClass() {
        return Int64Value.class;
    }
}

