/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.JavaAssignment;
import com.saxonica.codegen.JavaDeclaration;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.ToBooleanCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;

public class IdentityComparisonCompiler
extends ToBooleanCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        IdentityComparison exp = (IdentityComparison)expr;
        Expression[] operands = exp.getOperands();
        int n = compiler.getUniqueNumber();
        String resultVar = "is" + n;
        int operator = exp.getOperator();
        boolean conditional = false;
        int closers = 0;
        String op0var = compiler.compileToItem(operands[0]);
        if (Cardinality.allowsZero((int)operands[0].getCardinality())) {
            compiler.declare(BooleanValue.class, resultVar, null, false);
            conditional = true;
            ++closers;
            compiler.emit("if (" + op0var + " == null) {");
            compiler.emit(resultVar + " = null;");
            compiler.emit("} else {");
        }
        String op1var = compiler.compileToItem(operands[1]);
        if (Cardinality.allowsZero((int)operands[1].getCardinality())) {
            ++closers;
            if (!conditional) {
                compiler.declare(BooleanValue.class, resultVar, null, false);
                conditional = true;
            }
            compiler.emit("if (" + op1var + " == null) {");
            compiler.emit(resultVar + " = null;");
            compiler.emit("} else {");
        }
        String jexp = null;
        switch (operator) {
            case 20: {
                jexp = compiler.cast(op0var, NodeInfo.class) + ".isSameNodeInfo(" + compiler.cast(op1var, NodeInfo.class) + ")";
                break;
            }
            case 37: {
                jexp = "GlobalOrderComparer.getInstance().compare(" + compiler.cast(op0var, NodeInfo.class) + ", " + compiler.cast(op1var, NodeInfo.class) + ") < 0";
                break;
            }
            case 38: {
                jexp = "GlobalOrderComparer.getInstance().compare(" + compiler.cast(op0var, NodeInfo.class) + ", " + compiler.cast(op1var, NodeInfo.class) + ") > 0";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown operator " + operator);
            }
        }
        jexp = "BooleanValue.get(" + jexp + ")";
        if (conditional) {
            compiler.assign(resultVar, jexp);
            for (int i = 0; i < closers; ++i) {
                compiler.emit("}");
            }
        } else {
            compiler.declare(BooleanValue.class, resultVar, jexp, true);
        }
        return resultVar;
    }

    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression expr, ReturnAction result) {
        IdentityComparison exp = (IdentityComparison)expr;
        Expression[] operands = exp.getOperands();
        int operator = exp.getOperator();
        ReturnAction action2 = result;
        boolean conditional = false;
        int closers = 0;
        String op0var = compiler.compileToItem(operands[0]);
        if (Cardinality.allowsZero((int)operands[0].getCardinality())) {
            conditional = true;
            ++closers;
            if (result instanceof JavaDeclaration) {
                compiler.declare(Boolean.TYPE, result.getVariableName(), null, false);
                action2 = new JavaAssignment(Boolean.TYPE, result.getVariableName());
            }
            compiler.emit("if (" + op0var + " == null) {");
            compiler.emit(action2.output(compiler, "false"));
            compiler.emit("} else {");
        }
        String op1var = compiler.compileToItem(operands[1]);
        if (Cardinality.allowsZero((int)operands[1].getCardinality())) {
            ++closers;
            if (!conditional && result instanceof JavaDeclaration) {
                compiler.declare(Boolean.TYPE, result.getVariableName(), null, false);
                action2 = new JavaAssignment(Boolean.TYPE, result.getVariableName());
                conditional = true;
            }
            compiler.emit("if (" + op1var + " == null) {");
            compiler.emit(action2.output(compiler, "false"));
            compiler.emit("} else {");
        }
        switch (operator) {
            case 20: {
                compiler.emit(action2.output(compiler, compiler.cast(op0var, NodeInfo.class) + ".isSameNodeInfo(" + compiler.cast(op1var, NodeInfo.class) + ")"));
                break;
            }
            case 37: {
                compiler.emit(action2.output(compiler, "GlobalOrderComparer.getInstance().compare(" + compiler.cast(op0var, NodeInfo.class) + ", " + compiler.cast(op1var, NodeInfo.class) + ") < 0"));
                break;
            }
            case 38: {
                compiler.emit(action2.output(compiler, "GlobalOrderComparer.getInstance().compare(" + compiler.cast(op0var, NodeInfo.class) + ", " + compiler.cast(op1var, NodeInfo.class) + ") > 0"));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown operator " + operator);
            }
        }
        for (int i = 0; i < closers; ++i) {
            compiler.emit("}");
        }
        return result.getVariableName();
    }
}

