/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.ForceCase;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public class ForceCaseCompiler
extends SingletonExpressionCompiler {
    public String compileToCharSequence(CompilerService compiler, Expression expr) {
        ForceCase exp = (ForceCase)expr;
        Expression[] operands = exp.getArguments();
        int operator = exp.getDetails().opcode;
        int n = compiler.getUniqueNumber();
        String resultVar = compiler.makeValidJavaName(exp.getDetails().name) + n;
        boolean conditional = false;
        String argVar = compiler.compileToItem(operands[0]);
        if (Cardinality.allowsZero((int)operands[0].getCardinality())) {
            conditional = true;
            compiler.declare(String.class, resultVar, null, false);
            compiler.emit("if (" + argVar + " == null) {");
            compiler.emit(resultVar + " = \"\";");
            compiler.emit("} else {");
        }
        String valueExpression = this.getValueExpression(operator, argVar);
        if (conditional) {
            compiler.assign(resultVar, valueExpression);
            compiler.emit("}");
        } else {
            compiler.declare(String.class, resultVar, valueExpression, true);
        }
        return resultVar;
    }

    private String getValueExpression(int operator, String argVar) {
        String valueExpression;
        switch (operator) {
            case 0: {
                valueExpression = argVar + ".getStringValue().toUpperCase()";
                break;
            }
            case 1: {
                valueExpression = argVar + ".getStringValue().toLowerCase()";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized case operator " + operator);
            }
        }
        return valueExpression;
    }

    public String compileToItem(CompilerService compiler, Expression expr) {
        ForceCase exp = (ForceCase)expr;
        Expression[] operands = exp.getArguments();
        int operator = exp.getDetails().opcode;
        int n = compiler.getUniqueNumber();
        String resultVar = compiler.makeValidJavaName(exp.getDetails().name) + n;
        boolean conditional = false;
        String argVar = compiler.compileToItem(operands[0]);
        if (Cardinality.allowsZero((int)operands[0].getCardinality())) {
            conditional = true;
            compiler.declare(StringValue.class, resultVar, null, false);
            compiler.emit("if (" + argVar + " == null) {");
            compiler.emit(resultVar + " = StringValue.EMPTY_STRING;");
            compiler.emit("} else {");
        }
        String valueExpression = "StringValue.makeStringValue(" + this.getValueExpression(operator, argVar) + ")";
        if (conditional) {
            compiler.assign(resultVar, valueExpression);
            compiler.emit("}");
        } else {
            compiler.declare(StringValue.class, resultVar, valueExpression, true);
        }
        return resultVar;
    }
}

