/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.SequenceExpressionCompiler;
import net.sf.saxon.expr.EveryItemMappingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Int64Value;

public class ForExpressionCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        ForExpression exp = (ForExpression)expr;
        boolean positional = exp.getPositionVariableName() != null;
        String sequenceVar = compiler.compileToIterator(exp.getSequence());
        TypeHierarchy th = compiler.getTypeHierarchy();
        boolean nodal = th.isSubType(exp.getSequence().getItemType(th), (ItemType)AnyNodeTest.getInstance());
        int n = compiler.getUniqueNumber();
        String resultVar = "s" + n;
        String mfVar = "mf" + n;
        String rangeVar = (nodal ? "nodeVar" : "variable") + n;
        String positionVar = "position" + n;
        compiler.setXPathVariableName(exp.getLocalSlotNumber(), rangeVar);
        compiler.emitComment("for $" + exp.getVariableName() + " in ...");
        Expression loopBody = exp.getAction();
        int card = loopBody.getCardinality();
        if (Cardinality.allowsMany((int)card)) {
            compiler.emit("MappingFunction " + mfVar + " = new MappingFunction() {  // for expression");
            if (positional) {
                compiler.declare(Int64Value.class, positionVar, "IntegerValue.ZERO", false);
                compiler.setXPathVariableName(exp.getLocalSlotNumber() + 1, positionVar);
            }
            compiler.emit("public SequenceIterator map(final Item " + rangeVar + ") throws XPathException {");
            compiler.registerLocalVariable(Item.class, rangeVar);
            if (positional) {
                compiler.emit(positionVar + " = Int64Value.makeIntegerValue(" + positionVar + ".longValue() + 1);");
            }
            String actionVar = compiler.compileToIterator(loopBody);
            compiler.emit("return " + actionVar + ";");
            compiler.emit("}");
            compiler.emit("};");
            compiler.declare(MappingIterator.class, resultVar, "new MappingIterator(" + sequenceVar + ", " + mfVar + ")", true);
        } else {
            compiler.emit("ItemMappingFunction " + mfVar + " = new ItemMappingFunction() {  // for expression");
            if (positional) {
                compiler.declare(Int64Value.class, positionVar, "IntegerValue.ZERO", false);
                compiler.setXPathVariableName(exp.getLocalSlotNumber() + 1, positionVar);
            }
            compiler.emit("public Item mapItem(final Item " + rangeVar + ") throws XPathException {");
            compiler.registerLocalVariable(Item.class, rangeVar);
            if (positional) {
                compiler.emit(positionVar + " = Int64Value.makeIntegerValue(" + positionVar + ".longValue() + 1);");
            }
            compiler.emit("return " + compiler.compileToItem(loopBody) + ";");
            compiler.emit("}");
            compiler.emit("};");
            if (Cardinality.allowsZero((int)card)) {
                compiler.declare(ItemMappingIterator.class, resultVar, "new ItemMappingIterator(" + sequenceVar + ", " + mfVar + ")", true);
            } else {
                compiler.declare(EveryItemMappingIterator.class, resultVar, "new EveryItemMappingIterator(" + sequenceVar + ", " + mfVar + ")", true);
            }
        }
        return resultVar;
    }

    public void compilePush(CompilerService compiler, Expression expr) {
        final ForExpression exp = (ForExpression)expr;
        final boolean positional = exp.getPositionVariableName() != null;
        final String posVar = positional ? "variable" + (exp.getLocalSlotNumber() + 1) : null;
        LoopAction outerAction = new LoopAction(){

            public void compileAction(CompilerService compiler, String itemVar) {
                compiler.setXPathVariableName(exp.getLocalSlotNumber(), itemVar);
                if (positional) {
                    compiler.emit(posVar + " = Int64Value.makeIntegerValue(" + posVar + ".longValue() + 1);");
                    compiler.setXPathVariableName(exp.getLocalSlotNumber() + 1, posVar);
                }
                compiler.compilePush(exp.getAction());
            }
        };
        if (positional) {
            compiler.declare(Int64Value.class, posVar, "IntegerValue.ZERO", false);
        }
        compiler.compileAsLoop(exp.getSequence(), outerAction);
    }

    public void compileAsLoop(CompilerService compiler, Expression expr, final LoopAction action) {
        final ForExpression exp = (ForExpression)expr;
        final boolean positional = exp.getPositionVariableName() != null;
        final String posVar = positional ? "variable" + (exp.getLocalSlotNumber() + 1) : null;
        LoopAction outerAction = new LoopAction(){

            public void compileAction(CompilerService compiler, String itemVar) {
                Expression loopBody = exp.getAction();
                int card = loopBody.getCardinality();
                compiler.setXPathVariableName(exp.getLocalSlotNumber(), itemVar);
                if (positional) {
                    compiler.emit(posVar + " = Int64Value.makeIntegerValue(" + posVar + ".longValue() + 1);");
                    compiler.setXPathVariableName(exp.getLocalSlotNumber() + 1, posVar);
                }
                if (Cardinality.allowsMany((int)card)) {
                    compiler.compileAsLoop(exp.getAction(), action);
                } else if (Cardinality.allowsZero((int)card)) {
                    String bodyItem = compiler.compileToItem(exp.getAction());
                    compiler.emit("if (" + bodyItem + " != null) {");
                    action.compileAction(compiler, bodyItem);
                    compiler.emit("}");
                } else {
                    String bodyItem = compiler.compileToItem(exp.getAction());
                    action.compileAction(compiler, bodyItem);
                }
            }
        };
        if (positional) {
            compiler.declare(Int64Value.class, posVar, "IntegerValue.ZERO", false);
        }
        compiler.compileAsLoop(exp.getSequence(), outerAction);
    }
}

