/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.SequenceExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Int64Value;

public class ForEachCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        boolean usesPosition;
        ForEach exp = (ForEach)expr;
        int n = compiler.getUniqueNumber();
        String resultVar = "s" + n;
        Expression select = exp.getSelectExpression();
        Expression action = exp.getActionExpression();
        boolean bl = usesPosition = (action.getDependencies() & 4) != 0;
        if (Cardinality.allowsMany((int)select.getCardinality()) || usesPosition) {
            String masterVar = compiler.compileToIterator(select);
            String amf = "amf" + n;
            String itemVar = "item" + n;
            String positionVar = "pos" + n;
            String boxedPositionVar = "position" + n;
            compiler.emit("MappingFunction " + amf + " = new MappingFunction() { // mapping expression");
            if (usesPosition) {
                compiler.declare(Integer.TYPE, positionVar, "0", false);
            }
            compiler.emit("public SequenceIterator map(final Item " + itemVar + ") throws XPathException {");
            compiler.pushContextItemVariable(itemVar);
            if (usesPosition) {
                compiler.declare(Int64Value.class, boxedPositionVar, "new Int64Value(++" + positionVar + ")", true);
                compiler.pushContextPositionVariable(boxedPositionVar);
            }
            String stepVar = compiler.compileToIterator(action);
            compiler.emit("return " + stepVar + ";");
            compiler.popContextItemVariable();
            if (usesPosition) {
                compiler.popContextPositionVariable();
            }
            compiler.emit("}");
            compiler.emit("};");
            compiler.declare(SequenceIterator.class, resultVar, "new MappingIterator(" + masterVar + ", " + amf + ")", true);
            return resultVar;
        }
        if (Cardinality.allowsZero((int)select.getCardinality())) {
            String masterVar = compiler.compileToItem(select);
            compiler.declare(SequenceIterator.class, resultVar, null, false);
            compiler.emit("if (" + masterVar + " != null) {");
            compiler.pushContextItemVariable(masterVar);
            String stepVar = compiler.compileToIterator(action);
            compiler.popContextItemVariable();
            compiler.assign(resultVar, stepVar);
            compiler.emit("} else {");
            compiler.assign(resultVar, "EmptyIterator.getInstance()");
            compiler.emit("}");
            return resultVar;
        }
        String masterVar = compiler.compileToItem(select);
        compiler.pushContextItemVariable(masterVar);
        String stepVar = compiler.compileToIterator(action);
        compiler.popContextItemVariable();
        return stepVar;
    }

    public void compilePush(CompilerService compiler, Expression expr) {
        ForEach exp = (ForEach)expr;
        int loc = exp.getLocationId();
        if (Cardinality.allowsMany((int)exp.getCardinality())) {
            Expression select = exp.getSelectExpression();
            Expression action = exp.getActionExpression();
            if (Cardinality.allowsMany((int)select.getCardinality())) {
                String masterVar = compiler.compileToIterator(select);
                int n = compiler.getUniqueNumber();
                String contextVar = "cxt" + n;
                compiler.emit("final XPathContext " + contextVar + " = " + compiler.getContextVariableName() + ".newMinorContext();");
                compiler.pushContextVariable(contextVar);
                compiler.emit(contextVar + ".setCurrentIterator(" + masterVar + ");");
                compiler.emit("while (true) {");
                String itVar = "node" + n;
                compiler.pushContextItemVariable(itVar);
                compiler.pushContextPositionVariable(masterVar + ".position()");
                compiler.emit("Item " + itVar + " = " + masterVar + ".next();");
                compiler.emit("if (" + itVar + " == null) break;");
                compiler.compilePush(action);
                compiler.emit("}");
                compiler.popContextVariable();
                compiler.popContextItemVariable();
                compiler.popContextPositionVariable();
            } else {
                int n = compiler.getUniqueNumber();
                String masterVar = compiler.compileToItem(select);
                compiler.emit("if (" + masterVar + " != null) {");
                String contextVar = "cxt" + n;
                String iterVar = "si" + n;
                String itemVar = "node" + n;
                compiler.emit("final XPathContext " + contextVar + " = " + compiler.getContextVariableName() + ".newMinorContext();");
                compiler.emit("AxisIterator " + iterVar + " = SingleNodeIterator.makeIterator((NodeInfo)" + masterVar + ");");
                compiler.declare(Item.class, itemVar, iterVar + ".next()", true);
                compiler.pushContextItemVariable(itemVar);
                compiler.pushContextPositionVariable(contextVar + ".getContextPosition()");
                compiler.emit("if (" + itemVar + " != null) {");
                compiler.emit(contextVar + ".setCurrentIterator(" + iterVar + ");");
                compiler.pushContextVariable(contextVar);
                compiler.compilePush(action);
                compiler.emit("}");
                compiler.emit("}");
                compiler.popContextVariable();
                compiler.popContextItemVariable();
                compiler.popContextPositionVariable();
            }
        } else {
            String item = this.compileToItem(compiler, (Expression)exp);
            compiler.emit("if (" + item + " != null) {");
            compiler.emit(compiler.getOutputterVariableName() + ".append(" + item + ", " + loc + ", NodeInfo.ALL_NAMESPACES);");
            compiler.emit("}");
        }
    }

    public void compileAsLoop(CompilerService compiler, Expression expr, final LoopAction action) {
        ForEach exp = (ForEach)expr;
        Expression head = exp.getSelectExpression();
        final Expression tail = exp.getActionExpression();
        if (Cardinality.allowsMany((int)head.getCardinality())) {
            LoopAction outerAction = new LoopAction(){

                public void compileAction(CompilerService compiler, String itemVar) {
                    compiler.pushContextItemVariable(itemVar);
                    compiler.compileAsLoop(tail, action);
                    compiler.popContextItemVariable();
                }
            };
            compiler.compileAsLoop(head, outerAction);
        } else if (Cardinality.allowsZero((int)head.getCardinality())) {
            String itemVar = compiler.compileToItem(head);
            compiler.emit("if (" + itemVar + " != null) {");
            compiler.pushContextItemVariable(itemVar);
            compiler.compileAsLoop(tail, action);
            compiler.popContextItemVariable();
            compiler.emit("}");
        } else {
            String itemVar = compiler.compileToItem(head);
            compiler.pushContextItemVariable(itemVar);
            compiler.compileAsLoop(tail, action);
            compiler.popContextItemVariable();
        }
    }
}

