/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.ValueCompiler;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Value;

public class FloatValueCompiler
extends ValueCompiler {
    public String compileToEffectiveBooleanValue(CompilerService compiler, Value expr, ReturnAction result) {
        compiler.emit(result.output(compiler, ((FloatValue)expr).isNaN() || ((FloatValue)expr).compareTo(0L) == 0 ? "false" : "true"));
        return result.getVariableName();
    }

    public String toJavaExpression(AtomicValue value, CompilerService compiler) {
        FloatValue dv = (FloatValue)value;
        float d = dv.getFloatValue();
        AtomicType type = dv.getTypeLabel();
        if (type.equals(BuiltInAtomicType.FLOAT)) {
            if (Float.isNaN(d)) {
                return "FloatValue.NaN";
            }
            if ((double)d == 0.0) {
                if (Float.floatToIntBits(d) < 0) {
                    return "FloatValue.NEGATIVE_ZERO";
                }
                return "FloatValue.ZERO";
            }
            if ((double)d == 1.0) {
                return "FloatValue.ONE";
            }
            if (Float.isInfinite(d)) {
                if (d > 0.0f) {
                    return "new FloatValue(Float.POSITIVE_INFINITY)";
                }
                return "new FloatValue(Float.NEGATIVE_INFINITY)";
            }
            return "new FloatValue((float)" + Float.toString(d) + ")";
        }
        String t = "(AtomicType)" + compiler.compileItemType((ItemType)type);
        if (Double.isNaN(d)) {
            return "new FloatValue(Float.NaN, " + t + ")";
        }
        if (Double.isInfinite(d)) {
            if (d > 0.0f) {
                return "new FloatValue(Float.POSITIVE_INFINITY, " + t + ")";
            }
            return "new FloatValue(Float.NEGATIVE_INFINITY, " + t + ")";
        }
        return "new FloatValue((float)" + Float.toString(d) + ", " + t + ")";
    }
}

