/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.PushExpressionCompiler;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.FixedElement;
import net.sf.saxon.type.SchemaType;

public class FixedElementCompiler
extends PushExpressionCompiler {
    public void compilePush(CompilerService compiler, Expression expr) {
        FixedElement exp = (FixedElement)expr;
        int n = compiler.getUniqueNumber();
        int nameCode = exp.getNameCode(null, null);
        int validation = exp.getValidationMode();
        int typeCode = validation == 3 ? 572 : 630;
        String outVar = compiler.getOutputterVariableName();
        String out2Var = "out" + n;
        compiler.emitComment("create element " + compiler.getNamePool().getDisplayName(nameCode));
        boolean needToPopOutputter = false;
        if (!exp.isPreservingTypes()) {
            String typeVar = "type" + n;
            SchemaType type = exp.getSchemaType();
            if (type != null) {
                String typeCodeVar = compiler.declareNameCode(type.getFingerprint());
                compiler.declare(SchemaType.class, typeVar, "config.getSchemaType(" + typeCodeVar + ");", true);
            }
            compiler.declare(SequenceReceiver.class, out2Var, "config.getElementValidator(" + outVar + ", " + nameCode + ", " + exp.getLocationId() + ", " + (type == null ? "null" : typeVar) + ", " + validation + ")", false);
            compiler.pushOutputterVariable(out2Var);
            needToPopOutputter = true;
            compiler.emit("if (" + out2Var + " != " + outVar + ") {");
            compiler.emit(out2Var + " = new TreeReceiver(" + out2Var + ");");
            compiler.emit(out2Var + ".setPipelineConfiguration(" + outVar + ".getPipelineConfiguration());");
            compiler.emit("}");
            compiler.emit("if (" + out2Var + ".getSystemId() == null) {");
            compiler.emit(out2Var + ".setSystemId(" + CompilerService.javaEscape(exp.getBaseURI()) + ");");
            compiler.emit("}");
        } else {
            out2Var = outVar;
        }
        int properties = exp.isInheritNamespaces() ? 0 : 128;
        String jname = compiler.declareNameCode(nameCode);
        String jtype = compiler.declareNameCode(typeCode);
        compiler.emit(out2Var + ".startElement(" + jname + ", " + jtype + "&NamePool.FP_MASK, " + exp.getLocationId() + ", " + properties + ");");
        int[] namespaceCodes = exp.getActiveNamespaces();
        if (namespaceCodes != null) {
            for (int i = 0; i < namespaceCodes.length; ++i) {
                String jnsname = compiler.declareNamespaceCode(namespaceCodes[i]);
                compiler.emit(out2Var + ".namespace(" + jnsname + ", 0);");
            }
        }
        compiler.compilePush(exp.getContentExpression());
        compiler.emit(out2Var + ".endElement();");
        if (needToPopOutputter) {
            compiler.popOutputterVariable();
        }
    }

    public String getStaticBaseURI(Expression exp) {
        return ((FixedElement)exp).getBaseURI();
    }
}

