/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.JavaDeclaration;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.SequenceExpressionCompiler;
import com.saxonica.codegen.VariableReferenceCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public class FilterExpressionCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        ItemType filterType;
        FilterExpression exp = (FilterExpression)expr;
        Expression filter = exp.getFilter();
        Value filterVal = filter instanceof Literal ? ((Literal)filter).getValue() : null;
        String baseVar = compiler.compileToIterator(exp.getControllingExpression());
        int n = compiler.getUniqueNumber();
        if ((filter.getDependencies() & 8) != 0) {
            String extentVar = "extent" + n;
            compiler.declare(SequenceExtent.class, extentVar, "new SequenceExtent(" + baseVar + ")", true);
            String lastVar = "last" + n;
            compiler.declare(Int64Value.class, lastVar, "new Int64Value(" + extentVar + ".getLength())", true);
            compiler.pushContextSizeVariable(lastVar);
            String extentIterVar = "extentIter" + n;
            compiler.declare(SequenceIterator.class, extentIterVar, extentVar + ".iterate()", true);
            baseVar = extentIterVar;
        }
        String resultVar = "s" + n;
        TypeHierarchy th = compiler.getTypeHierarchy();
        if (th.isSubType(filterType = filter.getItemType(th), (ItemType)BuiltInAtomicType.BOOLEAN) || th.isSubType(filterType, (ItemType)AnyNodeTest.getInstance()) || th.isSubType(filterType, (ItemType)BuiltInAtomicType.STRING) || th.isSubType(filterType, (ItemType)BuiltInAtomicType.ANY_URI)) {
            boolean positional = (filter.getDependencies() & 4) != 0;
            String intPositionVar = "pos" + n;
            String boxedPositionVar = "position" + n;
            String cpfVar = "filter" + n;
            boolean isNodeSequence = th.isSubType(exp.getItemType(th), (ItemType)AnyNodeTest.getInstance());
            String itemVar = (isNodeSequence ? "node" : "item") + n;
            compiler.emit("ItemMappingFunction " + cpfVar + " = new ItemMappingFunction() { // boolean filter predicate");
            if (positional) {
                compiler.declare(Integer.TYPE, intPositionVar, "0", false);
            }
            compiler.emit("public Item mapItem(Item " + itemVar + ") throws XPathException {");
            compiler.pushContextItemVariable(itemVar);
            if (positional) {
                compiler.declare(Int64Value.class, boxedPositionVar, "Int64Value.makeIntegerValue(++" + intPositionVar + ")", true);
                compiler.pushContextPositionVariable(boxedPositionVar);
            }
            String varName = "b" + n;
            String boolVar = compiler.compileToEffectiveBooleanValue(filter, new JavaDeclaration(Boolean.TYPE, varName));
            compiler.emit("return (" + boolVar + " ? " + itemVar + " : null);");
            compiler.popContextItemVariable();
            if (positional) {
                compiler.popContextPositionVariable();
            }
            compiler.emit("}");
            compiler.emit("};");
            compiler.declare(SequenceIterator.class, resultVar, "new ItemMappingIterator(" + baseVar + ", " + cpfVar + ")", true);
        } else if (filterVal instanceof NumericValue) {
            NumericValue index = (NumericValue)filterVal;
            if (index.isWholeNumber() && index.compareTo(1L) >= 0) {
                try {
                    compiler.declare(SequenceIterator.class, resultVar, "SubsequenceIterator.make(" + baseVar + ", " + index.longValue() + ", " + index.longValue() + ")", true);
                }
                catch (XPathException e) {
                    throw new UnsupportedOperationException("Numeric index out of range");
                }
            } else {
                compiler.declare(EmptyIterator.class, resultVar, "EmptyIterator.getInstance()", true);
            }
        } else if (th.isSubType(filter.getItemType(th), (ItemType)BuiltInAtomicType.NUMERIC) && !Cardinality.allowsMany((int)filter.getCardinality())) {
            if (!ExpressionTool.dependsOnFocus((Expression)filter)) {
                String indexVar = compiler.compileToItem(filter);
                String numPosExp = compiler.cast(indexVar, NumericValue.class);
                String intPosExp = "(int)" + numPosExp + ".longValue()";
                if (!th.isSubType(filter.getItemType(th), (ItemType)BuiltInAtomicType.INTEGER)) {
                    intPosExp = "(" + numPosExp + ".isWholeNumber() ? " + intPosExp + " : 0 )";
                }
                String resultExp = "SubsequenceIterator.make(" + baseVar + ", " + intPosExp + ", " + intPosExp + ")";
                if (Cardinality.allowsZero((int)filter.getCardinality())) {
                    compiler.declare(SequenceIterator.class, resultVar, null, false);
                    compiler.emit("if (" + indexVar + " == null) {");
                    compiler.assign(resultVar, "EmptyIterator.getInstance()");
                    compiler.emit("} else {");
                    compiler.assign(resultVar, resultExp);
                    compiler.emit("}");
                } else {
                    compiler.declare(SequenceIterator.class, resultVar, resultExp, true);
                }
            } else {
                boolean positional = (filter.getDependencies() & 4) != 0;
                boolean isNodeSequence = th.isSubType(exp.getItemType(th), (ItemType)AnyNodeTest.getInstance());
                String cpfVar = "filter" + n;
                String itemVar = (isNodeSequence ? "node" : "item") + n;
                String intPosVar = "p" + n;
                String boxedPosVar = "position" + n;
                compiler.emit("ItemMappingFunction " + cpfVar + " = new ItemMappingFunction() { // filter predicate");
                compiler.declare(Integer.TYPE, intPosVar, "0", false);
                compiler.emit("public Item mapItem(Item " + itemVar + ") throws XPathException {");
                compiler.pushContextItemVariable(itemVar);
                compiler.emit(intPosVar + "++;");
                if (positional) {
                    compiler.declare(IntegerValue.class, boxedPosVar, "Int64Value.makeIntegerValue(" + intPosVar + ")", true);
                    compiler.pushContextPositionVariable(boxedPosVar);
                }
                String numVar = compiler.compileToItem(filter);
                compiler.emit("return (" + compiler.cast(numVar, NumericValue.class) + ".longValue() == " + intPosVar + " ? " + itemVar + " : null);");
                compiler.popContextItemVariable();
                compiler.emit("}");
                compiler.emit("};");
                compiler.declare(SequenceIterator.class, resultVar, "new ItemMappingIterator(" + baseVar + ", " + cpfVar + ")", true);
                if (positional) {
                    compiler.popContextPositionVariable();
                }
            }
        } else {
            boolean isNodeSequence = th.isSubType(exp.getItemType(th), (ItemType)AnyNodeTest.getInstance());
            String cpfVar = "filter" + n;
            String itemVar = (isNodeSequence ? "node" : "item") + n;
            String intPosVar = "p" + n;
            String boxedPosVar = "position" + n;
            compiler.emit("ItemMappingFunction " + cpfVar + " = new ItemMappingFunction() { // untyped filter predicate");
            compiler.declare(Integer.TYPE, intPosVar, "0", false);
            compiler.emit("public Item mapItem(Item " + itemVar + ") throws XPathException {");
            compiler.pushContextItemVariable(itemVar);
            compiler.emit(intPosVar + "++;");
            compiler.declare(IntegerValue.class, boxedPosVar, "Int64Value.makeIntegerValue(" + intPosVar + ")", true);
            compiler.pushContextPositionVariable(boxedPosVar);
            String filterIterVar = compiler.compileToIterator(filter);
            String firstVar = "first" + n;
            compiler.declare(Item.class, firstVar, filterIterVar + ".next()", true);
            compiler.emit("if (" + firstVar + " == null) {");
            compiler.emit("return null;");
            compiler.emit("}");
            compiler.emit("if (" + firstVar + " instanceof NodeInfo) {");
            compiler.emit("return " + itemVar + ";");
            compiler.emit("}");
            compiler.emit("if (" + filterIterVar + ".next() != null) {");
            compiler.emitDynamicError("Filter expression evaluates to a sequence containing more than one atomic value", "XPTY0004");
            compiler.emit("return null;");
            compiler.emit("}");
            compiler.emit("if (" + firstVar + " instanceof BooleanValue) {");
            compiler.emit("return (((BooleanValue)" + firstVar + ").getBooleanValue() ? " + itemVar + " : null );");
            compiler.emit("} else if (" + firstVar + " instanceof NumericValue) {");
            compiler.emit("return (((NumericValue)" + firstVar + ").compareTo(" + intPosVar + ") == 0 ? " + itemVar + " : null );");
            compiler.emit("} else if (" + firstVar + " instanceof StringValue) {");
            compiler.emit("return (((StringValue)" + firstVar + ").isZeroLength() ? null : " + itemVar + ");");
            compiler.emit("} else {");
            compiler.emitDynamicError("Filter expression evaluates to an atomic value that is not boolean, numeric, or string", "XPTY0004");
            compiler.emit("return null;");
            compiler.emit("}");
            compiler.emit("}");
            compiler.popContextItemVariable();
            compiler.popContextPositionVariable();
            compiler.emit("};");
            compiler.declare(SequenceIterator.class, resultVar, "new ItemMappingIterator(" + baseVar + ", " + cpfVar + ")", true);
        }
        if ((filter.getDependencies() & 8) != 0) {
            compiler.popContextSizeVariable();
        }
        return resultVar;
    }

    public void compileAsLoop(CompilerService compiler, Expression expr, final LoopAction action) {
        boolean keepPosition;
        final FilterExpression exp = (FilterExpression)expr;
        Expression filter = exp.getFilter();
        if (exp.isPositional(compiler.getTypeHierarchy())) {
            super.compileAsLoop(compiler, expr, action);
            return;
        }
        TypeHierarchy th = compiler.getTypeHierarchy();
        boolean isNodeSequence = th.isSubType(exp.getItemType(th), (ItemType)AnyNodeTest.getInstance());
        int n = compiler.getUniqueNumber();
        boolean bl = keepPosition = (filter.getDependencies() & 4) != 0;
        if ((filter.getDependencies() & 8) != 0) {
            String iterVar = compiler.compileToIterator(exp.getControllingExpression());
            String extentVar = "baseExtent" + n;
            compiler.declare(SequenceExtent.class, extentVar, "new SequenceExtent(" + iterVar + ")", true);
            String lastVar = "last" + n;
            String posVar = "pos" + n;
            compiler.declare(Int64Value.class, lastVar, "new Int64Value(" + extentVar + ".getLength())", true);
            compiler.pushContextSizeVariable(lastVar);
            String ivar = "i" + n;
            compiler.emit("for (int " + ivar + "=0; " + ivar + "<" + extentVar + ".getLength(); " + ivar + "++) {");
            String itemVar = (isNodeSequence ? "node" : "item") + n;
            compiler.declare(Item.class, itemVar, extentVar + ".itemAt(" + ivar + ")", true);
            compiler.pushContextItemVariable(itemVar);
            if (keepPosition) {
                compiler.declare(Int64Value.class, posVar, "new Int64Value(" + ivar + "+1)", true);
                compiler.pushContextPositionVariable(posVar);
            }
            String varName = "b" + compiler.getUniqueNumber();
            String b = compiler.compileToEffectiveBooleanValue(exp.getFilter(), new JavaDeclaration(Boolean.TYPE, varName));
            compiler.emit("if (" + b + ") {");
            action.compileAction(compiler, itemVar);
            compiler.emit("}");
            compiler.popContextItemVariable();
            if (keepPosition) {
                compiler.popContextPositionVariable();
            }
            compiler.emit("}");
            compiler.popContextSizeVariable();
        } else {
            final String posVar = "position" + n;
            if (keepPosition) {
                compiler.declare(Int64Value.class, posVar, "IntegerValue.ZERO", false);
            }
            LoopAction outerAction = new LoopAction(){

                public void compileAction(CompilerService compiler, String itemVar) {
                    if (keepPosition) {
                        compiler.emit(posVar + " = Int64Value.makeIntegerValue(" + posVar + ".longValue()+1);");
                        compiler.pushContextPositionVariable(posVar);
                    }
                    compiler.pushContextItemVariable(itemVar);
                    String varName = "b" + compiler.getUniqueNumber();
                    String b = compiler.compileToEffectiveBooleanValue(exp.getFilter(), new JavaDeclaration(Boolean.TYPE, varName));
                    compiler.emit("if (" + b + ") {");
                    action.compileAction(compiler, itemVar);
                    compiler.emit("}");
                    compiler.popContextItemVariable();
                    if (keepPosition) {
                        compiler.popContextPositionVariable();
                    }
                }
            };
            compiler.compileAsLoop(exp.getControllingExpression(), outerAction);
        }
    }

    public String compileToItem(CompilerService compiler, Expression expr) {
        VariableReference ref;
        String varName;
        FilterExpression exp = (FilterExpression)expr;
        TypeHierarchy th = compiler.getTypeHierarchy();
        boolean isNodeSequence = th.isSubType(exp.getItemType(th), (ItemType)AnyNodeTest.getInstance());
        if (exp.isIndependentNumericFilter() && (exp.getFilter().getDependencies() & 0x1E) == 0 && exp.getControllingExpression() instanceof VariableReference && compiler.isInstance(varName = VariableReferenceCompiler.getJavaVariableName(compiler, ref = (VariableReference)exp.getControllingExpression()), ValueRepresentation.class)) {
            int n = compiler.getUniqueNumber();
            String indexVar = "i" + n;
            String itemVar = (isNodeSequence ? "node" : "item") + n;
            compiler.declare(NumericValue.class, indexVar, compiler.cast(compiler.compileToItem(exp.getFilter()), NumericValue.class), true);
            compiler.declare(Item.class, itemVar, "Value.asValue(" + varName + ").itemAt((int)" + compiler.cast(indexVar, NumericValue.class) + ".longValue() - 1)", true);
            return itemVar;
        }
        return super.compileToItem(compiler, expr);
    }

    public void compilePush(CompilerService compiler, Expression expr) {
        final FilterExpression exp = (FilterExpression)expr;
        Expression filter = exp.getFilter();
        TypeHierarchy th = compiler.getTypeHierarchy();
        ItemType filterType = filter.getItemType(th);
        if ((filter.getDependencies() & 8) != 0) {
            super.compilePush(compiler, expr);
        } else if (th.isSubType(filterType, (ItemType)BuiltInAtomicType.BOOLEAN) || th.isSubType(filterType, (ItemType)AnyNodeTest.getInstance())) {
            final boolean keepPosition = (filter.getDependencies() & 4) != 0;
            int n = compiler.getUniqueNumber();
            final String posVar = "position" + n;
            if (keepPosition) {
                compiler.declare(Int64Value.class, posVar, "IntegerValue.ZERO", false);
            }
            LoopAction action = new LoopAction(){

                public void compileAction(CompilerService compiler, String itemVar) {
                    if (keepPosition) {
                        compiler.emit(posVar + " = Int64Value.makeIntegerValue(" + posVar + ".longValue()+1);");
                        compiler.pushContextPositionVariable(posVar);
                    }
                    compiler.pushContextItemVariable(itemVar);
                    String varName = "b" + compiler.getUniqueNumber();
                    String b = compiler.compileToEffectiveBooleanValue(exp.getFilter(), new JavaDeclaration(Boolean.TYPE, varName));
                    compiler.emit("if (" + b + ") {");
                    compiler.emit(compiler.getOutputterVariableName() + ".append(" + itemVar + ", 0, NodeInfo.ALL_NAMESPACES);");
                    compiler.emit("}");
                    compiler.popContextItemVariable();
                    if (keepPosition) {
                        compiler.popContextPositionVariable();
                    }
                }
            };
            compiler.compileAsLoop(exp.getControllingExpression(), action);
        } else {
            super.compilePush(compiler, expr);
        }
    }
}

