/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.value.Cardinality;

public class EscapeURICompiler
extends SingletonExpressionCompiler {
    public String compileToCharSequence(CompilerService compiler, Expression expr) {
        EscapeURI exp = (EscapeURI)expr;
        Expression[] operands = exp.getArguments();
        int operation = exp.getDetails().opcode;
        int n = compiler.getUniqueNumber();
        String resultVar = "esc" + n;
        boolean conditional = false;
        String argVar = compiler.compileToCharSequence(operands[0]);
        if (Cardinality.allowsZero((int)operands[0].getCardinality())) {
            conditional = true;
            compiler.declare(CharSequence.class, resultVar, null, false);
            compiler.emit("if (" + argVar + " == null) {");
            compiler.emit(resultVar + " = \"\";");
            compiler.emit("} else {");
        }
        String valueExpression = null;
        switch (operation) {
            case 1: {
                valueExpression = "EscapeURI.escape(" + argVar + ", \"-_.~\")";
                break;
            }
            case 2: {
                valueExpression = "EscapeURI.iriToUri(" + argVar + ")";
                break;
            }
            case 3: {
                valueExpression = "HTMLURIEscaper.escapeURL(" + argVar + ", false)";
            }
        }
        if (conditional) {
            compiler.assign(resultVar, valueExpression);
            compiler.emit("}");
        } else {
            compiler.declare(CharSequence.class, resultVar, valueExpression, true);
        }
        return resultVar;
    }

    public String compileToItem(CompilerService compiler, Expression expr) {
        String csVar = this.compileToCharSequence(compiler, expr);
        return "new StringValue(" + csVar + ")";
    }
}

