/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SequenceExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.expr.sort.GlobalOrderComparer;
import net.sf.saxon.expr.sort.LocalOrderComparer;
import net.sf.saxon.expr.sort.NodeOrderComparer;
import net.sf.saxon.om.SequenceIterator;

public class DocumentSorterCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        DocumentSorter exp = (DocumentSorter)expr;
        Expression base = exp.getBaseExpression();
        NodeOrderComparer comp = exp.getComparer();
        String baseIter = compiler.compileToIterator(base);
        return DocumentSorterCompiler.compileToIterator(compiler, comp, baseIter);
    }

    protected static String compileToIterator(CompilerService compiler, NodeOrderComparer comp, String baseIter) {
        String compExp;
        if (comp instanceof LocalOrderComparer) {
            compExp = "LocalOrderComparer.getInstance()";
        } else if (comp instanceof GlobalOrderComparer) {
            compExp = "GlobalOrderComparer.getInstance()";
        } else {
            throw new UnsupportedOperationException("Unknown kind of document order comparer");
        }
        String var = "s" + compiler.getUniqueNumber();
        compiler.declare(SequenceIterator.class, var, "new DocumentOrderIterator(" + baseIter + ", " + compExp + ")", true);
        return var;
    }
}

