/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.tree.tiny.TinyBuilder;

public class DocumentInstrCompiler
extends SingletonExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        String schemaTypeVar;
        DocumentInstr exp = (DocumentInstr)expr;
        int n = compiler.getUniqueNumber();
        String resultVar = "doc" + n;
        int validation = exp.getValidationMode();
        String pipeVar = "pipe" + n;
        compiler.emitComment("create document node");
        compiler.declare(XPathContext.class, "c" + n, compiler.getContextVariableName() + ".newMinorContext()", true);
        compiler.pushContextVariable("c" + n);
        compiler.declare(TinyBuilder.class, "builder" + n, "new TinyBuilder()", false);
        compiler.emit("builder" + n + ".setBaseURI(" + CompilerService.javaEscape(exp.getBaseURI()) + ");");
        compiler.declare(PipelineConfiguration.class, "pipe" + n, compiler.getContextVariableName() + ".getController().makePipelineConfiguration();", true);
        compiler.emit(pipeVar + ".setHostLanguage(Configuration.XQUERY);");
        compiler.emit("builder" + n + ".setPipelineConfiguration(" + pipeVar + ");");
        if (exp.getSchemaType() == null) {
            schemaTypeVar = "null";
        } else {
            String ncVar = compiler.declareNameCode(exp.getSchemaType().getFingerprint());
            schemaTypeVar = "config.getSchemaType(" + ncVar + ")";
        }
        compiler.emit("c" + n + ".changeOutputDestination(builder" + n + ", false, " + validation + ", " + schemaTypeVar + ");");
        compiler.declare(SequenceReceiver.class, "out" + n, "c" + n + ".getReceiver()", true);
        compiler.pushOutputterVariable("out" + n);
        compiler.emit("out" + n + ".open();");
        compiler.emit("out" + n + ".startDocument(0);");
        compiler.compilePush(exp.getContentExpression());
        compiler.emit("out" + n + ".endDocument();");
        compiler.emit("out" + n + ".close();");
        compiler.popOutputterVariable();
        compiler.declare(DocumentInfo.class, resultVar, "(DocumentInfo)builder" + n + ".getCurrentRoot()", true);
        compiler.popContextVariable();
        return resultVar;
    }
}

