/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.ValueCompiler;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.Value;

public class DecimalValueCompiler
extends ValueCompiler {
    public String compileToEffectiveBooleanValue(CompilerService compiler, Value expr, ReturnAction result) {
        compiler.emit(result.output(compiler, ((DecimalValue)expr).compareTo(0L) == 0 ? "false" : "true"));
        return result.getVariableName();
    }

    public String toJavaExpression(AtomicValue value, CompilerService compiler) {
        AtomicType type = ((DecimalValue)value).getTypeLabel();
        if (type.equals(BuiltInAtomicType.DECIMAL)) {
            return "new DecimalValue(new java.math.BigDecimal(\"" + value.getStringValueCS() + "\"))";
        }
        return "new DecimalValue(new java.math.BigDecimal(\"" + value.getStringValueCS() + "\")," + compiler.compileItemType((ItemType)type) + ")";
    }
}

