/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.functions.Count;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.Value;

public class CountCompiler
extends SingletonExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        String xpathVar;
        Count exp = (Count)expr;
        Expression[] operands = exp.getArguments();
        int n = compiler.getUniqueNumber();
        String resultVar = "count" + n;
        Expression operand = operands[0];
        if (operand instanceof LocalVariableReference && compiler.isInstance(xpathVar = compiler.getXPathVariableName(((LocalVariableReference)operand).getSlotNumber()), Value.class)) {
            compiler.declare(Int64Value.class, resultVar, "new Int64Value(" + xpathVar + ".getLength())", true);
            return resultVar;
        }
        if (!Cardinality.allowsMany((int)operand.getCardinality())) {
            String itemVar = compiler.compileToItem(operand);
            compiler.declare(Int64Value.class, resultVar, "(" + itemVar + "==null ? IntegerValue.ZERO : IntegerValue.PLUS_ONE)", true);
        } else {
            final String countVar = "counter" + n;
            compiler.declare(Long.TYPE, countVar, "0L", false);
            LoopAction action = new LoopAction(){

                public void compileAction(CompilerService compiler, String itemVar) {
                    compiler.emit(countVar + "++;");
                }
            };
            compiler.compileAsLoop(operand, action);
            compiler.declare(Int64Value.class, resultVar, "new Int64Value(" + countVar + ")", false);
        }
        return resultVar;
    }
}

