/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.PushExpressionCompiler;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.CopyOf;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;

public class CopyOfCompiler
extends PushExpressionCompiler {
    public void compilePush(CompilerService compiler, Expression expr) {
        final CopyOf exp = (CopyOf)expr;
        Expression select = exp.getSelectExpression();
        TypeHierarchy th = compiler.getTypeHierarchy();
        ItemType itemType = select.getItemType(th);
        final boolean isAtomic = th.isSubType(itemType, (ItemType)BuiltInAtomicType.ANY_ATOMIC);
        final boolean isNode = th.isSubType(itemType, Type.NODE_TYPE);
        final boolean either = !isNode && !isAtomic;
        final int kind = isNode ? itemType.getPrimitiveType() : 632;
        final boolean mustBeDocumentOrElement = exp.isDocumentOrElementRequired();
        final boolean singleKind = isAtomic || kind == 9 || kind == 1 || kind == 2 || kind == 3 || kind == 8 || kind == 7 || kind == 13;
        final boolean copyNamespaces = exp.isCopyNamespaces();
        LoopAction action = new LoopAction(){

            public void compileAction(CompilerService compiler, String itemVar) {
                if (singleKind) {
                    switch (kind) {
                        case 9: {
                            CopyOfCompiler.this.compileDocumentCopy(compiler, exp, itemVar, copyNamespaces);
                            break;
                        }
                        case 1: {
                            CopyOfCompiler.this.compileElementCopy(compiler, exp, itemVar, copyNamespaces);
                            break;
                        }
                        case 2: {
                            CopyOfCompiler.this.compileAttributeCopy(compiler, itemVar);
                            break;
                        }
                        case 3: {
                            CopyOfCompiler.this.compileTextCopy(compiler, itemVar);
                            break;
                        }
                        case 8: {
                            CopyOfCompiler.this.compileCommentCopy(compiler, itemVar);
                            break;
                        }
                        case 7: {
                            CopyOfCompiler.this.compileProcessingInstructionCopy(compiler, itemVar);
                            break;
                        }
                        case 13: {
                            CopyOfCompiler.this.compileNamespaceCopy(compiler, itemVar);
                            break;
                        }
                        case 632: {
                            CopyOfCompiler.this.compileAtomicCopy(compiler, itemVar);
                        }
                    }
                } else {
                    if (either) {
                        compiler.emit("if (" + itemVar + " instanceof NodeInfo) {");
                    }
                    if (either || isNode) {
                        compiler.emit("switch (((NodeInfo)" + itemVar + ").getNodeKind()) {");
                        compiler.emit("case Type.DOCUMENT: {");
                        CopyOfCompiler.this.compileDocumentCopy(compiler, exp, itemVar, copyNamespaces);
                        compiler.emit("break;");
                        compiler.emit("}");
                        compiler.emit("case Type.ELEMENT: {");
                        CopyOfCompiler.this.compileElementCopy(compiler, exp, itemVar, copyNamespaces);
                        compiler.emit("break;");
                        compiler.emit("}");
                        compiler.emit("case Type.ATTRIBUTE: {");
                        if (mustBeDocumentOrElement) {
                            compiler.emitDynamicError("validate{} expression cannot be applied to an attribute node", "XQTY0030");
                        } else {
                            CopyOfCompiler.this.compileAttributeCopy(compiler, itemVar);
                        }
                        compiler.emit("break;");
                        compiler.emit("}");
                        compiler.emit("case Type.TEXT: {");
                        if (mustBeDocumentOrElement) {
                            compiler.emitDynamicError("validate{} expression cannot be applied to a text node", "XQTY0030");
                        } else {
                            CopyOfCompiler.this.compileTextCopy(compiler, itemVar);
                        }
                        compiler.emit("break;");
                        compiler.emit("}");
                        compiler.emit("case Type.COMMENT: {");
                        if (mustBeDocumentOrElement) {
                            compiler.emitDynamicError("validate{} expression cannot be applied to a comment node", "XQTY0030");
                        } else {
                            CopyOfCompiler.this.compileCommentCopy(compiler, itemVar);
                        }
                        compiler.emit("break;");
                        compiler.emit("}");
                        compiler.emit("case Type.PROCESSING_INSTRUCTION: {");
                        if (mustBeDocumentOrElement) {
                            compiler.emitDynamicError("validate{} expression cannot be applied to a processing instruction node", "XQTY0030");
                        } else {
                            CopyOfCompiler.this.compileProcessingInstructionCopy(compiler, itemVar);
                        }
                        compiler.emit("break;");
                        compiler.emit("}");
                        compiler.emit("case Type.NAMESPACE: {");
                        if (mustBeDocumentOrElement) {
                            compiler.emitDynamicError("validate{} expression cannot be applied to a namespace node", "XQTY0030");
                        } else {
                            CopyOfCompiler.this.compileNamespaceCopy(compiler, itemVar);
                        }
                        compiler.emit("break;");
                        compiler.emit("}");
                        compiler.emit("}");
                    }
                    if (either) {
                        compiler.emit("} else {");
                    }
                    if (either || isAtomic) {
                        CopyOfCompiler.this.compileAtomicCopy(compiler, itemVar);
                    }
                    if (either) {
                        compiler.emit("}");
                    }
                }
            }
        };
        compiler.compileAsLoop(select, action);
    }

    private void compileDocumentCopy(CompilerService compiler, CopyOf exp, String itemVar, boolean copyNamespaces) {
        boolean needToPopOutputter = this.prepareValidator(compiler, exp, itemVar, false);
        String ns = copyNamespaces ? "CopyOptions.ALL_NAMESPACES" : "0";
        compiler.emit("try {");
        compiler.emit(compiler.cast(itemVar, NodeInfo.class) + ".copy(" + compiler.getOutputterVariableName() + ", " + ns + ", 0);");
        compiler.emit("} catch (CopyNamespaceSensitiveException e) {");
        compiler.emit("e.setErrorCode(\"" + (compiler.isXSLT() ? "XTTE0950" : "XQTY0086") + "\");");
        compiler.emit("throw e;");
        compiler.emit("}");
        if (needToPopOutputter) {
            compiler.popOutputterVariable();
        }
    }

    private void compileElementCopy(CompilerService compiler, CopyOf exp, String itemVar, boolean copyNamespaces) {
        boolean needToPopOutputter = this.prepareValidator(compiler, exp, itemVar, true);
        String ns = copyNamespaces ? "CopyOptions.ALL_NAMESPACES" : "0";
        compiler.emit("try {");
        compiler.emit(compiler.cast(itemVar, NodeInfo.class) + ".copy(" + compiler.getOutputterVariableName() + ", " + ns + ", 0);");
        compiler.emit("} catch (CopyNamespaceSensitiveException e) {");
        compiler.emit("e.setErrorCode(\"" + (compiler.isXSLT() ? "XTTE0950" : "XQTY0086") + "\");");
        compiler.emit("throw e;");
        compiler.emit("}");
        if (needToPopOutputter) {
            compiler.popOutputterVariable();
        }
    }

    private boolean prepareValidator(CompilerService compiler, CopyOf exp, String itemVar, boolean isElement) {
        int n = compiler.getUniqueNumber();
        String typeVar = null;
        SchemaType type = exp.getSchemaType();
        if (type != null) {
            typeVar = compiler.compileSchemaType(type);
        }
        boolean needToPopOutputter = false;
        String outVar = compiler.getOutputterVariableName();
        int valMode = exp.getValidationMode();
        if (valMode != 3) {
            String out2Var = "out" + n;
            if (isElement) {
                compiler.declare(SequenceReceiver.class, out2Var, "config.getElementValidator(" + outVar + ", " + compiler.cast(itemVar, NodeInfo.class) + ".getNameCode(), " + exp.getLocationId() + ", " + (type == null ? "null" : typeVar) + ", " + valMode + ")", false);
            } else {
                compiler.declare(Receiver.class, out2Var, "config.getDocumentValidator(" + outVar + ", " + compiler.cast(itemVar, NodeInfo.class) + ".getBaseURI(), " + valMode + ", Whitespace.NONE, " + (type == null ? "null" : typeVar) + ", -1)", false);
            }
            compiler.pushOutputterVariable(out2Var);
            needToPopOutputter = true;
            compiler.emit("if (" + out2Var + " != " + outVar + ") {");
            compiler.emit(out2Var + " = new TreeReceiver(" + out2Var + ");");
            compiler.emit(out2Var + ".setPipelineConfiguration(" + outVar + ".getPipelineConfiguration());");
            compiler.emit("}");
            compiler.emit("if (" + out2Var + ".getSystemId() == null) {");
            compiler.emit(out2Var + ".setSystemId(" + compiler.cast(itemVar, NodeInfo.class) + ".getBaseURI()" + ");");
            compiler.emit("}");
        }
        return needToPopOutputter;
    }

    private void compileAttributeCopy(CompilerService compiler, String itemVar) {
        compiler.emit("try {");
        int options = compiler.isXSLT() ? 0 : 32;
        compiler.emit(compiler.getOutputterVariableName() + ".attribute(" + compiler.cast(itemVar, NodeInfo.class) + ".getNameCode(), " + "StandardNames.XS_UNTYPED_ATOMIC, " + compiler.cast(itemVar, NodeInfo.class) + ".getStringValueCS(), " + "0, " + options + ");");
        compiler.emit("} catch (NoOpenStartTagException err) {");
        compiler.emit("XPathException e = new XPathException(err.getMessage());");
        compiler.emit("e.setErrorCode(err.getErrorCodeLocalPart());");
        compiler.emit("throw e;");
        compiler.emit("}");
    }

    private void compileTextCopy(CompilerService compiler, String itemVar) {
        compiler.emit(compiler.getOutputterVariableName() + ".characters(" + compiler.cast(itemVar, NodeInfo.class) + ".getStringValueCS(), " + "0, 0);");
    }

    private void compileCommentCopy(CompilerService compiler, String itemVar) {
        compiler.emit(compiler.getOutputterVariableName() + ".comment(" + compiler.cast(itemVar, NodeInfo.class) + ".getStringValueCS(), " + "0, 0);");
    }

    private void compileProcessingInstructionCopy(CompilerService compiler, String itemVar) {
        compiler.emit(compiler.getOutputterVariableName() + ".processingInstruction(" + compiler.cast(itemVar, NodeInfo.class) + ".getDisplayName(), " + compiler.cast(itemVar, NodeInfo.class) + ".getStringValueCS(), " + "0, 0);");
    }

    private void compileNamespaceCopy(CompilerService compiler, String itemVar) {
        compiler.emit("try {");
        compiler.emit(compiler.cast(itemVar, NodeInfo.class) + ".copy( " + compiler.getOutputterVariableName() + ", 0, 0);");
        compiler.emit("} catch (NoOpenStartTagException err) {");
        compiler.emit("XPathException e = new XPathException(err.getMessage());");
        compiler.emit("e.setErrorCode(err.getErrorCodeLocalPart());");
        compiler.emit("throw e;");
        compiler.emit("}");
    }

    private void compileAtomicCopy(CompilerService compiler, String itemVar) {
        compiler.emit(compiler.getOutputterVariableName() + ".append(" + itemVar + ", " + "0, 0);");
    }
}

