/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ExpressionCompiler;
import com.saxonica.codegen.ReturnAction;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;

public class ContextItemCompiler
extends ExpressionCompiler {
    public void compilePush(CompilerService compiler, Expression expr) {
        String origin = ContextItemCompiler.compileGetContextItem(compiler);
        String outVar = compiler.getOutputterVariableName();
        compiler.emit(outVar + ".append(" + origin + ", 0, NodeInfo.ALL_NAMESPACES);");
    }

    public String compileToIterator(CompilerService compiler, Expression expr) {
        String origin = ContextItemCompiler.compileGetContextItem(compiler);
        String var = "s" + compiler.getUniqueNumber();
        compiler.declare(SequenceIterator.class, var, "SingletonIterator.makeIterator(" + origin + ")", true);
        return var;
    }

    public String compileToItem(CompilerService compiler, Expression expr) {
        return ContextItemCompiler.compileGetContextItem(compiler);
    }

    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression expr, ReturnAction result) {
        String origin = ContextItemCompiler.compileGetContextItem(compiler);
        compiler.emit(result.output(compiler, "ExpressionTool.effectiveBooleanValue(SingletonIterator.makeIterator(" + origin + "))"));
        return result.getVariableName();
    }

    public String compileToCharSequence(CompilerService compiler, Expression expr) {
        String origin = ContextItemCompiler.compileGetContextItem(compiler);
        String var = "s" + compiler.getUniqueNumber();
        compiler.declare(String.class, var, origin + ".getStringValue()", true);
        return var;
    }

    public static String compileGetContextNode(CompilerService compiler) {
        String origin = compiler.getContextItemVariableName();
        if (origin.startsWith("node")) {
            return compiler.cast(origin, NodeInfo.class);
        }
        return "getContextNode(" + origin + ")";
    }

    public static String compileGetContextItem(CompilerService compiler) {
        String origin = compiler.getContextItemVariableName();
        if (origin.equals("context.getContextItem()")) {
            compiler.emit("if (" + origin + " == null) {");
            compiler.emitDynamicError("The context item is undefined", "XPDY0002");
            compiler.emit("}");
        }
        return origin;
    }
}

