/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.ToBooleanCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.sort.SubstringMatcher;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.functions.Contains;
import net.sf.saxon.functions.EndsWith;
import net.sf.saxon.functions.StartsWith;
import net.sf.saxon.functions.SubstringAfter;
import net.sf.saxon.functions.SubstringBefore;
import net.sf.saxon.value.Cardinality;

public class ContainsCompiler
extends ToBooleanCompiler {
    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression expr, ReturnAction result) {
        CollatingFunction exp = (CollatingFunction)expr;
        int n = compiler.getUniqueNumber();
        String s0Var = "str0_" + n;
        String s1Var = "str1_" + n;
        String collVar = compiler.compileStringCollator(exp, 2);
        collVar = compiler.cast(collVar, SubstringMatcher.class);
        String item0Var = compiler.compileToItem(exp.getArguments()[0]);
        int card0 = exp.getArguments()[0].getCardinality();
        if (card0 == 8192) {
            compiler.declare(String.class, s0Var, "\"\"", true);
        } else if (Cardinality.allowsZero((int)card0)) {
            compiler.declare(String.class, s0Var, "(" + item0Var + " == null ? \"\" : " + item0Var + ".getStringValue())", true);
        } else {
            compiler.declare(String.class, s0Var, item0Var + ".getStringValue()", true);
        }
        String item1Var = compiler.compileToItem(exp.getArguments()[1]);
        int card1 = exp.getArguments()[1].getCardinality();
        if (card1 == 8192) {
            compiler.declare(String.class, s1Var, "\"\"", true);
        } else if (Cardinality.allowsZero((int)card1)) {
            compiler.declare(String.class, s1Var, "(" + item1Var + " == null ? \"\" : " + item1Var + ".getStringValue())", true);
        } else {
            compiler.declare(String.class, s1Var, item1Var + ".getStringValue()", true);
        }
        if (exp instanceof Contains) {
            compiler.emit(result.output(compiler, collVar + ".contains(" + s0Var + ", " + s1Var + ")"));
        } else if (exp instanceof StartsWith) {
            compiler.emit(result.output(compiler, collVar + ".startsWith(" + s0Var + ", " + s1Var + ")"));
        } else if (exp instanceof EndsWith) {
            compiler.emit(result.output(compiler, collVar + ".endsWith(" + s0Var + ", " + s1Var + ")"));
        } else if (exp instanceof SubstringAfter) {
            compiler.emit(result.output(compiler, "!" + collVar + ".substringAfter(" + s0Var + ", " + s1Var + ").equals(\"\")"));
        } else if (exp instanceof SubstringBefore) {
            compiler.emit(result.output(compiler, "!" + collVar + ".substringBefore(" + s0Var + ", " + s1Var + ").equals(\"\")"));
        } else {
            throw new UnsupportedOperationException("Unknown substring comparison function");
        }
        return result.getVariableName();
    }

    public String compileToItem(CompilerService compiler, Expression expr) {
        String resultVar = "m" + compiler.getUniqueNumber();
        compiler.emit("Item " + resultVar + ";");
        CollatingFunction exp = (CollatingFunction)expr;
        int n = compiler.getUniqueNumber();
        String s0Var = "str0_" + n;
        String s1Var = "str1_" + n;
        String collVar = compiler.compileStringCollator(exp, 2);
        collVar = compiler.cast(collVar, SubstringMatcher.class);
        String item0Var = compiler.compileToItem(exp.getArguments()[0]);
        int card0 = exp.getArguments()[0].getCardinality();
        item0Var = card0 == 8192 ? "\"\"" : (Cardinality.allowsZero((int)card0) ? "(" + item0Var + " == null ? \"\" : " + item0Var + ".getStringValue())" : item0Var + ".getStringValue()");
        compiler.declare(String.class, s0Var, item0Var, true);
        String item1Var = compiler.compileToItem(exp.getArguments()[1]);
        int card1 = exp.getArguments()[1].getCardinality();
        item1Var = card1 == 8192 ? "\"\"" : (Cardinality.allowsZero((int)card1) ? "(" + item1Var + " == null ? \"\" : " + item1Var + ".getStringValue())" : item1Var + ".getStringValue()");
        compiler.declare(String.class, s1Var, item1Var, true);
        if (exp instanceof Contains) {
            compiler.assign(resultVar, "BooleanValue.get(" + collVar + ".contains(" + s0Var + ", " + s1Var + "))");
        } else if (exp instanceof StartsWith) {
            compiler.assign(resultVar, "BooleanValue.get(" + collVar + ".startsWith(" + s0Var + ", " + s1Var + "))");
        } else if (exp instanceof EndsWith) {
            compiler.assign(resultVar, "BooleanValue.get(" + collVar + ".endsWith(" + s0Var + ", " + s1Var + "))");
        } else if (exp instanceof SubstringAfter) {
            compiler.assign(resultVar, "StringValue.makeStringValue(" + collVar + ".substringAfter(" + s0Var + ", " + s1Var + "))");
        } else if (exp instanceof SubstringBefore) {
            compiler.assign(resultVar, "StringValue.makeStringValue(" + collVar + ".substringBefore(" + s0Var + ", " + s1Var + "))");
        } else {
            throw new UnsupportedOperationException("Unknown substring comparison function");
        }
        return resultVar;
    }

    public String compileToCharSequence(CompilerService compiler, Expression expr) {
        CollatingFunction exp = (CollatingFunction)expr;
        if (exp instanceof SubstringAfter) {
            String afterValue = this.compileToItem(compiler, expr);
            return afterValue + ".getStringValue()";
        }
        if (exp instanceof SubstringBefore) {
            String beforeValue = this.compileToItem(compiler, expr);
            return beforeValue + ".getStringValue()";
        }
        return super.compileToCharSequence(compiler, expr);
    }
}

