/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.SingletonExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.Concat;
import net.sf.saxon.tree.util.FastStringBuffer;

public class ConcatCompiler
extends SingletonExpressionCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        return "new StringValue(" + this.compileToCharSequence(compiler, expr) + ")";
    }

    public String compileToCharSequence(CompilerService compiler, Expression expr) {
        Concat exp = (Concat)expr;
        int n = compiler.getUniqueNumber();
        String buffVar = "sb" + n;
        int estimate = 20 * exp.getNumberOfArguments();
        compiler.declare(FastStringBuffer.class, buffVar, "new FastStringBuffer(" + estimate + ")", true);
        for (int i = 0; i < exp.getNumberOfArguments(); ++i) {
            Expression arg = exp.getArguments()[i];
            String cs = compiler.compileToCharSequence(arg);
            if ("null".equals(cs)) continue;
            compiler.emit(buffVar + ".append(" + cs + ");");
        }
        return buffVar;
    }
}

