/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.PushExpressionCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ComputedElement;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class ComputedElementCompiler
extends PushExpressionCompiler {
    public void compilePush(CompilerService compiler, Expression expr) {
        ComputedElement exp = (ComputedElement)expr;
        int n = compiler.getUniqueNumber();
        compiler.emitComment("create element (computed)");
        Expression nameExp = exp.getNameExpression();
        Expression namespaceExp = exp.getNamespaceExpression();
        NamespaceResolver resolver = exp.getNamespaceResolver();
        String nameCodeVar = ComputedElementCompiler.compileComputedName(nameExp, namespaceExp, compiler, n, resolver, "element");
        int validation = exp.getValidationMode();
        int typeCode = validation == 3 ? 572 : 630;
        String typeCodeVar = "" + typeCode;
        String outVar = compiler.getOutputterVariableName();
        String pipeVar = "pipe" + n;
        if (!exp.isPreservingTypes()) {
            String schemaTypeVar;
            if (exp.getSchemaType() == null) {
                schemaTypeVar = "null";
            } else {
                typeCodeVar = compiler.declareNameCode(exp.getSchemaType().getFingerprint()) + " & NamePool.FP_MASK";
                schemaTypeVar = "config.getSchemaType(" + typeCodeVar + ")";
            }
            compiler.emit("Receiver validator = config.getElementValidator(" + outVar + ", " + nameCodeVar + ", " + exp.getLocationId() + ", " + schemaTypeVar + ", " + validation + ");");
            String c2Var = "c" + n;
            compiler.declare(XPathContext.class, c2Var, compiler.getContextVariableName(), false);
            compiler.pushContextVariable(c2Var);
            compiler.emit("if (validator != " + outVar + ") {");
            compiler.assign(c2Var, c2Var + ".newMinorContext()");
            compiler.assign(outVar, "new TreeReceiver(validator)");
            compiler.emit("final PipelineConfiguration " + pipeVar + " = " + compiler.getContextVariableName() + ".getController().makePipelineConfiguration();");
            compiler.emit(pipeVar + ".setHostLanguage(Configuration.XQUERY);");
            compiler.emit(outVar + ".setPipelineConfiguration(" + pipeVar + ");");
            compiler.emit(c2Var + ".setReceiver(" + outVar + ");");
            compiler.emit("}");
            if (exp.getBaseURI() != null) {
                compiler.emit("if (" + outVar + ".getSystemId() == null) {");
                compiler.emit(outVar + ".setSystemId(" + CompilerService.javaEscape(exp.getBaseURI()) + ");");
                compiler.emit("}");
            }
        }
        int properties = exp.isInheritNamespaces() ? 0 : 128;
        compiler.emit(outVar + ".startElement(" + nameCodeVar + ", " + typeCodeVar + ", " + exp.getLocationId() + ", " + properties + ");");
        compiler.compilePush(exp.getContentExpression());
        compiler.emit(outVar + ".endElement();");
        if (!exp.isPreservingTypes()) {
            compiler.popContextVariable();
        }
    }

    protected static String compileComputedName(Expression nameExp, Expression namespaceExp, CompilerService compiler, int n, NamespaceResolver resolver, String nodeKind) {
        Value nameVal = nameExp instanceof Literal ? ((Literal)nameExp).getValue() : null;
        String nameCodeVar = "nc" + n;
        TypeHierarchy th = compiler.getTypeHierarchy();
        ItemType nameItemType = nameExp.getItemType(th);
        if (nameVal instanceof StringValue && namespaceExp == null) {
            String[] parts;
            String rawName = ((StringValue)nameVal).getStringValue();
            try {
                parts = compiler.getConfiguration().getNameChecker().getQNameParts((CharSequence)rawName);
            }
            catch (QNameException err) {
                throw new IllegalArgumentException("Invalid QName for constructed " + nodeKind + ": " + (Object)((Object)err));
            }
            String uri = resolver.getURIForPrefix(parts[0], true);
            int nc = compiler.getNamePool().allocate(parts[0], uri, parts[1]);
            nameCodeVar = compiler.declareNameCode(nc);
        } else if (th.isSubType(nameItemType, (ItemType)BuiltInAtomicType.STRING) || nameItemType == BuiltInAtomicType.UNTYPED_ATOMIC) {
            String nameItemVar = compiler.compileToItem(nameExp);
            ComputedElementCompiler.computeNameAsString(n, compiler, nameCodeVar, true, nameItemVar, resolver, nodeKind);
        } else if (nameVal instanceof QNameValue) {
            QNameValue q = (QNameValue)nameVal;
            String prefix = q.getPrefix();
            String uri = q.getNamespaceURI();
            String local = q.getLocalName();
            if ("attribute".equals(nodeKind) && prefix.length() == 0) {
                prefix = uri.equals("http://www.w3.org/XML/1998/namespace") ? "xml" : "ns0";
            }
            int nc = compiler.getNamePool().allocate(prefix, uri, local);
            nameCodeVar = compiler.declareNameCode(nc);
        } else if (th.isSubType(nameItemType, (ItemType)BuiltInAtomicType.QNAME)) {
            String nameItemVar = compiler.compileToItem(nameExp);
            ComputedElementCompiler.computeNameAsQName(compiler, nameCodeVar, true, nameItemVar, nodeKind);
        } else {
            String nameItemVar = compiler.compileToItem(nameExp);
            compiler.emit("int nc" + n + " = -1;");
            compiler.emit("if (" + nameItemVar + " instanceof StringValue) {");
            ComputedElementCompiler.computeNameAsString(n, compiler, nameCodeVar, false, nameItemVar, resolver, nodeKind);
            compiler.emit("} else if (" + nameItemVar + " instanceof QNameValue) {");
            ComputedElementCompiler.computeNameAsQName(compiler, nameCodeVar, false, nameItemVar, nodeKind);
            compiler.emit("} else {");
            compiler.emitDynamicError("Name of " + nodeKind + " must be either a string or a QName", "XPTY0004");
            compiler.emit("}");
        }
        return nameCodeVar;
    }

    private static String computeNameAsQName(CompilerService compiler, String nameCodeVar, boolean declare, String nameItemVar, String nodeKind) {
        compiler.declare(QNameValue.class, nameCodeVar + "q", compiler.cast(nameItemVar, QNameValue.class), true);
        compiler.declare(String.class, nameCodeVar + "uri", nameCodeVar + "q.getNamespaceURI()", true);
        compiler.declare(String.class, nameCodeVar + "loc", nameCodeVar + "q.getLocalName()", true);
        if (nodeKind.equals("element")) {
            compiler.declare(String.class, nameCodeVar + "pfx", nameCodeVar + "q.getPrefix()", true);
        } else {
            compiler.declare(String.class, nameCodeVar + "pfx", nameCodeVar + "q.getPrefix()", false);
            compiler.emit("if (" + nameCodeVar + "pfx.length()==0) {");
            compiler.assign(nameCodeVar + "pfx", compiler.getContextVariableName() + ".getNamePool().suggestPrefixForURI(" + nameCodeVar + "uri)");
            compiler.emit("}");
        }
        String expr = compiler.getContextVariableName() + ".getNamePool().allocate(" + nameCodeVar + "pfx," + nameCodeVar + "uri," + nameCodeVar + "loc)";
        if (declare) {
            compiler.declare(Integer.TYPE, nameCodeVar, expr, true);
        } else {
            compiler.assign(nameCodeVar, expr);
        }
        return nameCodeVar;
    }

    private static void computeNameAsString(int n, CompilerService compiler, String nameCodeVar, boolean declare, String nameItemVar, NamespaceResolver resolver, String nodeKind) {
        String partsVar = "parts" + n;
        compiler.declare(String[].class, partsVar, null, false);
        compiler.emit("try {");
        compiler.emit(partsVar + " = config.getNameChecker().getQNameParts(" + nameItemVar + ".getStringValueCS());");
        compiler.emit("} catch (QNameException err) {");
        compiler.emitDynamicError("Invalid QName in " + nodeKind + " constructor", "XQDY0074");
        compiler.emit(partsVar + " = null;");
        compiler.emit("}");
        String nsContextVar = compiler.compileNamespaceContext(resolver);
        String uriVar = "uri" + n;
        String resolveExpr = nsContextVar + ".getURIForPrefix(" + partsVar + "[0], true)";
        compiler.declare(String.class, uriVar, resolveExpr, true);
        compiler.emit("if (" + uriVar + " == null ) {");
        compiler.emitDynamicError("Undeclared prefix in " + nodeKind + " constructor", "XQDY0074");
        compiler.emit("}");
        compiler.emit((declare ? "int " : "") + nameCodeVar + " = " + compiler.getContextVariableName() + ".getNamePool().allocate(" + partsVar + "[0], " + uriVar + ", " + partsVar + "[1]);");
    }

    public String getStaticBaseURI(Expression exp) {
        return ((ComputedElement)exp).getBaseURI();
    }
}

