/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerClassMapper;
import com.saxonica.codegen.ExpressionCompiler;
import com.saxonica.codegen.JavaVariable;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.ValueCompiler;
import com.saxonica.expr.IndexedValue;
import com.saxonica.expr.PathFinder;
import com.saxonica.schema.UserAtomicType;
import com.saxonica.validate.SchemaElementTest;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.CodeGeneratorService;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicSortComparer;
import net.sf.saxon.expr.sort.CalendarValueComparer;
import net.sf.saxon.expr.sort.CodepointCollatingComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.CollatingAtomicComparer;
import net.sf.saxon.expr.sort.ComparableAtomicValueComparer;
import net.sf.saxon.expr.sort.DecimalSortComparer;
import net.sf.saxon.expr.sort.DescendingComparer;
import net.sf.saxon.expr.sort.DoubleSortComparer;
import net.sf.saxon.expr.sort.EmptyGreatestComparer;
import net.sf.saxon.expr.sort.EqualityComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.expr.sort.IntHashSet;
import net.sf.saxon.expr.sort.NumericComparer;
import net.sf.saxon.expr.sort.TextComparer;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.functions.regex.RegularExpression;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.AnyChildNodeTest;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.PatternFinder;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerService
implements CodeGeneratorService {
    public static final int RETURN = 1;
    private Configuration config;
    private Executable executable;
    private String baseURI = null;
    private boolean servletMode = false;
    private String superClassName = null;
    private List<JavaVariable> instanceLevelDeclarations = new ArrayList<JavaVariable>(20);
    private HashMap<String, JavaVariable> pooledConstants = new HashMap(20);
    private IntHashSet namecodes = new IntHashSet(100);
    private IntHashSet namespaceCodes = new IntHashSet(100);
    private List<List<String>> namespaceContexts = new ArrayList<List<String>>(20);
    private HashMap<String, String> collations = new HashMap(20);
    private HashSet<StructuredQName> keyDefinitions = new HashSet();
    private IntHashSet declaredTypes = new IntHashSet(20);
    private HashMap<String, JavaVariable> globalVariables = new HashMap(100);
    private HashMap<String, JavaVariable> methodVariables = new HashMap(100);
    private HashMap<StructuredQName, GlobalVariable> externalVariables = new HashMap(20);
    private String[] xpathLocalVariableNames = new String[20];
    private int numberOfGlobalVariables = 0;
    private Stack<String> contextVariableStack = new Stack();
    private Stack<String> contextItemVariableStack = new Stack();
    private Stack<String> contextPositionVariableStack = new Stack();
    private Stack<String> contextSizeVariableStack = new Stack();
    private Stack<String> outputterVariableStack = new Stack();
    private int seq = 0;
    private int indentColumn = 0;
    private String indentSpaces = "                                                                         ";
    private PrintWriter writer;
    private String packageName;
    private String className;
    private static final boolean SHOW_PROVENANCE = false;
    private int sourceLineNumber = -1;
    private boolean convertUntypedAtomicParameters = false;
    private String[] knownPackages = new String[]{"com.saxonica.deploy", "net.sf.saxon", "net.sf.saxon.expr", "net.sf.saxon.event", "net.sf.saxon.functions", "net.sf.saxon.om", "net.sf.saxon.tree.iter", "net.sf.saxon.tree.util", "net.sf.saxon.pattern", "net.sf.saxon.expr.sort", "net.sf.saxon.type", "net.sf.saxon.value", "net.sf.saxon.serialize", "java.util", "java.lang"};
    private String[] knownClasses = new String[]{"net.sf.saxon.functions.regex.JRegularExpression", "net.sf.saxon.functions.regex.RegularExpression", "net.sf.saxon.trans.XPathException", "net.sf.saxon.trans.KeyDefinition", "net.sf.saxon.tree.tiny.TinyBuilder", "net.sf.saxon.expr.instruct.BlockIterator", "net.sf.saxon.expr.instruct.SavedNamespaceContext", "net.sf.saxon.expr.instruct.SlotManager", "com.saxonica.expr.IndexedValue", "com.saxonica.schema.UserAtomicType", "java.net.URI"};
    private HashMap<UserFunction, Integer> functionEvaluationModes = new HashMap(20);

    public void setServletMode(boolean onOrOff) {
        this.servletMode = onOrOff;
    }

    public void setConvertUntypedAtomicParameters(boolean un) {
        this.convertUntypedAtomicParameters = un;
    }

    public boolean isConvertUntypedAtomicParameters() {
        return this.convertUntypedAtomicParameters;
    }

    public boolean isInServletMode() {
        return this.servletMode;
    }

    public void setSuperClassName(String className) {
        this.superClassName = className;
    }

    public ExpressionCompiler makeExpressionCompiler(Expression exp) {
        ExpressionCompiler ec = ExpressionCompiler.makeExpressionCompiler(exp, this.config);
        int lineNumber = exp.getLineNumber();
        if (lineNumber != this.sourceLineNumber && lineNumber != -1) {
            this.emitComment("line " + lineNumber);
            this.sourceLineNumber = lineNumber;
        }
        return ec;
    }

    public ValueCompiler getValueCompiler(Value val) {
        ValueCompiler avc = CompilerClassMapper.map(val);
        if (avc == null) {
            throw new UnsupportedOperationException("No compiler exists for class " + val.getClass().getName());
        }
        return avc;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public void setExecutable(Executable exec) {
        this.executable = exec;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public TypeHierarchy getTypeHierarchy() {
        return this.config.getTypeHierarchy();
    }

    public boolean isXSLT() {
        return false;
    }

    public void setPrintWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public void setClassName(String packageName, String className) {
        this.packageName = packageName;
        this.className = className;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public int getUniqueNumber() {
        return this.seq++;
    }

    public void startMethod() {
        this.methodVariables.clear();
        this.xpathLocalVariableNames = new String[20];
    }

    public void endMethod() {
    }

    public void declare(Class declaredType, String name, String initializer, boolean isFinal) {
        JavaVariable jcv = new JavaVariable();
        jcv.declaredType = declaredType.getName();
        jcv.declaredClass = declaredType;
        jcv.name = name;
        jcv.body = initializer;
        jcv.isStatic = false;
        jcv.isFinal = isFinal;
        this.methodVariables.put(name, jcv);
        this.emit((isFinal ? "final " : "") + this.getClassName(declaredType) + " " + name + (initializer == null ? "" : " = " + initializer) + ";");
    }

    public void emitConditional(String condition, String thenStatement) {
        this.emit("if (" + condition + ") {");
        this.emit(thenStatement);
        this.emit("}");
    }

    public void setXPathVariableName(int slotNumber, String name) {
        if (slotNumber >= this.xpathLocalVariableNames.length) {
            String[] s2 = new String[slotNumber * 2];
            System.arraycopy(this.xpathLocalVariableNames, 0, s2, 0, this.xpathLocalVariableNames.length);
            this.xpathLocalVariableNames = s2;
        }
        this.xpathLocalVariableNames[slotNumber] = name;
    }

    public String getXPathVariableName(int slotNumber) {
        return this.xpathLocalVariableNames[slotNumber];
    }

    public void assign(String variable, String expression) {
        this.emit(variable + " = " + expression + ";");
    }

    public String generateLocalVariableDeclaration(Class declaredType, String name, String initializer, boolean isFinal) {
        JavaVariable existing;
        if (initializer != null && (existing = this.methodVariables.get(initializer)) != null && name.startsWith("variable") && declaredType.isAssignableFrom(existing.declaredClass)) {
            declaredType = existing.declaredClass;
        }
        JavaVariable jcv = new JavaVariable();
        jcv.declaredType = declaredType.getName();
        jcv.declaredClass = declaredType;
        jcv.name = name;
        jcv.body = initializer;
        jcv.isStatic = false;
        jcv.isFinal = isFinal;
        this.methodVariables.put(name, jcv);
        return (isFinal ? "final " : "") + this.getClassName(declaredType) + " " + name + (initializer == null ? "" : " = " + initializer) + ";";
    }

    public void registerLocalVariable(Class declaredType, String name) {
        JavaVariable jcv = new JavaVariable();
        jcv.declaredType = declaredType.getName();
        jcv.declaredClass = declaredType;
        jcv.name = name;
        jcv.body = null;
        jcv.isStatic = false;
        jcv.isFinal = true;
        this.methodVariables.put(name, jcv);
    }

    public String cast(String variable, Class target) {
        JavaVariable existing = this.methodVariables.get(variable);
        if (existing == null) {
            existing = this.globalVariables.get(variable);
        }
        if (existing == null) {
            return "((" + this.getClassName(target) + ")" + variable + ")";
        }
        if (target.isAssignableFrom(existing.declaredClass)) {
            return variable;
        }
        return "((" + this.getClassName(target) + ")" + variable + ")";
    }

    public boolean isInstance(String variable, Class target) {
        JavaVariable existing = this.methodVariables.get(variable);
        if (existing == null) {
            existing = this.globalVariables.get(variable);
        }
        return existing != null && target.isAssignableFrom(existing.declaredClass);
    }

    public void indent() {
        this.indentColumn += 4;
        if (this.indentSpaces.length() <= this.indentColumn) {
            this.indentSpaces = this.indentSpaces + this.indentSpaces;
        }
    }

    public void outdent() {
        this.indentColumn -= 4;
        if (this.indentColumn < 0) {
            throw new AssertionError((Object)"Too many closing braces!");
        }
    }

    public void pushContextVariable(String variableName) {
        this.contextVariableStack.push(variableName);
    }

    public void popContextVariable() {
        this.contextVariableStack.pop();
    }

    public void pushContextItemVariable(String variableName) {
        this.contextItemVariableStack.push(variableName);
    }

    public void popContextItemVariable() {
        this.contextItemVariableStack.pop();
    }

    public void pushContextPositionVariable(String variableName) {
        this.contextPositionVariableStack.push(variableName);
    }

    public void popContextPositionVariable() {
        this.contextPositionVariableStack.pop();
    }

    public void pushContextSizeVariable(String variableName) {
        this.contextSizeVariableStack.push(variableName);
    }

    public void popContextSizeVariable() {
        this.contextSizeVariableStack.pop();
    }

    public String getContextVariableName() {
        if (this.contextVariableStack.isEmpty()) {
            return "null";
        }
        return this.contextVariableStack.peek();
    }

    public String getContextItemVariableName() {
        try {
            return this.contextItemVariableStack.peek();
        }
        catch (Exception err) {
            throw new UnsupportedOperationException("context item used where it is undefined");
        }
    }

    public String getContextPositionVariableName() {
        try {
            return this.contextPositionVariableStack.peek();
        }
        catch (Exception err) {
            throw new UnsupportedOperationException("last() used where it is undefined");
        }
    }

    public String getContextSizeVariableName() {
        try {
            return this.contextSizeVariableStack.peek();
        }
        catch (Exception err) {
            throw new UnsupportedOperationException("last() used where it is undefined");
        }
    }

    public void pushOutputterVariable(String variableName) {
        this.outputterVariableStack.push(variableName);
    }

    public void popOutputterVariable() {
        this.outputterVariableStack.pop();
    }

    public String getOutputterVariableName() {
        return this.outputterVariableStack.peek();
    }

    public void emit(String s) {
        if (s.startsWith("}")) {
            this.outdent();
        }
        boolean open = false;
        boolean close = false;
        boolean inQuot = false;
        boolean inApos = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                inQuot = !inQuot;
                continue;
            }
            if (c == '\'') {
                inApos = !inApos;
                continue;
            }
            if (c == '{' && !inQuot && !inApos) {
                open = true;
                continue;
            }
            if (c != '}' || inQuot || inApos || i == 0) continue;
            close = true;
        }
        this.writer.println(this.indentSpaces.substring(0, this.indentColumn) + s.trim());
        if (open) {
            this.indent();
        }
        if (close) {
            this.outdent();
        }
    }

    public void emitComment(String s) {
        this.emit("\n// " + s);
    }

    public void emitDynamicError(String message, String code) {
        this.emit("dynamicError(" + CompilerService.javaEscape(message) + ", " + CompilerService.javaEscape(code) + ", " + this.getContextVariableName() + ");");
    }

    public void emitDynamicError(String message, StructuredQName code) {
        this.emit("dynamicError(" + CompilerService.javaEscape(message) + ", " + CompilerService.javaEscape(code.getLocalName()) + ", " + this.getContextVariableName() + ");");
    }

    public String declareNameCode(int nc) {
        this.namecodes.add(nc);
        return this.allocateJavaName(nc);
    }

    public String declareNamespaceCode(int nsc) {
        this.namespaceCodes.add(nsc);
        return "nsc" + nsc;
    }

    private String allocateJavaName(int nameCode) {
        FastStringBuffer sb = new FastStringBuffer(64);
        sb.append("nc" + nameCode + "_");
        this.appendJavaName(nameCode, sb);
        return sb.toString();
    }

    private void appendJavaName(int nameCode, FastStringBuffer sb) {
        String local = this.getNamePool().getLocalName(nameCode);
        this.appendJavaName(local, sb);
    }

    private void appendJavaName(String local, FastStringBuffer sb) {
        for (int i = 0; i < local.length(); ++i) {
            char c = local.charAt(i);
            if (c == '-' || c == '.') {
                c = '_';
            }
            if (c >= 127) continue;
            sb.append(c);
        }
    }

    public String makeValidJavaName(String name) {
        FastStringBuffer sb = new FastStringBuffer(name.length());
        this.appendJavaName(name, sb);
        return sb.toString();
    }

    public String emitInstanceVariable(Class type, String name, String initializer, int priority, boolean isStatic, boolean isFinal, String messageIfNull, String errorCodeIfNull) {
        if (isStatic && isFinal && name == null) {
            JavaVariable jcv = this.pooledConstants.get(initializer);
            if (jcv != null && jcv.declaredType.equals(type.getName())) {
                return jcv.name;
            }
            JavaVariable field = new JavaVariable();
            field.declaredType = type.getName();
            field.declaredClass = type;
            field.name = "constant" + this.getUniqueNumber();
            field.body = initializer;
            field.priority = priority;
            field.isStatic = isStatic;
            field.isFinal = isFinal;
            field.messageIfNull = messageIfNull;
            field.errorCodeIfNull = errorCodeIfNull;
            this.instanceLevelDeclarations.add(field);
            this.pooledConstants.put(initializer, field);
            this.globalVariables.put(field.name, field);
            return field.name;
        }
        JavaVariable field = new JavaVariable();
        field.declaredType = type.getName();
        field.declaredClass = type;
        field.name = name == null ? "var" + this.getUniqueNumber() : name;
        field.body = initializer;
        field.priority = priority;
        field.isStatic = isStatic;
        field.isFinal = isFinal;
        field.messageIfNull = messageIfNull;
        field.errorCodeIfNull = errorCodeIfNull;
        this.instanceLevelDeclarations.add(field);
        this.globalVariables.put(field.name, field);
        return field.name;
    }

    public String collationVariable(String uri) {
        String var = this.collations.get(uri);
        if (var == null) {
            int n = this.getUniqueNumber();
            var = "collation" + n;
            this.collations.put(uri, var);
            this.emitInstanceVariable(StringCollator.class, var, "config.getCollationURIResolver().resolve(uri, \"\", config)", 3, false, false, null, null);
        }
        return var;
    }

    public void prologue(boolean mainModule) {
        String superclass;
        if (this.writer == null) {
            this.writer = new PrintWriter(System.out);
        }
        if (mainModule) {
            int p;
            if (this.packageName != null && this.packageName.length() != 0) {
                this.emit("package " + this.packageName + ";");
                this.emit("");
            }
            for (p = 0; p < this.knownPackages.length; ++p) {
                this.emit("import " + this.knownPackages[p] + ".*;");
            }
            for (p = 0; p < this.knownClasses.length; ++p) {
                this.emit("import " + this.knownClasses[p] + ";");
            }
            this.emit("");
            superclass = this.superClassName;
            if (superclass == null) {
                superclass = this.servletMode ? "com.saxonica.deploy.CompiledQueryServlet" : "com.saxonica.deploy.CompiledUserQuery";
            }
        } else {
            throw new UnsupportedOperationException("Library modules not yet supported");
        }
        this.emit("public class " + this.className + " extends " + superclass + " {");
        this.emit("");
    }

    private Class getDeclaredClassForVariable(GlobalVariable decl) {
        if (decl.getEvaluationMode() == 12) {
            return IndexedValue.class;
        }
        Expression exp = decl.getSelectExpression();
        if (exp != null) {
            boolean allowsMany = Cardinality.allowsMany((int)exp.getCardinality());
            if (exp instanceof Literal && ((Literal)exp).getValue() instanceof AtomicValue) {
                return AtomicValue.class;
            }
            if (allowsMany) {
                return ValueRepresentation.class;
            }
            return Item.class;
        }
        SequenceType declaredType = decl.getRequiredType();
        if (declaredType == null) {
            return ValueRepresentation.class;
        }
        boolean allowsMany = Cardinality.allowsMany((int)declaredType.getCardinality());
        if (allowsMany) {
            return ValueRepresentation.class;
        }
        ItemType itemType = declaredType.getPrimaryType();
        if (itemType.isAtomicType()) {
            return AtomicValue.class;
        }
        return Item.class;
    }

    public void compileImportedSchemata(Map<String, HashSet<String>> schemata) {
        this.emitComment("");
        this.emitComment("Load all schema documents that were imported into the XQuery source modules");
        this.emitComment("");
        this.startMethod();
        this.emit("public void importSchemata(Configuration config) throws SchemaException {");
        if (schemata != null) {
            this.declare(PipelineConfiguration.class, "pipe", "config.makePipelineConfiguration()", true);
            for (Map.Entry<String, HashSet<String>> e : schemata.entrySet()) {
                String targetNamespace = e.getKey();
                Collection hints = e.getValue();
                if (hints.isEmpty()) continue;
                this.emit("config.readMultipleSchemas(pipe, \"\", java.util.Arrays.asList(new String[] {");
                boolean first = true;
                for (String hint : hints) {
                    this.emit((first ? "  " : ", ") + CompilerService.javaEscape(hint));
                    first = false;
                }
                this.emit("}), " + CompilerService.javaEscape(targetNamespace) + ");");
            }
        }
        this.emit("}");
        this.endMethod();
    }

    public void compileGlobalVariable(GlobalVariable decl) {
        boolean allowsMany;
        Expression exp = decl.getSelectExpression();
        String varName = "global" + decl.getSlotNumber();
        Class declaredClass = this.getDeclaredClassForVariable(decl);
        if (exp != null) {
            allowsMany = Cardinality.allowsMany((int)exp.getCardinality());
        } else {
            SequenceType declaredType = decl.getRequiredType();
            boolean bl = allowsMany = declaredType == null || Cardinality.allowsMany((int)declaredType.getCardinality());
        }
        if (this.isInServletMode()) {
            ++this.numberOfGlobalVariables;
            if (decl instanceof GlobalParam) {
                this.externalVariables.put(decl.getVariableQName(), decl);
            }
            this.emitComment("");
            this.emitComment("declare variable " + decl.getVariableQName().getDisplayName() + " at line " + decl.getLineNumber());
            this.emitComment("");
            this.emit("private " + this.getClassName(declaredClass) + " " + varName + "(final XPathContext context) throws XPathException {");
            this.startMethod();
            this.pushContextVariable("context");
            this.pushContextItemVariable("context.getContextItem()");
            this.pushContextPositionVariable("IntegerValue.PLUS_ONE");
            if (!(decl instanceof GlobalParam) && exp instanceof Literal && ((Literal)exp).getValue() instanceof AtomicValue) {
                AtomicValue val = (AtomicValue)((Literal)exp).getValue();
                ValueCompiler vc = this.getValueCompiler((Value)val);
                this.emit("return " + vc.compileToItem(this, val) + ";");
            } else {
                String cast = declaredClass == ValueRepresentation.class ? "" : "(" + this.getClassName(declaredClass) + ")";
                this.declare(declaredClass, varName, cast + "context.getController().getBindery().getGlobalVariable(" + decl.getSlotNumber() + ")", false);
                this.emit("if (" + varName + " == null) {");
                if (exp == null) {
                    this.emitDynamicError("No value supplied for external variable " + decl.getVariableQName().getDisplayName(), "XPDY0002");
                } else {
                    if (exp instanceof Literal && ((Literal)exp).getValue() instanceof AtomicValue) {
                        AtomicValue val = (AtomicValue)((Literal)exp).getValue();
                        ValueCompiler vc = this.getValueCompiler((Value)val);
                        this.assign(varName, vc.compileToItem(this, val));
                    } else if (decl.isIndexedVariable() || decl.getEvaluationMode() == 12) {
                        String iterVar = this.compileToIterator(exp);
                        this.assign(varName, "new IndexedValue(" + iterVar + ")");
                    } else if (allowsMany) {
                        String iterVar = this.compileToIterator(exp);
                        this.assign(varName, "SequenceExtent.makeSequenceExtent(" + iterVar + ")");
                    } else {
                        String itemVar = this.compileToItem(exp);
                        this.assign(varName, itemVar);
                    }
                    this.emit("context.getController().getBindery().setGlobalVariable(" + decl.getSlotNumber() + ", " + varName + ");");
                }
                this.emit("}");
                this.emit("return " + varName + ";");
            }
            this.popContextVariable();
            this.popContextItemVariable();
            this.popContextPositionVariable();
            this.endMethod();
            this.emit("}");
        } else {
            if (decl instanceof GlobalParam) {
                if (exp == null) {
                    this.emitInstanceVariable(ValueRepresentation.class, varName, null, 3, false, false, null, null);
                }
                this.externalVariables.put(decl.getVariableQName(), decl);
            }
            if (exp != null) {
                String initializer;
                if (exp instanceof Literal && ((Literal)exp).getValue() instanceof AtomicValue) {
                    AtomicValue val = (AtomicValue)((Literal)exp).getValue();
                    ValueCompiler vc = this.getValueCompiler((Value)val);
                    initializer = vc.compileToItem(this, val);
                } else {
                    this.emitComment("");
                    this.emitComment("declare variable " + decl.getVariableQName().getDisplayName() + " at line " + decl.getLineNumber());
                    this.emitComment("");
                    this.emit("private " + this.getClassName(declaredClass) + " initialize_" + varName + "(final XPathContext context) throws XPathException {");
                    this.startMethod();
                    this.pushContextVariable("context");
                    this.pushContextItemVariable("context.getContextItem()");
                    this.pushContextPositionVariable("IntegerValue.PLUS_ONE");
                    if (allowsMany && (decl.isIndexedVariable() || decl.getEvaluationMode() == 12)) {
                        String iterVar = this.compileToIterator(exp);
                        this.emit("return new IndexedValue(" + iterVar + ");");
                    } else if (allowsMany) {
                        String iterVar = this.compileToIterator(exp);
                        this.emit("return SequenceExtent.makeSequenceExtent(" + iterVar + ");");
                    } else {
                        String itemVar = this.compileToItem(exp);
                        this.emit("return " + itemVar + ";");
                    }
                    this.popContextVariable();
                    this.popContextItemVariable();
                    this.popContextPositionVariable();
                    this.endMethod();
                    this.emit("}");
                    initializer = "initialize_" + varName + "(context)";
                }
                this.emitInstanceVariable(declaredClass, varName, initializer, 3, false, false, null, null);
            }
        }
    }

    public String getClassName(Class target) {
        int p;
        if (target.isArray()) {
            return this.getClassName(target.getComponentType()) + "[]";
        }
        String name = target.getName();
        int sep = name.lastIndexOf(46);
        if (sep < 0) {
            return name;
        }
        String packageName = name.substring(0, sep);
        for (p = 0; p < this.knownPackages.length; ++p) {
            if (!packageName.equals(this.knownPackages[p])) continue;
            return name.substring(sep + 1);
        }
        for (p = 0; p < this.knownClasses.length; ++p) {
            if (!name.equals(this.knownClasses[p])) continue;
            return name.substring(sep + 1);
        }
        return name;
    }

    public void compileFunction(XQueryFunction fn) {
        String v;
        this.emitComment("");
        this.emitComment("declare function " + fn.getDisplayName() + " at line " + fn.getLineNumber());
        this.emitComment("");
        UserFunction uf = fn.getUserFunction();
        String methodName = this.getMethodName(uf);
        int mode = this.getFunctionEvaluationMode(uf);
        boolean tailRecursive = uf.isTailRecursive();
        String returnClass = null;
        if (mode == 3) {
            returnClass = "SequenceIterator";
        } else if (mode == 7) {
            returnClass = "Item";
        } else if (mode == 9) {
            returnClass = "void";
        }
        String sfinal = tailRecursive ? "" : "final ";
        this.emit("private " + returnClass + " " + methodName + "(");
        this.indent();
        this.indent();
        this.startMethod();
        int arity = fn.getNumberOfArguments();
        for (int i = 0; i < arity; ++i) {
            String varName = "param" + i;
            this.setXPathVariableName(i, varName);
            StructuredQName varQName = (StructuredQName)fn.getUserFunction().getStackFrameMap().getVariableMap().get(i);
            String xpathName = "$" + varQName.getDisplayName();
            Class argClass = this.getJavaClassForFunctionParameter(uf, i);
            if (argClass == NodeInfo.class) {
                this.emit(sfinal + "NodeInfo " + varName + ",  // " + xpathName);
                this.registerLocalVariable(NodeInfo.class, varName);
                continue;
            }
            if (argClass == AtomicValue.class) {
                this.emit(sfinal + "AtomicValue " + varName + ",  // " + xpathName);
                this.registerLocalVariable(AtomicValue.class, varName);
                continue;
            }
            if (argClass == Item.class) {
                this.emit(sfinal + "Item " + varName + ",  // " + xpathName);
                this.registerLocalVariable(Item.class, varName);
                continue;
            }
            if (argClass == ValueRepresentation.class) {
                this.emit(sfinal + "ValueRepresentation " + varName + ",  // " + xpathName);
                this.registerLocalVariable(ValueRepresentation.class, varName);
                continue;
            }
            throw new IllegalArgumentException();
        }
        this.emit("    final XPathContext context) throws XPathException {");
        this.outdent();
        this.outdent();
        this.pushContextVariable("context");
        Expression exp = uf.getBody();
        if (mode == 8) {
            v = this.compileToValueRepresentation(exp);
            if (v != null) {
                this.emit("return " + v + ";");
            }
        } else if (mode == 3) {
            v = this.compileToIterator(exp);
            if (v != null) {
                this.emit("return " + v + ";");
            }
        } else if (mode == 7) {
            String itemVar = this.compileToItem(exp);
            if (itemVar != null) {
                this.emit("return " + itemVar + ";");
            }
        } else if (mode == 9) {
            this.declare(SequenceReceiver.class, "out", "context.getReceiver()", true);
            this.pushOutputterVariable("out");
            this.compilePush(exp);
            this.popOutputterVariable();
        }
        this.popContextVariable();
        this.endMethod();
        this.emit("}");
        this.emit("");
    }

    public Class getJavaClassForFunctionParameter(UserFunction fn, int i) {
        UserFunctionParameter p = fn.getParameterDefinitions()[i];
        ItemType argType = p.getRequiredType().getPrimaryType();
        int card = p.getRequiredType().getCardinality();
        if (card == 16384) {
            if (this.getTypeHierarchy().isSubType(argType, (ItemType)AnyNodeTest.getInstance())) {
                return NodeInfo.class;
            }
            if (this.getTypeHierarchy().isSubType(argType, (ItemType)BuiltInAtomicType.ANY_ATOMIC)) {
                return AtomicValue.class;
            }
            return Item.class;
        }
        return ValueRepresentation.class;
    }

    public String getMethodName(UserFunction fn) {
        FastStringBuffer sb = new FastStringBuffer(64);
        sb.append("fn");
        sb.append("_");
        this.appendJavaName(fn.getFunctionName().getLocalName(), sb);
        sb.append("_" + fn.getNumberOfArguments());
        short uriCode = this.getNamePool().getCodeForURI(fn.getFunctionName().getNamespaceURI());
        if (uriCode >= 0) {
            sb.append("_" + uriCode);
        }
        return sb.toString();
    }

    public int getFunctionEvaluationMode(UserFunction function) {
        Integer m = this.functionEvaluationModes.get(function);
        if (m != null) {
            return m;
        }
        int mode = -1;
        Expression exp = function.getBody();
        if (exp instanceof Instruction) {
            mode = 9;
        } else if (CompilerService.isCreativeAssignation(exp)) {
            mode = 9;
        } else {
            this.functionEvaluationModes.put(function, new Integer(-1));
            HashSet callees = new HashSet(20);
            function.gatherDirectContributingCallees(callees);
            for (UserFunction callee : callees) {
                if (callee == function || this.getFunctionEvaluationMode(callee) != 9) continue;
                mode = 9;
                break;
            }
        }
        if (mode == -1) {
            mode = Cardinality.allowsMany((int)exp.getCardinality()) ? 3 : 7;
        }
        this.functionEvaluationModes.put(function, new Integer(mode));
        return mode;
    }

    private static boolean isCreativeAssignation(Expression exp) {
        return exp instanceof Instruction && ((Instruction)exp).createsNewNodes() || exp instanceof Assignation && CompilerService.isCreativeAssignation(((Assignation)exp).getAction());
    }

    public void compileMainExpression(Expression exp) {
        this.startMethod();
        this.emitComment("");
        this.emitComment("Execute the query");
        this.emitComment("");
        this.emit("public void process(final XPathContext context) throws XPathException {");
        this.pushContextVariable("context");
        this.pushContextItemVariable("context.getContextItem()");
        this.pushContextPositionVariable("IntegerValue.PLUS_ONE");
        this.emit("SequenceReceiver out = context.getReceiver();");
        this.outputterVariableStack.push("out");
        this.compilePush(exp);
        this.emit("}");
        this.popContextVariable();
        this.popContextItemVariable();
        this.popContextPositionVariable();
        this.outputterVariableStack.pop();
        this.endMethod();
        this.emit("");
    }

    public void epilogue() {
        this.compileKeyDefinitionClasses();
        this.emit("");
        this.emit("GenericAtomicComparer defaultComparer;");
        for (int nc : this.namecodes) {
            this.emit("int " + this.allocateJavaName(nc) + ";");
        }
        for (int nsc : this.namespaceCodes) {
            this.emit("int nsc" + nsc + ";");
        }
        for (int i = 0; i < this.namespaceContexts.size(); ++i) {
            this.emit("NamespaceResolver namespaceContext" + (i + 1) + ";");
        }
        for (JavaVariable field : this.instanceLevelDeclarations) {
            this.emit((field.isFinal ? "final " : "") + (field.isStatic ? "static " : "") + this.getClassName(field.declaredClass) + " " + field.name + (field.isFinal ? " = " + field.body : "") + ";");
        }
        this.emit("");
        String binderyParam = this.isInServletMode() ? ", Controller controller" : "";
        String visibility = this.isInServletMode() ? "protected" : "public";
        this.emit(visibility + " void setExternalVariable(String clarkName, ValueRepresentation value" + binderyParam + ") {");
        if (!this.externalVariables.isEmpty()) {
            boolean firstExternal = true;
            for (StructuredQName qName : this.externalVariables.keySet()) {
                String clarkName = qName.getClarkName();
                this.emit((firstExternal ? "if" : "} else if") + " (clarkName.equals(" + CompilerService.javaEscape(clarkName) + ")) {");
                if (this.isInServletMode()) {
                    int slot = this.externalVariables.get(qName).getSlotNumber();
                    this.emit("controller.getBindery().setGlobalVariable(" + slot + ", value);");
                } else {
                    GlobalVariable decl = this.externalVariables.get(qName);
                    int slot = decl.getSlotNumber();
                    String varName = "global" + slot;
                    Class declaredClass = this.getDeclaredClassForVariable(decl);
                    String cast = declaredClass == ValueRepresentation.class ? "" : "(" + this.getClassName(declaredClass) + ")";
                    this.assign(varName, cast + "value");
                }
                firstExternal = false;
            }
            this.emit("}");
        }
        this.emit("}");
        this.emit("");
        String contextParam = this.isInServletMode() ? "" : "XPathContext context";
        this.emit("public void initializeGlobals(" + contextParam + ") throws XPathException {");
        this.startMethod();
        this.emit("defaultComparer = new GenericAtomicComparer(CodepointCollator.getInstance(), " + (this.isInServletMode() ? "null" : "context") + ");");
        NamePool pool = this.config.getNamePool();
        for (int nc : this.namecodes) {
            this.emit(this.allocateJavaName(nc) + " = namePool.allocate(" + CompilerService.javaEscape(pool.getPrefix(nc)) + ", " + CompilerService.javaEscape(pool.getURI(nc)) + ", " + CompilerService.javaEscape(pool.getLocalName(nc)) + ");");
        }
        for (int nsc : this.namespaceCodes) {
            this.emit("nsc" + nsc + " = namePool.allocateNamespaceCode(" + CompilerService.javaEscape(pool.getPrefixFromNamespaceCode(nsc)) + ", " + CompilerService.javaEscape(pool.getURIFromNamespaceCode(nsc)) + ");");
        }
        for (int i = 0; i < this.namespaceContexts.size(); ++i) {
            List<String> list = this.namespaceContexts.get(i);
            int n = this.getUniqueNumber();
            FastStringBuffer sb = new FastStringBuffer(256);
            sb.append("int[] codes" + n + " = {");
            for (int j = 0; j < list.size(); ++j) {
                if (j != 0) {
                    sb.append(", ");
                }
                sb.append(list.get(j));
            }
            sb.append("};");
            this.emit(sb.toString());
            this.emit("namespaceContext" + (i + 1) + " = new SavedNamespaceContext(codes" + n + ", namePool);");
        }
        this.outputInitializers(1);
        this.outputInitializers(2);
        this.compileKeyDefinitionSetters();
        this.emitComment("");
        this.emitComment(" Nametests and global variables");
        this.emitComment("");
        if (!this.isInServletMode() && !this.externalVariables.isEmpty()) {
            for (StructuredQName qName : this.externalVariables.keySet()) {
                ItemType required;
                GlobalVariable decl = this.externalVariables.get(qName);
                int slot = decl.getSlotNumber();
                String varName = "global" + slot;
                if (decl.getSelectExpression() == null) {
                    this.emit("if (" + varName + " == null) {");
                    this.emitDynamicError("External variable " + qName.getDisplayName() + " has not been given a value", "XPDY0002");
                    this.emit("}");
                }
                if (decl.getRequiredType().equals((Object)SequenceType.ANY_SEQUENCE)) continue;
                if (this.convertUntypedAtomicParameters && (required = decl.getRequiredType().getPrimaryType()).isAtomicType()) {
                    this.emit("if ( " + varName + " instanceof UntypedAtomicValue) {");
                    this.emit(varName + "= ((UntypedAtomicValue)" + varName + ").convert(" + this.compileItemType(required) + ", context);");
                    this.emit("}");
                }
                String seqType = this.compileSequenceType(decl.getRequiredType());
                this.emit("if (!" + seqType + ".matches(Value.asValue(" + varName + "), context.getConfiguration())) {");
                this.emitDynamicError("External variable " + qName.getDisplayName() + " has the wrong type", "XPTY0004");
                this.emit("}");
            }
        }
        this.outputInitializers(3);
        this.outputInitializers(4);
        this.outputInitializers(5);
        this.endMethod();
        this.emit("}");
        this.emit("");
        int statics = 0;
        for (JavaVariable field : this.instanceLevelDeclarations) {
            if (!field.isStatic || field.isFinal) continue;
            if (statics++ == 0) {
                this.emit("static {");
                this.startMethod();
            }
            this.emit(field.name + " = " + field.body + ";");
        }
        if (statics != 0) {
            this.endMethod();
            this.emit("}");
        }
        if (this.isInServletMode()) {
            this.emit("");
            this.emit("protected int getNumberOfGlobalVariables() {");
            this.emit("return " + this.numberOfGlobalVariables + ";");
            this.emit("}");
        }
        if (!this.isInServletMode()) {
            this.emit("");
            this.emit("public static void main(String[] args) throws Exception {");
            this.emit("new " + this.className + "().mainCommand(args);");
            this.emit("}");
        }
        this.emit("}");
        this.emitComment("Generated by Saxon-EE at " + new DateTimeValue((Calendar)new GregorianCalendar(), true).getStringValue() + (this.baseURI == null ? "" : " from " + this.baseURI));
        this.writer.close();
    }

    private void outputInitializers(int priority) {
        for (JavaVariable field : this.instanceLevelDeclarations) {
            if (field.priority != priority || field.isStatic || field.isFinal || field.body == null) continue;
            this.emit(field.name + " = " + field.body + ";");
            if (field.messageIfNull == null) continue;
            this.emit("if (" + field.name + "==null) {");
            this.emit("throw new XPathException(" + CompilerService.javaEscape(field.messageIfNull) + ");");
            this.emit("}");
        }
    }

    public void compilePush(Expression exp) {
        this.makeExpressionCompiler(exp).compilePush(this, exp);
    }

    public String compileToIterator(Expression exp) {
        ExpressionCompiler compiler = this.makeExpressionCompiler(exp);
        return compiler.compileToIterator(this, exp);
    }

    public void compileAsLoop(Expression exp, LoopAction action) {
        ExpressionCompiler compiler = this.makeExpressionCompiler(exp);
        compiler.compileAsLoop(this, exp, action);
    }

    public String compileToItem(Expression exp) {
        ExpressionCompiler compiler = this.makeExpressionCompiler(exp);
        return compiler.compileToItem(this, exp);
    }

    public String compileToEffectiveBooleanValue(Expression exp, ReturnAction action) {
        ExpressionCompiler compiler = this.makeExpressionCompiler(exp);
        return compiler.compileToEffectiveBooleanValue(this, exp, action);
    }

    public String compileToCharSequence(Expression exp) {
        ExpressionCompiler compiler = this.makeExpressionCompiler(exp);
        return compiler.compileToCharSequence(this, exp);
    }

    public String compileToValueRepresentation(Expression exp) {
        ExpressionCompiler compiler = this.makeExpressionCompiler(exp);
        return compiler.compileToValueRepresentation(this, exp);
    }

    public String compileItemType(ItemType type) {
        if (type instanceof NodeTest) {
            return this.compileNodeTest((NodeTest)type);
        }
        if (type instanceof BuiltInAtomicType) {
            int fp = ((BuiltInAtomicType)type).getFingerprint();
            return this.getBuiltInTypeVariable(fp);
        }
        if (type instanceof UserAtomicType) {
            int fp = ((UserAtomicType)type).getFingerprint();
            String ncVar = this.declareNameCode(fp);
            String varName = "type_" + this.allocateJavaName(fp);
            if (!this.declaredTypes.contains(fp)) {
                varName = this.emitInstanceVariable(UserAtomicType.class, varName, "(UserAtomicType)config.getSchemaType(" + ncVar + ")", 1, false, false, "Schema for type " + ((UserAtomicType)type).getDisplayName() + " has not been loaded", null);
                this.declaredTypes.add(fp);
            }
            return varName;
        }
        throw new UnsupportedOperationException("Can't compile ItemType " + type.getClass());
    }

    public String compileSequenceType(SequenceType type) {
        String itemType = this.compileItemType(type.getPrimaryType());
        int cardinality = type.getCardinality();
        return "SequenceType.makeSequenceType(" + itemType + ", " + cardinality + ")";
    }

    public String compileSchemaType(SchemaType stype) {
        if (stype instanceof AtomicType) {
            return this.compileItemType((ItemType)stype);
        }
        if (stype instanceof AnyType) {
            return "AnyNodeTest.getInstance()";
        }
        if (stype instanceof AnySimpleType) {
            return "AnySimpleType.getInstance()";
        }
        if (stype instanceof Untyped) {
            return "Untyped.getInstance()";
        }
        int fp = stype.getFingerprint();
        String ncVar = this.declareNameCode(fp);
        String varName = "type_" + this.allocateJavaName(fp);
        if (!this.declaredTypes.contains(fp)) {
            varName = this.emitInstanceVariable(SchemaType.class, varName, "config.getSchemaType(" + ncVar + "&NamePool.FP_MASK)", 1, false, false, "Schema for type " + stype.getDisplayName() + " has not been loaded", null);
            this.declaredTypes.add(fp);
        }
        return varName;
    }

    private String getBuiltInTypeVariable(int fp) {
        switch (fp) {
            case 513: {
                return "BuiltInAtomicType.STRING";
            }
            case 533: {
                return "BuiltInAtomicType.INTEGER";
            }
            case 515: {
                return "BuiltInAtomicType.DECIMAL";
            }
            case 517: {
                return "BuiltInAtomicType.DOUBLE";
            }
            case 516: {
                return "BuiltInAtomicType.FLOAT";
            }
            case 514: {
                return "BuiltInAtomicType.BOOLEAN";
            }
            case 521: {
                return "BuiltInAtomicType.DATE";
            }
            case 519: {
                return "BuiltInAtomicType.DATE_TIME";
            }
            case 520: {
                return "BuiltInAtomicType.TIME";
            }
            case 518: {
                return "BuiltInAtomicType.DURATION";
            }
            case 633: {
                return "BuiltInAtomicType.YEAR_MONTH_DURATION";
            }
            case 634: {
                return "BuiltInAtomicType.DAY_TIME_DURATION";
            }
            case 528: {
                return "BuiltInAtomicType.BASE64_BINARY";
            }
            case 527: {
                return "BuiltInAtomicType.HEX_BINARY";
            }
            case 530: {
                return "BuiltInAtomicType.QNAME";
            }
            case 531: {
                return "BuiltInAtomicType.NOTATION";
            }
            case 529: {
                return "BuiltInAtomicType.ANY_URI";
            }
            case 523: {
                return "BuiltInAtomicType.G_YEAR";
            }
            case 522: {
                return "BuiltInAtomicType.G_YEAR_MONTH";
            }
            case 526: {
                return "BuiltInAtomicType.G_MONTH";
            }
            case 524: {
                return "BuiltInAtomicType.G_MONTH_DAY";
            }
            case 525: {
                return "BuiltInAtomicType.G_DAY";
            }
            case 631: {
                return "BuiltInAtomicType.UNTYPED_ATOMIC";
            }
            case 632: {
                return "BuiltInAtomicType.ANY_ATOMIC";
            }
            case 635: {
                return "BuiltInAtomicType.NUMERIC";
            }
            case 534: {
                return "BuiltInAtomicType.NON_POSITIVE_INTEGER";
            }
            case 535: {
                return "BuiltInAtomicType.NEGATIVE_INTEGER";
            }
            case 536: {
                return "BuiltInAtomicType.LONG";
            }
            case 537: {
                return "BuiltInAtomicType.INT";
            }
            case 538: {
                return "BuiltInAtomicType.SHORT";
            }
            case 539: {
                return "BuiltInAtomicType.BYTE";
            }
            case 540: {
                return "BuiltInAtomicType.NON_NEGATIVE_INTEGER";
            }
            case 541: {
                return "BuiltInAtomicType.POSITIVE_INTEGER";
            }
            case 542: {
                return "BuiltInAtomicType.UNSIGNED_LONG";
            }
            case 543: {
                return "BuiltInAtomicType.UNSIGNED_INT";
            }
            case 544: {
                return "BuiltInAtomicType.UNSIGNED_SHORT";
            }
            case 545: {
                return "BuiltInAtomicType.UNSIGNED_BYTE";
            }
            case 553: {
                return "BuiltInAtomicType.NORMALIZED_STRING";
            }
            case 554: {
                return "BuiltInAtomicType.TOKEN";
            }
            case 555: {
                return "BuiltInAtomicType.LANGUAGE";
            }
            case 556: {
                return "BuiltInAtomicType.NMTOKEN";
            }
            case 557: {
                return "BuiltInListType.NMTOKENS";
            }
            case 558: {
                return "BuiltInAtomicType.NAME";
            }
            case 559: {
                return "BuiltInAtomicType.NCNAME";
            }
            case 560: {
                return "BuiltInAtomicType.ID";
            }
            case 561: {
                return "BuiltInAtomicType.IDREF";
            }
            case 562: {
                return "BuiltInListType.IDREFS";
            }
            case 563: {
                return "BuiltInAtomicType.ENTITY";
            }
            case 564: {
                return "BuiltInListType.ENTITIES";
            }
        }
        return "((ItemType)BuiltInSchemaFactory.getSchemaType(" + fp + "))";
    }

    public String compileNodeTest(NodeTest test) {
        int n = this.getUniqueNumber();
        String var = "t" + n;
        if (test instanceof AnyNodeTest) {
            return "AnyNodeTest.getInstance()";
        }
        if (test instanceof AnyChildNodeTest) {
            return "AnyChildNodeTest.getInstance()";
        }
        if (test instanceof CombinedNodeTest) {
            NodeTest[] parts = ((CombinedNodeTest)test).getComponentNodeTests();
            String nt0Var = this.compileNodeTest(parts[0]);
            String nt1Var = this.compileNodeTest(parts[1]);
            return this.emitInstanceVariable(CombinedNodeTest.class, var, "new CombinedNodeTest(" + nt0Var + ", " + ((CombinedNodeTest)test).getOperator() + ", " + nt1Var + ")", 1, false, false, null, null);
        }
        if (test instanceof ContentTypeTest) {
            ContentTypeTest ctt = (ContentTypeTest)test;
            SchemaType stype = ctt.getSchemaType();
            if (stype instanceof BuiltInAtomicType) {
                String stypeVar = this.compileItemType((ItemType)((BuiltInAtomicType)stype));
                int kind = ctt.getNodeKind();
                return this.emitInstanceVariable(ContentTypeTest.class, var, "new ContentTypeTest(" + kind + ", (AtomicType)" + stypeVar + ", " + "config)", 1, false, false, null, null);
            }
            if (stype instanceof AnyType) {
                return "AnyNodeTest.getInstance()";
            }
            if (stype instanceof AnySimpleType) {
                int kind = ctt.getNodeKind();
                return this.emitInstanceVariable(ContentTypeTest.class, var, "new ContentTypeTest(" + kind + ", " + "AnySimpleType.getInstance()" + ", " + "config)", 1, false, false, null, null);
            }
            if (stype instanceof Untyped) {
                int kind = ctt.getNodeKind();
                return this.emitInstanceVariable(ContentTypeTest.class, var, "new ContentTypeTest(" + kind + ", " + "Untyped.getInstance()" + ", " + "config)", 1, false, false, null, null);
            }
            if (stype instanceof UserAtomicType) {
                String stypeVar = this.compileItemType((ItemType)((UserAtomicType)stype));
                int kind = ctt.getNodeKind();
                return this.emitInstanceVariable(ContentTypeTest.class, var, "new ContentTypeTest(" + kind + ", (AtomicType)" + stypeVar + ", " + "config)", 1, false, false, null, null);
            }
            int kind = ctt.getNodeKind();
            String varName = this.compileSchemaType(stype);
            return this.emitInstanceVariable(ContentTypeTest.class, var, "new ContentTypeTest(" + kind + ", " + varName + ", " + "config)", 1, false, false, null, null);
        }
        if (test instanceof DocumentNodeTest) {
            String s = this.compileNodeTest(((DocumentNodeTest)test).getElementTest());
            return this.emitInstanceVariable(DocumentNodeTest.class, var, "new DocumentNodeTest(" + s + ")", 1, false, false, null, null);
        }
        if (test instanceof LocalNameTest) {
            this.emitInstanceVariable(LocalNameTest.class, var, "new LocalNameTest(namePool, " + test.getPrimitiveType() + ", " + CompilerService.javaEscape(((LocalNameTest)test).getLocalName()) + ")", 1, false, false, null, null);
            return var;
        }
        if (test instanceof NameTest) {
            int fp = test.getFingerprint();
            String jname = this.declareNameCode(fp);
            this.emitInstanceVariable(NameTest.class, var + '_' + jname, "new NameTest(Type." + this.javaNodeKindName(test.getPrimitiveType()) + ", " + jname + ", namePool)", 1, false, false, null, null);
            return var + '_' + jname;
        }
        if (test instanceof NamespaceTest) {
            this.emitInstanceVariable(NamespaceTest.class, var, "new NamespaceTest(namePool, " + test.getPrimitiveType() + ", " + CompilerService.javaEscape(((NamespaceTest)test).getNamespaceURI()) + ")", 1, false, false, null, null);
            return var;
        }
        if (test instanceof NodeKindTest) {
            return "NodeKindTest." + this.javaNodeKindName(test.getPrimitiveType());
        }
        if (test instanceof EmptySequenceTest) {
            return "EmptySequenceTest.getInstance()";
        }
        if (test instanceof SchemaElementTest) {
            int head = ((SchemaElementTest)test).getHeadFingerprint();
            String headName = this.declareNameCode(head);
            String initializer = "new com.saxonica.validate.SchemaElementTest((com.saxonica.schema.ElementDecl)config.getElementDeclaration(" + headName + "))";
            return this.emitInstanceVariable(SchemaElementTest.class, var, initializer, 1, false, false, null, null);
        }
        throw new UnsupportedOperationException("Node test " + test.getClass().getName() + " is not yet implemented");
    }

    public String compileRegularExpression(String translated, int flagBits) {
        String regexVar = "regex" + this.getUniqueNumber();
        this.emitInstanceVariable(RegularExpression.class, regexVar, "new JRegularExpression(" + CompilerService.javaEscape(translated) + ", " + flagBits + ")", 3, true, true, null, null);
        return regexVar;
    }

    private String javaNodeKindName(int nodeKind) {
        switch (nodeKind) {
            case 0: {
                return "NODE";
            }
            case 9: {
                return "DOCUMENT";
            }
            case 1: {
                return "ELEMENT";
            }
            case 2: {
                return "ATTRIBUTE";
            }
            case 3: {
                return "TEXT";
            }
            case 8: {
                return "COMMENT";
            }
            case 7: {
                return "PROCESSING_INSTRUCTION";
            }
        }
        return "NAMESPACE";
    }

    public String compileStringCollator(CollatingFunction exp, int collationArg) {
        int n = this.getUniqueNumber();
        String collVar = "coll" + n;
        StringCollator collator = exp.getStringCollator();
        if (collator instanceof CodepointCollator) {
            this.declare(StringCollator.class, collVar, "CodepointCollator.getInstance()", true);
        } else if (collator != null) {
            String collationURI = exp.getAbsoluteCollationURI();
            collVar = this.collationVariable(collationURI);
        } else {
            String s2Var = "str2_" + n;
            String item2Var = this.compileToItem(exp.getArguments()[collationArg]);
            this.declare(String.class, s2Var, item2Var + ".getStringValue()", true);
            String baseURI = exp.getExpressionBaseURI().toString();
            this.declare(StringCollator.class, collVar, "null", false);
            this.emit("try {");
            String collNameVar = "collName" + n;
            this.declare(String.class, collNameVar, "new URI(\"" + baseURI + "\").resolve(new URI(" + s2Var + ")).toString()", true);
            this.assign(collVar, this.getContextVariableName() + ".getCollation(" + collNameVar + ")");
            this.emit("} catch (java.net.URISyntaxException e) {");
            this.emitDynamicError("Collation name is not a valid URI", "FOCH0002");
            this.emit("}");
        }
        return collVar;
    }

    public String compileAtomicComparer(AtomicComparer comp) {
        int n = this.getUniqueNumber();
        if (comp instanceof CollatingAtomicComparer) {
            return this.collationVariable(((CollatingAtomicComparer)comp).getCollationURI());
        }
        if (comp instanceof DescendingComparer) {
            String base = this.compileAtomicComparer(((DescendingComparer)comp).getBaseComparer());
            String descVar = "desc" + n;
            this.declare(DescendingComparer.class, descVar, "new DescendingComparer(" + base + ")", true);
            return descVar;
        }
        if (comp instanceof GenericAtomicComparer) {
            StringCollator collator = ((GenericAtomicComparer)comp).getStringCollator();
            if (collator instanceof CodepointCollator) {
                return "defaultComparer";
            }
            throw new UnsupportedOperationException("Compilation of named collations not yet implemented");
        }
        if (comp instanceof AtomicSortComparer) {
            StringCollator collator = ((AtomicSortComparer)comp).getStringCollator();
            int type = ((AtomicSortComparer)comp).getItemType();
            if (collator instanceof CodepointCollator) {
                String acVar = "ac" + n;
                this.declare(AtomicComparer.class, acVar, "AtomicSortComparer.makeSortComparer(CodepointCollator.getInstance(), " + type + ", " + this.getContextVariableName() + ")", true);
                return acVar;
            }
            throw new UnsupportedOperationException("Compilation of named collations not yet implemented");
        }
        if (comp instanceof TextComparer) {
            String base = this.compileAtomicComparer(((TextComparer)comp).getBaseComparer());
            return "new TextComparer(" + base + ")";
        }
        if (comp instanceof EmptyGreatestComparer) {
            String base = this.compileAtomicComparer(((EmptyGreatestComparer)comp).getBaseComparer());
            return "new EmptyGreatestComparer(" + base + ")";
        }
        if (comp instanceof NumericComparer) {
            return "NumericComparer().getInstance()";
        }
        if (comp instanceof CalendarValueComparer) {
            return "new CalendarValueComparer(" + this.getContextVariableName() + ")";
        }
        if (comp instanceof CodepointCollatingComparer) {
            return "CodepointCollatingComparer.getInstance()";
        }
        if (comp instanceof DecimalSortComparer) {
            return "DecimalSortComparer.getDecimalSortComparerInstance()";
        }
        if (comp instanceof ComparableAtomicValueComparer) {
            return "ComparableAtomicValueComparer.getInstance()";
        }
        if (comp instanceof DoubleSortComparer) {
            return "DoubleSortComparer.getInstance()";
        }
        if (comp instanceof EqualityComparer) {
            return "EqualityComparer.getInstance()";
        }
        throw new UnsupportedOperationException("Compilation of collator of type " + comp.getClass().getName() + " not yet implemented");
    }

    public void makeKeyDefinitionFunction(StructuredQName keyName) {
        this.keyDefinitions.add(keyName);
    }

    public void compileKeyDefinitionSetters() {
        if (this.keyDefinitions.isEmpty()) {
            return;
        }
        this.emit("");
        this.emitComment("Key definitions");
        this.emit("");
        for (StructuredQName qName : this.keyDefinitions) {
            KeyDefinitionSet keySet = this.executable.getKeyManager().getKeyDefinitionSet(qName);
            List keyDefs = keySet.getKeyDefinitions();
            KeyDefinition keyDef = (KeyDefinition)keyDefs.get(0);
            String javaName = this.makeValidJavaName(qName.getLocalName());
            String keyDefVar = "keyDef_" + javaName;
            String keyClassVar = "keyClass_" + javaName;
            this.emit("KeyDefinition_" + javaName + " " + keyClassVar + " = new KeyDefinition_" + javaName + "();");
            this.emit("KeyDefinition " + keyDefVar + " = new KeyDefinition(" + keyClassVar + ", " + keyClassVar + ", null, null);");
            if (keyDef.isStrictComparison()) {
                this.emit(keyDefVar + ".setStrictComparison(true);");
            }
            if (keyDef.isConvertUntypedToOther()) {
                this.emit(keyDefVar + ".setConvertUntypedToOther(true);");
            }
            this.emit("getExecutable().getKeyManager().addKeyDefinition(" + this.compileStructuredQName(qName) + ", " + keyDefVar + ", config);");
        }
    }

    public String compileStructuredQName(StructuredQName qName) {
        return "new StructuredQName(" + CompilerService.javaEscape(qName.getPrefix()) + ", " + CompilerService.javaEscape(qName.getNamespaceURI()) + ", " + CompilerService.javaEscape(qName.getLocalName()) + ")";
    }

    public void compileKeyDefinitionClasses() {
        if (this.keyDefinitions.isEmpty()) {
            return;
        }
        this.emit("");
        this.emitComment("Key definitions");
        this.emit("");
        for (StructuredQName qName : this.keyDefinitions) {
            KeyDefinitionSet keySet = this.executable.getKeyManager().getKeyDefinitionSet(qName);
            if (keySet == null) {
                throw new IllegalArgumentException("No key definition exists with requested name");
            }
            List keyDefs = keySet.getKeyDefinitions();
            if (keyDefs.size() > 1) {
                throw new UnsupportedOperationException("Cannot handle several key definitions with same name");
            }
            String javaName = this.makeValidJavaName(qName.getLocalName());
            this.emit("private class KeyDefinition_" + javaName + " implements PatternFinder, SequenceIterable {");
            this.emitComment("match pattern:");
            this.emit("public SequenceIterator selectNodes(final DocumentInfo nodeRoot, final XPathContext context) throws XPathException {");
            this.pushContextVariable("context");
            this.pushContextItemVariable("nodeRoot");
            this.pushContextPositionVariable("IntegerValue.PLUS_ONE");
            this.pushContextSizeVariable("IntegerValue.PLUS_ONE");
            KeyDefinition keyDef = (KeyDefinition)keyDefs.get(0);
            PatternFinder match = keyDef.getMatch();
            if (!(match instanceof PathFinder)) {
                throw new UnsupportedOperationException("Unsupported pattern type in key definition");
            }
            String var = this.compileToIterator(((PathFinder)match).getSelectionExpression());
            this.emit("return " + var + ";");
            this.popContextVariable();
            this.popContextItemVariable();
            this.popContextSizeVariable();
            this.popContextPositionVariable();
            this.emit("}");
            this.emit("");
            this.emitComment("use expression:");
            this.emit("public SequenceIterator iterate(final XPathContext context) throws XPathException {");
            this.pushContextVariable("context");
            this.declare(Item.class, "contextItem", "context.getContextItem()", true);
            this.pushContextItemVariable("contextItem");
            String returnVar = this.compileToIterator((Expression)keyDef.getUse());
            this.emit("return " + returnVar + ";");
            this.popContextVariable();
            this.popContextItemVariable();
            this.emit("}");
            this.emit("}");
            this.emit("");
        }
    }

    public String compileNamespaceContext(NamespaceResolver resolver) {
        Iterator iter = resolver.iteratePrefixes();
        ArrayList<String> vars = new ArrayList<String>(10);
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            String uri = resolver.getURIForPrefix(prefix, true);
            int nsCode = this.getNamePool().getNamespaceCode(prefix, uri);
            if (nsCode == -1) {
                nsCode = this.getNamePool().allocateNamespaceCode(prefix, uri);
            }
            String nsVar = this.declareNamespaceCode(nsCode);
            vars.add(nsVar);
        }
        this.namespaceContexts.add(vars);
        return "namespaceContext" + this.namespaceContexts.size();
    }

    public static String javaEscape(CharSequence in) {
        if (in == null) {
            return "null";
        }
        FastStringBuffer sb = new FastStringBuffer(in.length());
        sb.append("\"");
        block7: for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c > '\u007f') {
                sb.append("\\u");
                String s = Integer.toHexString(c);
                while (s.length() < 4) {
                    s = "0" + s;
                }
                sb.append(s);
                continue;
            }
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    continue block7;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block7;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block7;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block7;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }
}

