/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.JavaAssignment;
import com.saxonica.codegen.JavaDeclaration;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.ToBooleanCompiler;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.CodepointEqual;
import net.sf.saxon.om.Item;

public class CodepointEqualCompiler
extends ToBooleanCompiler {
    public String compileToItem(CompilerService compiler, Expression expr) {
        CodepointEqual exp = (CodepointEqual)expr;
        Expression[] operands = exp.getArguments();
        String op0var = compiler.compileToItem(operands[0]);
        String op1var = compiler.compileToItem(operands[1]);
        String result = "b" + compiler.getUniqueNumber();
        compiler.declare(Item.class, result, null, false);
        compiler.emit("if (" + op0var + " == null || " + op1var + " == null) {");
        compiler.assign(result, "null");
        compiler.emit("} else {");
        compiler.assign(result, "BooleanValue.get(" + op0var + ".getStringValue().equals(" + op1var + ".getStringValue()))");
        compiler.emit("}");
        return result;
    }

    public String compileToEffectiveBooleanValue(CompilerService compiler, Expression expr, ReturnAction result) {
        CodepointEqual exp = (CodepointEqual)expr;
        Expression[] operands = exp.getArguments();
        String op0var = compiler.compileToItem(operands[0]);
        String op1var = compiler.compileToItem(operands[1]);
        ReturnAction action2 = result;
        if (result instanceof JavaDeclaration) {
            compiler.declare(Boolean.TYPE, result.getVariableName(), null, false);
            action2 = new JavaAssignment(Boolean.TYPE, result.getVariableName());
        }
        compiler.emit("if (" + op0var + " == null || " + op1var + " == null) {");
        compiler.emit(action2.output(compiler, "false"));
        compiler.emit("} else {");
        compiler.emit(action2.output(compiler, op0var + ".getStringValue().equals(" + op1var + ".getStringValue())"));
        compiler.emit("}");
        return result.getVariableName();
    }
}

