/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.ReturnAction;
import com.saxonica.codegen.ValueCompiler;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Value;

public class BooleanValueCompiler
extends ValueCompiler {
    public String compileToEffectiveBooleanValue(CompilerService compiler, Value expr, ReturnAction result) {
        compiler.emit(result.output(compiler, ((BooleanValue)expr).getBooleanValue() ? "true" : "false"));
        return result.getVariableName();
    }

    public String toJavaExpression(AtomicValue value, CompilerService compiler) {
        BooleanValue b = (BooleanValue)value;
        if (b.getTypeLabel().equals(BuiltInAtomicType.BOOLEAN)) {
            return b.getBooleanValue() ? "BooleanValue.TRUE" : "BooleanValue.FALSE";
        }
        String typeVar = compiler.compileItemType((ItemType)b.getTypeLabel());
        return "new BooleanValue(" + (b.getBooleanValue() ? "true" : "false") + ", " + typeVar + ")";
    }
}

