/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.codegen;

import com.saxonica.codegen.CompilerService;
import com.saxonica.codegen.LoopAction;
import com.saxonica.codegen.SequenceExpressionCompiler;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;

public class AtomicSequenceConverterCompiler
extends SequenceExpressionCompiler {
    public String compileToIterator(CompilerService compiler, Expression expr) {
        AtomicSequenceConverter exp = (AtomicSequenceConverter)expr;
        String sequenceVar = compiler.compileToIterator(exp.getBaseExpression());
        BuiltInAtomicType requiredType = exp.getRequiredPrimitiveType();
        int n = compiler.getUniqueNumber();
        String mf = "mf" + n;
        String resultVar = "s" + n;
        compiler.emit("ItemMappingFunction " + mf + " = new ItemMappingFunction() { // convert atomic sequence");
        compiler.emit("public Item mapItem(Item item) throws XPathException {");
        compiler.emit("return ((AtomicValue)item).convert(" + compiler.compileItemType((ItemType)requiredType) + ", " + compiler.getContextVariableName() + ");");
        compiler.emit("} // end of method mapItem");
        compiler.emit("}; // end of inner class");
        compiler.emit("SequenceIterator " + resultVar + " = new ItemMappingIterator(" + sequenceVar + ", " + mf + ");");
        return resultVar;
    }

    public void compileAsLoop(CompilerService compiler, Expression expr, LoopAction action) {
        AtomicSequenceConverter exp = (AtomicSequenceConverter)expr;
        int n = compiler.getUniqueNumber();
        BuiltInAtomicType requiredType = exp.getRequiredPrimitiveType();
        final String convertedVar = "converted" + n;
        LoopAction outerAction = new LoopAction((AtomicType)requiredType, action){
            final /* synthetic */ AtomicType val$requiredType;
            final /* synthetic */ LoopAction val$action;
            {
                this.val$requiredType = atomicType;
                this.val$action = loopAction;
            }

            public void compileAction(CompilerService compiler, String itemVar) {
                compiler.declare(AtomicValue.class, convertedVar, "((AtomicValue)" + itemVar + ").convert(" + compiler.compileItemType((ItemType)this.val$requiredType) + ", " + compiler.getContextVariableName() + ")", true);
                this.val$action.compileAction(compiler, convertedVar);
            }
        };
        compiler.compileAsLoop(exp.getBaseExpression(), outerAction);
    }

    public static void compileAsCharSequenceLoop(CompilerService compiler, AtomicSequenceConverter exp, final LoopAction action) {
        int n = compiler.getUniqueNumber();
        final String convertedVar = "converted" + n;
        LoopAction outerAction = new LoopAction(){

            public void compileAction(CompilerService compiler, String itemVar) {
                compiler.declare(CharSequence.class, convertedVar, "((AtomicValue)" + itemVar + ").getStringValueCS()", true);
                action.compileAction(compiler, convertedVar);
            }
        };
        compiler.compileAsLoop(exp.getBaseExpression(), outerAction);
    }
}

