/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica;

import com.saxonica.codegen.QueryCompiler;
import com.saxonica.config.EnterpriseConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.sf.saxon.Configuration;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;

public class CompileQuery {
    Configuration config = null;
    String packageName = null;
    String className = null;
    String queryFile = null;
    String javaDir = "";
    String superClassName = null;
    boolean servlet = false;
    boolean info = false;
    boolean schemaAware = false;
    boolean explain = false;
    boolean isUntyped = false;

    public static void main(String[] args) throws Exception {
        new CompileQuery().run(args);
    }

    public void run(String[] args) throws Exception {
        this.config = new EnterpriseConfiguration();
        int firstFileName = -1;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-package")) {
                if (i + 1 == args.length) {
                    this.quit("No package name follows -package");
                }
                this.packageName = args[++i];
                continue;
            }
            if (args[i].equals("-class")) {
                if (i + 1 == args.length) {
                    this.quit("No class name follows -class");
                }
                this.className = args[++i];
                continue;
            }
            if (args[i].equals("-jdir")) {
                if (i + 1 == args.length) {
                    this.quit("No directory name follows -jdir");
                }
                this.javaDir = args[++i];
                continue;
            }
            if (args[i].equals("-e")) {
                this.explain = true;
                continue;
            }
            if (args[i].equals("-servlet")) {
                this.servlet = true;
                continue;
            }
            if (args[i].equals("-superclass")) {
                if (i + 1 == args.length) {
                    this.quit("No class name follows -superclass");
                }
                this.superClassName = args[++i];
                continue;
            }
            if (args[i].equals("-t")) {
                System.err.println(this.config.getProductTitle());
                System.err.println(Configuration.getPlatform().getPlatformVersion());
                this.info = true;
                continue;
            }
            if (args[i].equals("-sa")) {
                this.schemaAware = true;
                continue;
            }
            if (args[i].equals("-untyped")) {
                this.isUntyped = true;
                continue;
            }
            if (args[i].equals("-?")) {
                this.help();
                break;
            }
            if (args[i].startsWith("-")) {
                this.quit("Unrecognized option " + args[i]);
                continue;
            }
            firstFileName = i;
            break;
        }
        if (firstFileName == -1) {
            this.quit("No input queries supplied");
        }
        if (this.className != null && firstFileName != args.length - 2) {
            this.quit("-class specified with more than one query");
        }
        QueryCompiler qc = new QueryCompiler(this.config);
        qc.setConvertUntypedAtomicParameters(this.isUntyped);
        qc.setOutputDirectory(new File(this.javaDir));
        qc.setExplain(this.explain);
        qc.setServletMode(this.servlet);
        qc.setSuperClassName(this.superClassName);
        for (int i = firstFileName; i < args.length; ++i) {
            String name;
            File file = new File(args[i]);
            qc.setBaseURI(file.toURI().toString());
            String string = name = i == firstFileName && this.className != null ? this.className : this.makeClassName(file);
            if (this.packageName != null) {
                name = this.packageName + "." + name;
            }
            qc.setClassName(name);
            qc.setOutputDirectory(new File(this.javaDir));
            try {
                if (this.info) {
                    System.err.println("Compiling " + file.getAbsolutePath());
                }
                File jf = qc.compileQueryToJava(new FileInputStream(file), null);
                if (!this.info) continue;
                System.err.println("Generated " + jf.getAbsolutePath());
                continue;
            }
            catch (IOException err) {
                err.printStackTrace();
                continue;
            }
            catch (XPathException err) {
                if (!err.hasBeenReported()) {
                    System.err.println(err.getMessage());
                }
                System.err.println("Query compilation failed");
                continue;
            }
            catch (UnsupportedOperationException err) {
                System.err.println("Cannot compile this query: " + err.getMessage());
            }
        }
    }

    private void quit(String message) {
        System.err.println(message);
        System.exit(2);
    }

    private void help() {
        System.err.println(this.config.getProductTitle());
        System.err.println("Usage: com.saxonica.CompileQuery [options] query-file...");
        System.err.println("Options: ");
        System.err.println("  -package packagename   Name of target package");
        System.err.println("  -class classname       Name of target class within package");
        System.err.println("  -jdir directory        Directory containing target package");
        System.err.println("  -e                     Explain optimized query expression");
        System.err.println("  -sa                    Query is schema-aware");
        System.err.println("  -servlet               Compile as servlet");
        System.err.println("  -superclass classname  Qualified name of user-supplied superclass");
        System.err.println("  -t                     Provide progress messages");
        System.err.println("  -untyped               Convert parameters to their required type");
    }

    private String makeClassName(File file) {
        String mainName = file.getName();
        int dot = mainName.indexOf(46);
        if (dot > 0) {
            mainName = mainName.substring(0, dot);
        }
        FastStringBuffer sb = new FastStringBuffer(mainName.length());
        boolean upper = true;
        for (int p = 0; p < mainName.length(); ++p) {
            char c = mainName.charAt(p);
            if (Character.isJavaIdentifierPart(c)) {
                if (p == 0 && !Character.isJavaIdentifierStart(c)) {
                    sb.append("_");
                }
                if (Character.isUpperCase(c)) {
                    sb.append(upper ? c : Character.toLowerCase(c));
                    upper = false;
                    continue;
                }
                if (Character.isLowerCase(c)) {
                    sb.append(upper ? Character.toUpperCase(c) : c);
                    upper = false;
                    continue;
                }
                sb.append(c);
                continue;
            }
            upper = true;
        }
        return sb.toString();
    }
}

