/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.search.retrieval.dao.util;

import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.ContentObjectDescriptor;
import com.sas.svcs.content.lookup.client.LookupService;
import com.sas.svcs.content.relationship.client.Relationship;
import com.sas.svcs.content.relationship.client.RelationshipDirection;
import com.sas.svcs.content.relationship.client.RelationshipException;
import com.sas.svcs.content.relationship.client.RelationshipFilter;
import com.sas.svcs.content.relationship.client.RelationshipModel;
import com.sas.svcs.content.relationship.client.RelationshipService;
import com.sas.svcs.content.relationship.client.Resource;
import com.sas.svcs.content.relationship.client.ResourceFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexDataRelationshipUtil {
    private static Logger perfLogger = LogManager.getLogger((String)"perf.com.sas.svcs.content.search.spi.IndexDataRelationshipUtil");
    Set<Long> skipRelatedTypes = new HashSet<Long>(3);
    LookupService lookupService;
    RelationshipService relationshipService;

    public IndexDataRelationshipUtil() {
        this.skipRelatedTypes.add(225L);
        this.skipRelatedTypes.add(226L);
        this.skipRelatedTypes.add(227L);
    }

    public void setRelationshipService(RelationshipService relationshipService) {
        this.relationshipService = relationshipService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public List<Map<String, String>> getRelationshipCache(Date date, long objectType, List<ObjectIdentity> otherIdents) {
        return null;
    }

    public Map<String, Map<String, String>> getRelationshipData(List<ObjectIdentity> idents) {
        long start = System.currentTimeMillis();
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (ObjectIdentity nextIdentity : idents) {
            Resource resource = new Resource("", nextIdentity.getObjectType(), nextIdentity.getId());
            resourceList.add(resource);
        }
        RelationshipFilter relationshipFilter = new RelationshipFilter();
        relationshipFilter.setDirection(RelationshipDirection.BOTH);
        try {
            long start2 = System.currentTimeMillis();
            List modelList = this.relationshipService.getRelationships(resourceList, relationshipFilter);
            long end2 = System.currentTimeMillis();
            if (perfLogger.isDebugEnabled()) {
                perfLogger.debug("Getting relationships only took " + (end2 - start2) + " milliseconds.");
            }
            long mmstart = System.currentTimeMillis();
            Map contentMap = null;
            HashSet<ObjectIdentity> lookupSet = new HashSet<ObjectIdentity>();
            for (RelationshipModel model : modelList) {
                for (Relationship relationship : model.getRelationships()) {
                    long otherType = relationship.getResource().getObjectType();
                    if (this.skipRelatedTypes.contains(otherType)) continue;
                    String otherId = relationship.getResource().getId();
                    ObjectIdentity identity = new ObjectIdentity(otherType, otherId);
                    lookupSet.add(identity);
                }
            }
            long mmend = System.currentTimeMillis();
            if (perfLogger.isDebugEnabled()) {
                perfLogger.debug("Building lookup list took " + (mmend - mmstart) + " milliseconds.");
            }
            long lstart = System.currentTimeMillis();
            ArrayList lookupList = new ArrayList(lookupSet);
            contentMap = this.lookupService.getContentObjectsById(lookupList);
            long llend = System.currentTimeMillis();
            if (perfLogger.isDebugEnabled()) {
                perfLogger.debug("Looking up " + lookupSet.size() + " associated objects took " + (llend - lstart) + " milliseconds.");
            }
            long nnstart = System.currentTimeMillis();
            HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
            for (RelationshipModel model : modelList) {
                Map<String, String> indexData = this.getIndexDataForModel(model, contentMap);
                result.put(indexData.get("sasid"), indexData);
            }
            long end = System.currentTimeMillis();
            if (perfLogger.isDebugEnabled()) {
                perfLogger.debug("Building result took " + (end - nnstart) + " milliseconds.");
            }
            if (perfLogger.isDebugEnabled()) {
                perfLogger.debug("Getting relationship data for " + idents.size() + " objects took " + (end - start) + " milliseconds");
            }
            return result;
        }
        catch (RelationshipException ex) {
            ex.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    public Map<String, Map<String, String>> getRelationshipUpdates(Date date, String objectType) {
        long start = System.currentTimeMillis();
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        List<RelationshipModel> modelData = this.getRelationshipData(date, objectType);
        Map contentMap = null;
        HashSet<ObjectIdentity> lookupSet = new HashSet<ObjectIdentity>();
        for (RelationshipModel model : modelData) {
            for (Relationship relationship : model.getRelationships()) {
                long otherType = relationship.getResource().getObjectType();
                if (this.skipRelatedTypes.contains(otherType)) continue;
                String otherId = relationship.getResource().getId();
                ObjectIdentity identity = new ObjectIdentity(otherType, otherId);
                lookupSet.add(identity);
            }
        }
        long lstart = System.currentTimeMillis();
        ArrayList lookupList = new ArrayList(lookupSet);
        contentMap = this.lookupService.getContentObjectsById(lookupList);
        long llend = System.currentTimeMillis();
        if (perfLogger.isDebugEnabled()) {
            perfLogger.debug("Looking up " + lookupSet.size() + " associated objects took " + (llend - lstart) + " milliseconds.");
        }
        for (RelationshipModel model : modelData) {
            Map<String, String> indexData = this.getIndexDataForModel(model, contentMap);
            result.put(indexData.get("sasid"), indexData);
        }
        long end = System.currentTimeMillis();
        if (perfLogger.isDebugEnabled()) {
            perfLogger.debug("Getting updated relationships took " + (end - start) + " milliseconds.");
        }
        return result;
    }

    Map<String, String> getIndexDataForModel(RelationshipModel model, Map<ObjectIdentity, ContentObjectDescriptor> contentMap) {
        HashMap<String, String> result = new HashMap<String, String>();
        Resource resource = model.getResource();
        result.put("sasid", resource.getId());
        result.put("objecttype", "" + resource.getObjectType());
        List relationships = model.getRelationships();
        for (Relationship relationship : relationships) {
            String rtype = relationship.getRelationshipType();
            RelationshipDirection direction = relationship.getDirection();
            String attributeName = this.getAttributeName(rtype, direction);
            String attributeIdName = this.getAttributeIdName(rtype, direction);
            String currentValue = (String)result.get(attributeName);
            if (currentValue == null) {
                currentValue = "";
            }
            String otherId = relationship.getResource().getId();
            long otherType = relationship.getResource().getObjectType();
            ObjectIdentity identity = new ObjectIdentity(otherType, otherId);
            ContentObjectDescriptor cod = contentMap.get(identity);
            if (cod == null) continue;
            String otherName = cod.getContentObject().getName();
            result.put(attributeName, currentValue.length() > 0 ? currentValue + ";" + otherName : otherName);
            currentValue = (String)result.get(attributeIdName);
            if (currentValue == null) {
                currentValue = "";
            }
            result.put(attributeIdName, currentValue.length() > 0 ? currentValue + ";" + otherId : otherId);
        }
        return result;
    }

    String getAttributeName(String rtype, RelationshipDirection direction) {
        String result = "relationship.associated.name";
        if (rtype.equals("D")) {
            result = direction == RelationshipDirection.TO ? "relationship.depends.name" : "relationship.depended.name";
        } else if (rtype.equals("I")) {
            result = direction == RelationshipDirection.TO ? "relationship.includes.name" : "relationsip.included.name";
        } else if (rtype.equals("P")) {
            result = direction == RelationshipDirection.TO ? "relationship.parent.name" : "relationship.child.name";
        } else if (rtype.equals("A")) {
            result = "relationship.associated.name";
        } else if (rtype.equals("E")) {
            result = "relationship.equivalent.name";
        } else if (rtype.equals("S")) {
            result = "relationship.synonymous.name";
        }
        return result;
    }

    String getAttributeIdName(String rtype, RelationshipDirection direction) {
        String result = "relationship.associated.id";
        if (rtype.equals("D")) {
            result = direction == RelationshipDirection.TO ? "relationship.depends.id" : "relationship.depended.id";
        } else if (rtype.equals("I")) {
            result = direction == RelationshipDirection.TO ? "relationship.includes.id" : "relationship.included.id";
        } else if (rtype.equals("P")) {
            result = direction == RelationshipDirection.TO ? "relationship.parent.id" : "relationship.child.id";
        } else if (rtype.equals("A")) {
            result = "relationship.associated.id";
        } else if (rtype.equals("E")) {
            result = "relationship.equivalent.id";
        } else if (rtype.equals("S")) {
            result = "relationship.synonymous.id";
        }
        return result;
    }

    List<RelationshipModel> getRelationshipData(Date date, String objectType) {
        try {
            long start = System.currentTimeMillis();
            ResourceFilter resourceFilter = new ResourceFilter();
            ArrayList<String> types = new ArrayList<String>();
            types.add(objectType);
            resourceFilter.setTypes(types);
            resourceFilter.setSinceDate(date);
            RelationshipFilter relationshipFilter = new RelationshipFilter();
            long end = System.currentTimeMillis();
            if (perfLogger.isDebugEnabled()) {
                perfLogger.debug("Getting relationship models took " + (end - start) + " milliseconds.");
            }
            return this.relationshipService.getRelationships(resourceFilter, relationshipFilter);
        }
        catch (RelationshipException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }
}

