/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.mapping;

import com.sas.svcs.content.lifecycle.dao.mapping.ConnectionMapping;
import com.sas.svcs.content.lifecycle.dao.mapping.ConnectionType;
import com.sas.svcs.content.lifecycle.dao.mapping.PromptedSubstitutionMapping;
import com.sas.svcs.content.lifecycle.dao.mapping.SubstitutionType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;

public class TransportMappingScanner
implements BeanPostProcessor {
    private static final Class<ConnectionMapping> CLASS_CONNECTION_MAPPINGS = ConnectionMapping.class;
    private static final Class<PromptedSubstitutionMapping> CLASS_SUBSTITUTION_MAPPINGS = PromptedSubstitutionMapping.class;
    private static Map<String, List<ConnectionMapping>> connectionsByType;
    private static Map<String, PromptedSubstitutionMapping> substitutionMap;

    public TransportMappingScanner() {
        connectionsByType = new HashMap<String, List<ConnectionMapping>>();
        substitutionMap = new HashMap<String, PromptedSubstitutionMapping>();
    }

    public static Map<String, List<ConnectionMapping>> getConnectionMappingsByType() {
        return connectionsByType;
    }

    public static Map<String, PromptedSubstitutionMapping> getSubstitutionMap() {
        return substitutionMap;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class beanCls;
        SubstitutionType type;
        if (CLASS_CONNECTION_MAPPINGS.isInstance(bean)) {
            Class beanCls2 = AopProxyUtils.ultimateTargetClass((Object)bean);
            ConnectionType type2 = (ConnectionType)AnnotationUtils.findAnnotation((Class)beanCls2, ConnectionType.class);
            if (type2 != null) {
                String[] typeNames = type2.typeNames();
                if (typeNames == null || typeNames.length == 0) {
                    throw new IllegalStateException("Connection mappings annotated with 'ConnectionType' must include a typeName.");
                }
                for (int i = 0; i < typeNames.length; ++i) {
                    String name = typeNames[i];
                    List<ConnectionMapping> list = connectionsByType.get(name);
                    if (list == null) {
                        list = new ArrayList<ConnectionMapping>(5);
                        connectionsByType.put(name, list);
                    }
                    list.add((ConnectionMapping)bean);
                }
            }
        } else if (CLASS_SUBSTITUTION_MAPPINGS.isInstance(bean) && (type = (SubstitutionType)AnnotationUtils.findAnnotation((Class)(beanCls = AopProxyUtils.ultimateTargetClass((Object)bean)), SubstitutionType.class)) != null) {
            String typeName = type.type();
            if (typeName == null || typeName.length() == 0) {
                throw new IllegalStateException("Substitution mappings annotated with 'SubstitutionType' must include a type value.");
            }
            substitutionMap.put(typeName, (PromptedSubstitutionMapping)bean);
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

