/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.mapping;

import com.sas.svcs.content.lifecycle.client.ContentOperation;
import com.sas.svcs.content.lifecycle.client.Substitution;
import com.sas.svcs.content.lifecycle.client.TransportNode;
import com.sas.svcs.content.lifecycle.dao.mapping.PromptedSubstitutionMapping;
import com.sas.svcs.content.lifecycle.dao.mapping.TransportMappingScanner;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SubstitutionMappingUtil {
    static Map<String, PromptedSubstitutionMapping> substitutionMappingCache = new HashMap<String, PromptedSubstitutionMapping>();

    public SubstitutionMappingUtil() {
        try {
            substitutionMappingCache = TransportMappingScanner.getSubstitutionMap();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public PromptedSubstitutionMapping getSubstitutionMapping(String type) {
        return substitutionMappingCache == null ? null : substitutionMappingCache.get(type);
    }

    public PromptedSubstitutionMapping getSubstitutionMapping(Substitution sub) {
        return this.getSubstitutionMapping(sub.getName());
    }

    public Substitution getSubstitution(ContentOperation<? extends TransportNode> operation, String substitutionId) {
        return this.getSubstitution(operation.getOperationNodes(), substitutionId);
    }

    public Substitution getSubstitution(List<? extends TransportNode> nodes, String substitutionId) {
        if (substitutionId == null) {
            return null;
        }
        for (TransportNode transportNode : nodes) {
            List substitutions = transportNode.getSubstitutions();
            if (substitutions == null) continue;
            for (Substitution sub : substitutions) {
                if (!substitutionId.equalsIgnoreCase(sub.getId())) continue;
                return sub;
            }
        }
        return null;
    }
}

