/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.mapping;

import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.lifecycle.client.ConnectionPoint;
import com.sas.svcs.content.lifecycle.client.ContentConnectionPoint;
import com.sas.svcs.content.lifecycle.client.TargetTransportNode;
import com.sas.svcs.content.lifecycle.client.TargetTransportOperation;
import com.sas.svcs.content.lifecycle.client.TransportNode;
import com.sas.svcs.content.lifecycle.dao.mapping.ConnectionMapping;
import com.sas.svcs.content.lifecycle.dao.mapping.ConnectionMappingUtil;
import com.sas.svcs.content.lifecycle.dao.mapping.InitializingConnectionPoint;
import com.sas.svcs.content.objecttype.client.ObjectType;
import org.springframework.util.Assert;

public class ConnectionPointFactory {
    public static ConnectionPoint createConnectionPoint(ContentComponent comp) {
        return ConnectionPointFactory.createConnectionPoint(comp, (TransportNode[])null);
    }

    public static ConnectionPoint createConnectionPoint(ContentComponent comp, TransportNode ... nodes) {
        Assert.notNull((Object)comp);
        ObjectType type = null;
        String path = null;
        if (comp instanceof ContentNode) {
            ContentNode node = (ContentNode)comp;
            path = node.getPath();
            type = new ObjectType();
            type.setId(node.getObjectType());
            type.setName(node.getObjectTypeName());
        }
        return ConnectionPointFactory.createConnectionPoint(comp.getId(), comp.getName(), comp.getDescription(), type, path, nodes);
    }

    public static ConnectionPoint createConnectionPoint(String id, String name, String description) {
        return ConnectionPointFactory.createConnectionPoint(id, name, description, (TransportNode[])null);
    }

    public static ConnectionPoint createConnectionPoint(String id, String name, String description, TransportNode ... nodes) {
        return ConnectionPointFactory.createConnectionPoint(id, name, description, null, null, nodes);
    }

    public static ConnectionPoint createConnectionPoint(String id, String name, String description, ObjectType objectType, String path) {
        return ConnectionPointFactory.createConnectionPoint(id, name, description, objectType, path, (TransportNode[])null);
    }

    public static ConnectionPoint createConnectionPoint(String id, String name, String description, ObjectType objectType, String path, TransportNode ... nodes) {
        ContentConnectionPoint result = null;
        if (objectType != null) {
            result = new ContentConnectionPoint();
            result.setObjectTypeName(objectType.getName());
            result.setObjectType(objectType.getId());
            if (path != null) {
                result.setSourcePath(path);
            }
        } else {
            result = new ConnectionPoint();
        }
        result.setSourceId(id);
        result.setName(name);
        result.setDescription(description);
        ConnectionPointFactory.initializeConnectionPoint((ConnectionPoint)result, nodes);
        return result;
    }

    private static void initializeConnectionPoint(ConnectionPoint pt, TransportNode ... nodes) {
        ConnectionMapping mapping;
        if (nodes != null) {
            for (TransportNode node : nodes) {
                node.addConnectionPoint(pt);
            }
        }
        if ((mapping = ConnectionPointFactory.getConnectionMapping(pt)) != null) {
            pt.setMappingName(mapping.getMappingName());
            if (mapping instanceof InitializingConnectionPoint) {
                ((InitializingConnectionPoint)((Object)mapping)).afterCreation(pt);
            }
        } else {
            pt.setMappingName("#Unknown#");
        }
    }

    private static ConnectionMapping getConnectionMapping(ConnectionPoint cp) {
        ConnectionMappingUtil mappingUtil = new ConnectionMappingUtil();
        return mappingUtil.discoverConnectionMapping(cp);
    }

    public static String getConnectionPointTargetPath(ContentConnectionPoint cp, TargetTransportOperation<? extends TargetTransportNode> operation) {
        Assert.notNull((Object)cp);
        if (cp.isActive()) {
            return cp.getTargetPath();
        }
        TargetTransportNode node = (TargetTransportNode)operation.getOperationNode(cp.getSourceId());
        if (node != null) {
            return node.getTargetPath();
        }
        return null;
    }
}

