/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao;

import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.ContentException;
import com.sas.svcs.content.lifecycle.dao.RB;
import com.sas.svcs.content.streaming.client.StreamService;
import com.sas.svcs.content.transport.client.ContentItem;
import com.sas.svcs.streaming.client.BinaryStreamServiceInterface;
import com.sas.svcs.streaming.client.types.ReadBytes;
import com.sas.svcs.streaming.client.types.ReadBytesResponse;
import com.sas.svcs.streaming.client.types.StreamOpenModeType;
import com.sas.svcs.workspace.client.FileServiceInterface;
import com.sas.svcs.workspace.client.FilerefServiceInterface;
import com.sas.svcs.workspace.client.WorkspaceFactoryServiceInterface;
import com.sas.svcs.workspace.client.WorkspaceServiceInterface;
import com.sas.svcs.workspace.client.types.AssignFileref;
import com.sas.svcs.workspace.client.types.DeassignFileref;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class WorkspaceServerUtil {
    private Logger logger = LogManager.getLogger(WorkspaceServerUtil.class);
    private WorkspaceFactoryServiceInterface workspaceFactoryService;

    @Autowired
    public void setWorkspaceFactoryService(WorkspaceFactoryServiceInterface workspaceFactoryService) {
        this.workspaceFactoryService = workspaceFactoryService;
    }

    public ContentItem createContentItem(String key, String serverName, String fileName) {
        ContentItem content = new ContentItem();
        content.setName(key);
        content.setContentName(new File(fileName).getName());
        content.addAttribute("FileName", fileName);
        content.addAttribute("ServerName", serverName);
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readContent(String logicalServerName, List<ContentItem> contentItems, StreamService streamService) throws ContentException {
        try {
            if (logicalServerName == null) {
                throw new ContentException(RB.getStringResource("WorkspaceServerUtil.nulllogicalserver.txt"));
            }
            WorkspaceServiceInterface workspace = this.workspaceFactoryService.newWorkspaceByLogicalName(logicalServerName);
            for (ContentItem contentItem : contentItems) {
                FileServiceInterface fileService = null;
                BinaryStreamServiceInterface binaryStream = null;
                FilerefServiceInterface filerefService = null;
                try {
                    fileService = workspace.getFileService();
                    AssignFileref fileref = new AssignFileref();
                    fileref.setExternalFile(contentItem.getAttributes().getProperty("FileName"));
                    filerefService = fileService.assignFileref(fileref);
                    binaryStream = filerefService.openBinaryStream(StreamOpenModeType.READ);
                    ReadBytes readBytes = new ReadBytes();
                    readBytes.setRequestedLength(1024);
                    ReadBytesResponse response = binaryStream.readBytes(readBytes);
                    try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                        while (response.getBinaryData().length > 0) {
                            baos.write(response.getBinaryData());
                            response = binaryStream.readBytes(readBytes);
                        }
                    }
                    ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
                    streamService.setStreamContents(new ObjectIdentity(160L, contentItem.getId()), "application/octet-stream", (InputStream)bis);
                    bis.close();
                }
                catch (Exception e) {
                    throw new ContentException(e.getMessage(), (Throwable)e);
                }
                finally {
                    if (binaryStream != null) {
                        try {
                            binaryStream.destroy();
                        }
                        catch (Throwable t) {
                            this.logger.warn(RB.getStringResource("WorkspaceServerUtil.readstreamclose.txt"), t);
                        }
                    }
                    if (fileService == null) continue;
                    DeassignFileref fileref = new DeassignFileref();
                    fileref.setName(contentItem.getAttributes().getProperty("FileName"));
                    try {
                        fileService.deassignFileref(fileref);
                    }
                    catch (Throwable t) {
                        this.logger.warn(t.getMessage(), t);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ContentException(e.getMessage(), (Throwable)e);
        }
    }

    public void writeContent(String logicalServerName, List<ContentItem> contentItems, StreamService streamService) throws ContentException {
        try {
            if (logicalServerName == null) {
                throw new ContentException(RB.getStringResource("WorkspaceServerUtil.nulllogicalserver.txt"));
            }
            WorkspaceServiceInterface workspace = this.workspaceFactoryService.newWorkspaceByLogicalName(logicalServerName);
            for (ContentItem contentItem : contentItems) {
                FileServiceInterface fileService = null;
                BinaryStreamServiceInterface binaryStream = null;
                FilerefServiceInterface filerefService = null;
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    streamService.getStreamContents(new ObjectIdentity((Identifiable)contentItem), (OutputStream)bos);
                    fileService = workspace.getFileService();
                    AssignFileref fileref = new AssignFileref();
                    fileref.setExternalFile(contentItem.getAttributes().getProperty("FileName"));
                    filerefService = fileService.assignFileref(fileref);
                    binaryStream = filerefService.openBinaryStream(StreamOpenModeType.WRITE);
                    ReadBytes readBytes = new ReadBytes();
                    readBytes.setRequestedLength(1024);
                    binaryStream.writeBytes(bos.toByteArray());
                    bos.close();
                }
                catch (Exception e) {
                    throw new ContentException(e.getMessage(), (Throwable)e);
                }
                finally {
                    if (binaryStream != null) {
                        try {
                            binaryStream.destroy();
                        }
                        catch (Throwable t) {
                            this.logger.warn(t.getMessage(), t);
                        }
                    }
                    if (fileService == null) continue;
                    DeassignFileref fileref = new DeassignFileref();
                    fileref.setName(contentItem.getAttributes().getProperty("FileName"));
                    try {
                        fileService.deassignFileref(fileref);
                    }
                    catch (Throwable t) {
                        this.logger.warn(t.getMessage(), t);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ContentException(e.getMessage(), (Throwable)e);
        }
    }
}

