/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao;

import com.sas.svcs.content.lifecycle.client.OperationNode;
import com.sas.svcs.content.lifecycle.client.TransportUtil;
import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import com.sas.svcs.content.objecttype.client.ObjectTypeUIService;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractOperationDAO {
    protected ObjectTypeService objectTypeService;
    protected ObjectTypeUIService objectTypeUIService;

    @Autowired
    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.objectTypeService = objectTypeService;
    }

    @Autowired
    public void setObjectTypeUIService(ObjectTypeUIService objectTypeUIService) {
        this.objectTypeUIService = objectTypeUIService;
    }

    protected final ObjectTypeService getObjectTypeService() {
        return this.objectTypeService;
    }

    protected final String getObjectTypeName(long objectType) {
        ObjectType type = this.objectTypeService.getTypeById(objectType);
        if (type == null) {
            throw new IllegalStateException("Could not retrieve object type " + objectType);
        }
        return type.getName();
    }

    protected final String getDisplayType(String objectTypeName) {
        return TransportUtil.getDisplayType((String)objectTypeName, (ObjectTypeUIService)this.objectTypeUIService);
    }

    protected final String getDisplayType(String objectTypeName, Locale locale) {
        return TransportUtil.getDisplayType((String)objectTypeName, (Locale)locale, (ObjectTypeUIService)this.objectTypeUIService);
    }

    protected final <T extends OperationNode> Map<String, List<T>> splitNodesByType(List<T> operationNodes) {
        LinkedHashMap<String, List<T>> nodesByType = new LinkedHashMap<String, List<T>>();
        for (OperationNode node : operationNodes) {
            String typeName = node.getContentObject().getObjectTypeName();
            ArrayList<OperationNode> nodes = (ArrayList<OperationNode>)nodesByType.get(typeName);
            if (nodes == null) {
                nodes = new ArrayList<OperationNode>();
                nodesByType.put(typeName, nodes);
            }
            nodes.add(node);
        }
        return nodesByType;
    }
}

