/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.batch.rest.model;

import com.sas.svcs.batch.rest.BasicDecorator;
import com.sas.svcs.batch.rest.GenericResponsehandler;
import com.sas.svcs.batch.rest.JsonDecorator;
import com.sas.svcs.batch.rest.ResponseDecorator;
import com.sas.svcs.batch.rest.RestUtil;
import com.sas.svcs.batch.rest.XmlDecorator;
import com.sas.svcs.batch.rest.model.BasicResponse;
import com.sas.svcs.batch.rest.model.RB;
import com.sas.text.Message;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.http.client.ResponseHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnvironmentContext {
    private static final Logger logger = LogManager.getLogger(EnvironmentContext.class);
    private String user;
    private String password;
    private String host = null;
    private String port = null;
    private String protocol = "http";
    private String profile;
    private String cfgFileName = null;
    private String cfgFileFullPath = null;
    private boolean securedConnection = false;
    private int no_of_attemp_allowed = 2;
    int cnt = 0;

    public boolean isLimitExceed() {
        ++this.cnt;
        return this.cnt > this.no_of_attemp_allowed;
    }

    public void setNo_of_attemp_allowed(String no_of_attemp_allowed) {
        this.no_of_attemp_allowed = Integer.parseInt(no_of_attemp_allowed);
    }

    public void init(String contextFileName) throws Exception {
        if (RestUtil.presentAndAccessible(contextFileName)) {
            Properties properties = new Properties();
            properties.load(new FileInputStream(new File(contextFileName)));
            if (properties.getProperty("user") != null && !properties.getProperty("user").isEmpty()) {
                this.setUser(properties.getProperty("user").trim());
            }
            if (properties.getProperty("password") != null && !properties.getProperty("password").isEmpty()) {
                this.setPassword(properties.getProperty("password").trim());
            }
            if (properties.getProperty("port") != null && !properties.getProperty("port").isEmpty()) {
                this.setPort(properties.getProperty("port").trim());
            }
            if (properties.getProperty("host") != null && !properties.getProperty("host").isEmpty()) {
                this.setHost(properties.getProperty("host").trim());
            }
            if (properties.getProperty("protocol") != null && !properties.getProperty("protocol").isEmpty()) {
                this.setProtocol(properties.getProperty("protocol").trim());
            }
        } else {
            logger.error(Message.format((String)RB.getStringResource("EnvironmentContext.file.not.found.fmt"), (Object)contextFileName));
            System.out.println(Message.format((String)RB.getStringResource("EnvironmentContext.file.not.found.fmt"), (Object)contextFileName));
        }
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) throws Exception {
        this.profile = profile;
        this.init(profile);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user.trim();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password.trim();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host.trim();
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port.trim();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String Protocol) {
        this.protocol = Protocol.trim();
    }

    public boolean isConnectionSecured() {
        if (this.protocol != null && this.protocol.equalsIgnoreCase("https")) {
            this.securedConnection = true;
        }
        return this.securedConnection;
    }

    public String getBaseURI() {
        boolean secured = this.isConnectionSecured();
        logger.debug("Is Connection secured ?" + secured);
        int intPort = Integer.parseInt(this.port);
        logger.debug("value of the port is " + intPort);
        if (intPort != 80 && intPort != 443) {
            return (secured ? "https://" : "http://") + this.host + ":" + this.port;
        }
        return (secured ? "https://" : "http://") + this.host;
    }

    public ResponseHandler<BasicResponse> getResponseHandler() {
        return new GenericResponsehandler();
    }

    public ResponseDecorator getDecorator(BasicResponse response) {
        ResponseDecorator decorator = new BasicDecorator();
        String contentType = response.getHeader("Content-Type");
        if (contentType != null) {
            if (contentType.contains("json")) {
                decorator = new JsonDecorator();
            } else if (contentType.contains("xml")) {
                decorator = new XmlDecorator();
            }
        }
        return decorator;
    }

    public void setConfigFileName(String value) {
        this.cfgFileName = value.toLowerCase();
    }

    public String getConfigFileName() {
        return this.cfgFileName;
    }

    public void setCfgFileFullPath(String value) {
        this.cfgFileFullPath = value;
    }

    public String getCfgFileFullPath() {
        return this.cfgFileFullPath;
    }
}

