/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.batch.rest;

import com.sas.svcs.batch.rest.RB;
import com.sas.svcs.batch.rest.ResponseDecorator;
import com.sas.svcs.batch.rest.model.BasicResponse;
import com.sas.svcs.batch.rest.model.Service;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlDecorator
implements ResponseDecorator {
    private static final Logger logger = LogManager.getLogger(ResponseDecorator.class);

    @Override
    public void decorate(BasicResponse response, Service service) throws Exception {
        Map<String, List<String>> param = service.getOutputParams();
        if (param != null && param.size() > 0) {
            ByteArrayInputStream is = new ByteArrayInputStream(response.getRawResponse().getBytes());
            if (is != null) {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(is);
                doc.getDocumentElement().normalize();
                this.iterateMap(param, doc);
            }
        } else {
            logger.info(RB.getStringResource("XmlDecorator.output.parameter.absent.txt"));
        }
    }

    private void iterateMap(Map<String, List<String>> param, Document doc) {
        if (param.size() > 0) {
            Set<String> objectKeySet = param.keySet();
            for (String key : objectKeySet) {
                List<String> filter = param.get(key);
                this.PrintOutPut(key, filter, doc);
            }
        }
    }

    private void PrintOutPut(String key, List filter, Document doc) {
        NodeList nodes = doc.getElementsByTagName(key);
        System.out.println(key);
        for (int i = 0; i < nodes.getLength(); ++i) {
            System.out.println(key + "[" + i + "]");
            for (int l = 0; l < filter.size(); ++l) {
                if (filter.get(l) instanceof String) {
                    Element element;
                    String val;
                    String fKey = filter.get(l).toString();
                    Node node = nodes.item(i);
                    if (node.getNodeType() != 1 || (val = XmlDecorator.getValue(fKey, element = (Element)node)) == null) continue;
                    System.out.println("\t" + fKey + ":" + XmlDecorator.getValue(fKey, element));
                    continue;
                }
                Map imMap = (Map)filter.get(l);
                this.iterateMap(imMap, doc);
            }
        }
    }

    private static String getValue(String tag, Element element) {
        NodeList chknode;
        NodeList nodes = element.getElementsByTagName(tag);
        if (nodes.getLength() > 0 && (chknode = nodes.item(0).getChildNodes()).item(0) != null) {
            Node node = chknode.item(0);
            return node.getNodeValue();
        }
        return null;
    }
}

