/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.batch.rest;

import com.sas.svcs.batch.rest.EnvironmentContextHolder;
import com.sas.svcs.batch.rest.ProxyManager;
import com.sas.svcs.batch.rest.RB;
import com.sas.svcs.batch.rest.TicketMaster;
import com.sas.svcs.batch.rest.model.BasicResponse;
import com.sas.svcs.batch.rest.model.Service;
import com.sas.text.Message;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServiceExecutor {
    BasicResponse bresponse = null;
    private static final Logger logger = LogManager.getLogger(ServiceExecutor.class);

    public BasicResponse execute(Service service) throws Exception {
        BasicHttpParams httpParameters = new BasicHttpParams();
        int timeoutConnection = 0;
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParameters, (int)timeoutConnection);
        int timeoutSocket = 0;
        HttpConnectionParams.setSoTimeout((HttpParams)httpParameters, (int)timeoutSocket);
        HttpHost proxy = null;
        String proxyRequestType = System.getProperty("proxy.type");
        if (proxyRequestType != null && proxyRequestType.length() > 0 && (proxyRequestType.equalsIgnoreCase("https") || proxyRequestType.equalsIgnoreCase("http"))) {
            ProxyManager mgr = new ProxyManager(proxyRequestType);
            proxy = mgr.getProxyObject();
        }
        DefaultHttpClient client = new DefaultHttpClient((HttpParams)httpParameters);
        if (proxy != null) {
            client.getParams().setParameter("http.route.default-proxy", proxy);
            logger.info(RB.getStringResource("ServiceExecutor.proxy.mode.txt"));
        }
        HttpResponse response = null;
        HttpEntityEnclosingRequestBase poster = null;
        HttpRequestBase getter = null;
        TicketMaster ticketMaster = new TicketMaster();
        String serviceTicket = ticketMaster.getServiceTicket(service, proxy);
        if (serviceTicket != null) {
            String url;
            if (this.sendDatawithRequest(service)) {
                url = this.formURL(service.getURL(), serviceTicket);
                logger.info(Message.format((String)RB.getStringResource("ServiceExecutor.url.fmt"), (Object)service.getURL()));
                poster = (HttpEntityEnclosingRequestBase)this.getRequester(this.getClass(service.getMethod()), url);
                response = this.processPost((HttpClient)client, service, serviceTicket, poster);
            } else {
                url = this.formURL(service.getURL(), serviceTicket);
                logger.info(Message.format((String)RB.getStringResource("ServiceExecutor.url.fmt"), (Object)service.getURL()));
                getter = (HttpRequestBase)this.getRequester(this.getClass(service.getMethod()), url);
                response = this.processGetAndOthers((HttpClient)client, service, serviceTicket, getter);
            }
            if (this.isTicketSuccess(response)) {
                if (!EnvironmentContextHolder.get().isLimitExceed()) {
                    if (poster != null) {
                        poster.abort();
                    }
                    if (getter != null) {
                        getter.abort();
                    }
                    this.execute(service);
                }
            } else {
                ResponseHandler<BasicResponse> handler = EnvironmentContextHolder.get().getResponseHandler();
                this.bresponse = (BasicResponse)handler.handleResponse(response);
            }
        }
        return this.bresponse;
    }

    private boolean isTicketSuccess(HttpResponse response) {
        return response.getStatusLine().getStatusCode() == 401;
    }

    private String formURL(String url, String serviceTicket) {
        String withTicket = url;
        String sepChar = null;
        if (withTicket != null && serviceTicket != null) {
            sepChar = withTicket.contains("?") ? "&" : "?";
            withTicket = withTicket + sepChar + "ticket=" + serviceTicket;
        }
        return withTicket;
    }

    private HttpResponse processPost(HttpClient client, Service service, String serviceTicket, HttpEntityEnclosingRequestBase lposter) throws Exception {
        this.setHeaders((HttpRequest)lposter, service);
        if (service.hasFormData()) {
            lposter.setEntity((HttpEntity)new UrlEncodedFormEntity(service.getForm().getParams()));
        } else if (service.getRequestBody() != null) {
            lposter.setEntity((HttpEntity)new StringEntity(service.getRequestBody(), "UTF-8"));
        }
        return client.execute((HttpUriRequest)lposter);
    }

    private HttpResponse processGetAndOthers(HttpClient client, Service service, String serviceTicket, HttpRequestBase lgetter) throws Exception {
        this.setHeaders((HttpRequest)lgetter, service);
        return client.execute((HttpUriRequest)lgetter);
    }

    private void setHeaders(HttpRequest request, Service service) {
        if (service.hasHeaders()) {
            Set<String> keys = service.getHeaders().keySet();
            for (String key : keys) {
                request.setHeader(key, service.getHeaders().get(key));
            }
        }
    }

    private boolean sendDatawithRequest(Service service) {
        return service.getMethod().equalsIgnoreCase("POST") || service.getMethod().equalsIgnoreCase("PUT");
    }

    private <T extends HttpRequestBase> Class<T> getClass(String method) {
        String base = "org.apache.http.client.methods.Http";
        String lowerMethod = method.toLowerCase();
        String methodPost = lowerMethod.substring(0, 1).toUpperCase() + lowerMethod.substring(1);
        Class<?> t = null;
        try {
            t = Class.forName(base + methodPost);
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
        return t;
    }

    private <T extends HttpRequestBase> T getRequester(Class<? super HttpRequestBase> clazz, String uri) {
        HttpRequestBase t = null;
        try {
            t = clazz.getDeclaredConstructor(String.class).newInstance(uri);
        }
        catch (IllegalAccessException exception) {
            exception.printStackTrace();
        }
        catch (InstantiationException exception) {
            exception.printStackTrace();
        }
        catch (NoSuchMethodException exception) {
            exception.printStackTrace();
        }
        catch (InvocationTargetException exception) {
            exception.printStackTrace();
        }
        return (T)t;
    }
}

