/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.batch.rest;

import com.sas.svcs.batch.rest.EnvironmentContextHolder;
import com.sas.svcs.batch.rest.RB;
import com.sas.svcs.batch.rest.ResponseDecorator;
import com.sas.svcs.batch.rest.RestConfiguration;
import com.sas.svcs.batch.rest.RestUtil;
import com.sas.svcs.batch.rest.ServiceDefinition;
import com.sas.svcs.batch.rest.ServiceExecutor;
import com.sas.svcs.batch.rest.model.BasicResponse;
import com.sas.svcs.batch.rest.model.EnvironmentContext;
import com.sas.svcs.batch.rest.model.FormParams;
import com.sas.svcs.batch.rest.model.Service;
import com.sas.text.Message;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class BatchDriver {
    private static final Logger logger = LogManager.getLogger(BatchDriver.class);
    Properties prop = new Properties();

    private EnvironmentContext parse(String[] command) throws Exception {
        String param = null;
        String value = null;
        EnvironmentContext ctx = new EnvironmentContext();
        if (command != null && command.length > 0) {
            int prevToken = 0;
            int index = 1;
            for (index = 0; index < command.length; ++index) {
                String token = command[index];
                if (token.startsWith("-")) {
                    param = token.substring(1);
                    ++prevToken;
                } else {
                    value = token;
                    prevToken = 0;
                    if (param == null) {
                        value = null;
                    }
                }
                if (prevToken == 2) {
                    token = command[--index];
                    param = token.substring(1);
                }
                if ((param == null || value == null) && (param == null || value != null || prevToken != 2 && index != command.length - 1)) continue;
                if (param.equalsIgnoreCase("host")) {
                    ctx.setHost(value);
                } else if (param.equalsIgnoreCase("port")) {
                    ctx.setPort(value);
                } else if (param.equalsIgnoreCase("user")) {
                    ctx.setUser(value);
                } else if (param.equalsIgnoreCase("password")) {
                    ctx.setPassword(value);
                } else if (param.equalsIgnoreCase("protocol")) {
                    ctx.setProtocol(value);
                } else if (param.equalsIgnoreCase("profile")) {
                    ctx.setProfile(value);
                } else if (param.equalsIgnoreCase("maxattempt")) {
                    ctx.setNo_of_attemp_allowed(value);
                }
                if (param.equalsIgnoreCase("help")) {
                    value = "";
                }
                if (param.equalsIgnoreCase("d") || param.equalsIgnoreCase("sync") || param.equalsIgnoreCase("async")) {
                    this.prop.put("action", param);
                }
                param = param.toLowerCase();
                if (value != null || param.equalsIgnoreCase("Help")) {
                    this.prop.put(param, value);
                }
                param = null;
                value = null;
            }
        } else {
            this.prop.put("help", "");
        }
        return ctx;
    }

    public EnvironmentContext prepareEnvironment(String[] args) throws Exception {
        EnvironmentContext context = this.parse(args);
        String Configfile = System.getProperty("configFile");
        if (Configfile != null && Configfile.length() > 0) {
            File file = new File(Configfile);
            boolean isConfigurationFileExist = RestUtil.presentAndAccessible(Configfile);
            if (isConfigurationFileExist) {
                context.setConfigFileName(file.getName());
                context.setCfgFileFullPath(file.getAbsolutePath());
            } else {
                context.setCfgFileFullPath(file.getAbsolutePath());
            }
        }
        EnvironmentContextHolder.set(context);
        return context;
    }

    public BasicResponse executeURL(EnvironmentContext context, Service service) throws Exception {
        BasicResponse response = null;
        if (service != null) {
            ServiceExecutor exe = new ServiceExecutor();
            response = exe.execute(service);
        } else {
            logger.error(Message.format((String)RB.getStringResource("BatchDriver.service.fail.fmt"), (Object)context.getConfigFileName()));
            System.out.println(Message.format((String)RB.getStringResource("BatchDriver.service.fail.fmt"), (Object)context.getConfigFileName()));
        }
        return response;
    }

    public void DecorateResponse(BasicResponse response, Service service, EnvironmentContext context, ResponseDecorator decorator) throws Exception {
        if (response != null) {
            if (response.getStatusCode() == 204) {
                System.out.println(Message.format((String)RB.getStringResource("BatchDriver.request.success.fmt"), (Object)context.getConfigFileName().substring(0, context.getConfigFileName().indexOf("."))));
                logger.info(Message.format((String)RB.getStringResource("BatchDriver.request.success.fmt"), (Object)context.getConfigFileName().substring(0, context.getConfigFileName().indexOf("."))));
            } else {
                if (decorator == null) {
                    decorator = context.getDecorator(response);
                }
                decorator.decorate(response, service);
            }
        } else {
            logger.error(RB.getStringResource("BatchDriver.http.response.null.txt"));
            System.out.println(RB.getStringResource("BatchDriver.http.response.null.txt"));
        }
    }

    public static void main(String[] args) {
        BatchDriver cmd = new BatchDriver();
        BasicResponse response = null;
        try {
            EnvironmentContext context = cmd.prepareEnvironment(args);
            if (!cmd.prop.containsKey("help")) {
                if (context.getConfigFileName() != null && context.getConfigFileName().length() > 0) {
                    String missingParam = cmd.LogMissingArgument(context);
                    if (missingParam != "" && missingParam.length() > 0) {
                        logger.error(Message.format((String)RB.getStringResource("BatchDriver.missing.argument.error.fmt"), (Object)missingParam));
                        System.out.println(Message.format((String)RB.getStringResource("BatchDriver.missing.argument.error.fmt"), (Object)missingParam));
                    } else {
                        logger.info(Message.format((String)RB.getStringResource("BatchDriver.http.credential.fmt"), (Object)context.getHost(), (Object)context.getPort(), (Object)context.getUser()));
                        logger.info(Message.format((String)RB.getStringResource("BatchDriver.rest.configfile.name.fmt"), (Object)context.getConfigFileName()));
                        Service service = cmd.buildServiceObject(context);
                        if (service != null) {
                            List<String> msgArg = service.getMissingUtilityArgument();
                            if (msgArg != null && msgArg.size() > 0) {
                                String strArg = "";
                                for (int i = 0; i < msgArg.size(); ++i) {
                                    strArg = strArg + msgArg.get(i) + " ";
                                }
                                logger.error(Message.format((String)RB.getStringResource("BatchDriver.missing.utility.argument.error.fmt"), (Object)strArg, (Object)context.getConfigFileName().substring(0, context.getConfigFileName().indexOf(".yml"))));
                                System.out.println(Message.format((String)RB.getStringResource("BatchDriver.missing.utility.argument.error.fmt"), (Object)strArg, (Object)context.getConfigFileName().substring(0, context.getConfigFileName().indexOf(".yml"))));
                            } else {
                                response = cmd.executeURL(context, service);
                                cmd.DecorateResponse(response, service, context, service.getDecorator());
                            }
                        } else {
                            System.out.println(RB.getStringResource("BatchDriver.error.build.service.object.txt"));
                            logger.error(RB.getStringResource("BatchDriver.error.build.service.object.txt"));
                        }
                    }
                } else {
                    logger.error(Message.format((String)RB.getStringResource("BatchDriver.configuration.file.absent.fmt"), (Object)context.getCfgFileFullPath()));
                    System.out.println(Message.format((String)RB.getStringResource("BatchDriver.configuration.file.absent.fmt"), (Object)context.getCfgFileFullPath()));
                }
            } else {
                String path = System.getProperty("configFile");
                Map<String, String> map = cmd.getPrintObject(path);
                if (map != null) {
                    cmd.printUsage(map);
                }
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(RB.getStringResource("BatchDriver.http.response.null.txt") + " : " + e.getLocalizedMessage());
            logger.info((Object)e);
        }
        catch (Exception e) {
            System.out.println(RB.getStringResource("BatchDriver.http.response.null.txt") + " : " + e.getLocalizedMessage());
            logger.info((Object)e);
        }
    }

    public String LogMissingArgument(EnvironmentContext context) {
        String missingParam = "";
        if (context.getHost() == null || "".equals(context.getHost())) {
            missingParam = missingParam + "-" + "host" + " ";
        }
        if (context.getPort() == null || "".equals(context.getPort())) {
            missingParam = missingParam + "-" + "port" + " ";
        }
        if (context.getUser() == null || "".equals(context.getUser())) {
            missingParam = missingParam + "-" + "user" + " ";
        }
        if (context.getPassword() == null || "".equals(context.getPassword())) {
            missingParam = missingParam + "-" + "password" + " ";
        }
        if (context.getConfigFileName() == null || "".equals(context.getConfigFileName())) {
            missingParam = missingParam + "-" + "configFile" + " ";
        }
        return missingParam;
    }

    public Map<String, String> getPrintObject(String path) throws FileNotFoundException {
        Map<String, String> map = null;
        File file = new File(path);
        if (RestUtil.presentAndAccessible(path)) {
            Constructor constructor = new Constructor(RestConfiguration.class, new LoaderOptions());
            Yaml yaml = new Yaml((BaseConstructor)constructor);
            Object obj = RestUtil.getYamlObject(file.getAbsolutePath());
            RestConfiguration configurableObj = (RestConfiguration)obj;
            map = configurableObj.getUsage();
        } else {
            logger.error(Message.format((String)RB.getStringResource("BatchDriver.configuration.file.absent.fmt"), (Object)file.getName(), (Object)file.getAbsolutePath()));
            System.out.println(Message.format((String)RB.getStringResource("BatchDriver.configuration.file.absent.fmt"), (Object)file.getName(), (Object)file.getAbsolutePath()));
        }
        return map;
    }

    private void printUsage(Map<String, String> map) {
        System.out.println(RB.getStringResource("BatchDriver.usage.txt"));
        RestUtil.PrintIterativeHAshMap(map);
    }

    public Service buildServiceObject(EnvironmentContext context) throws FileNotFoundException {
        Service service = null;
        Object lstUtilityArgs = null;
        String fileName = context.getCfgFileFullPath();
        Constructor constructor = new Constructor(RestConfiguration.class, new LoaderOptions());
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        Object obj = RestUtil.getYamlObject(fileName);
        RestConfiguration configurableObj = (RestConfiguration)obj;
        if (!Boolean.valueOf(configurableObj.getIsDeprecated()).booleanValue()) {
            if (configurableObj != null) {
                ServiceDefinition serviceDef = this.getServiceDefinition(configurableObj);
                if (serviceDef != null && serviceDef.getServiceEndPoint() != null) {
                    String queryParameter;
                    String method = serviceDef.getMethod();
                    if (method == null || "".equals(method)) {
                        logger.error(Message.format((String)RB.getStringResource("BatchDriver.buildServiceObject.method.type.missing.fmt"), (Object)context.getConfigFileName()));
                    }
                    String serviceEndPoint = serviceDef.getServiceEndPoint();
                    if ((serviceEndPoint = this.CheckForVariable(serviceEndPoint)) == null || "".equals(serviceEndPoint)) {
                        logger.error(Message.format((String)RB.getStringResource("BatchDriver.buildServiceObject.request.url.missing.fmt"), (Object)context.getConfigFileName()));
                    }
                    List<String> optional = configurableObj.getOptionals();
                    boolean provided = this.isOptionalParamProvided(optional);
                    if (optional != null && optional.size() > 0 && provided && (queryParameter = this.getQueryParameter(optional)) != null && !queryParameter.isEmpty()) {
                        serviceEndPoint = serviceEndPoint + "?" + queryParameter;
                    }
                    if (method != null && method.length() > 0 && serviceEndPoint != null && serviceEndPoint.length() > 0) {
                        List<String> skipnode;
                        service = new Service(method.toString(), serviceEndPoint.toString());
                        Map<String, String> header = serviceDef.getHeader();
                        if (header != null && header.size() > 0) {
                            this.AddRequestHeader(service, header);
                        }
                        String jsonStr = null;
                        Map<String, Boolean> requestBody = serviceDef.getRequestBody();
                        if (requestBody != null && requestBody.size() > 0) {
                            for (String key : requestBody.keySet()) {
                                String inputdataArg = key.toString().trim();
                                Boolean isRequired = requestBody.get(key);
                                if (isRequired.booleanValue()) {
                                    jsonStr = this.getRequestBody();
                                    if (jsonStr != null && jsonStr.length() > 0) {
                                        service.setRequestBody(jsonStr);
                                        continue;
                                    }
                                    service.setMissingUtilityArgument(inputdataArg);
                                    continue;
                                }
                                jsonStr = this.getRequestBody();
                                if (jsonStr != null && jsonStr.length() > 0) {
                                    service.setRequestBody(jsonStr);
                                    continue;
                                }
                                logger.warn(RB.getStringResource("BatchDriver.default.comment.used.txt"));
                                jsonStr = "{\"comment\" : \"\"}";
                                service.setRequestBody(jsonStr);
                            }
                        }
                        FormParams fParam = null;
                        Map<String, String> formparam = configurableObj.getParams();
                        if (formparam != null && formparam.size() > 0) {
                            FormParams.FormBuilder fb = FormParams.FormBuilder.getBuilder();
                            for (String key : formparam.keySet()) {
                                fb.add(key.trim(), formparam.get(key).toString().trim());
                            }
                            fParam = fb.buildForm();
                        }
                        if (fParam != null) {
                            service.setForm(fParam);
                        }
                        if ((skipnode = configurableObj.getFilterNode()) != null) {
                            service.setFilterNode(skipnode);
                        }
                        if (configurableObj.getDecorator() != null && !configurableObj.getDecorator().isEmpty()) {
                            service.setDecorator(configurableObj.getDecorator());
                        }
                        if (serviceEndPoint.contains("$")) {
                            String[] words = serviceEndPoint.split("/");
                            for (int i = 0; i < words.length; ++i) {
                                String str = words[i];
                                if (!str.startsWith("$") || !str.endsWith("$")) continue;
                                service.setMissingUtilityArgument(str.substring(1, str.length() - 1));
                            }
                        }
                    }
                } else {
                    logger.error(RB.getStringResource("BatchDriver.buildServiceObject.service.definition.error.txt"));
                }
            } else {
                logger.error(Message.format((String)RB.getStringResource("BatchDriver.buildServiceObject.request.yaml.load.error.fmt"), (Object)context.getConfigFileName()));
            }
        } else {
            System.out.println(configurableObj.getMessage());
            System.exit(0);
        }
        return service;
    }

    private boolean isOptionalParamProvided(List<String> optional) {
        boolean provided = true;
        if (optional != null && optional.size() > 0) {
            for (String key : optional) {
                String replacedString = this.CheckForVariable(key);
                if (!replacedString.contains("$")) continue;
                logger.info(RB.getStringResource("BatchDriver.optional.param.not.found.txt"));
                provided = false;
                break;
            }
        }
        return provided;
    }

    private ServiceDefinition getServiceDefinition(RestConfiguration configurableObj) {
        ServiceDefinition def = new ServiceDefinition();
        String ServiceKey = null;
        String action = this.getActionProvided();
        if (configurableObj.getServiceUrlManipulator() != null) {
            ServiceKey = this.generateKey(configurableObj.getServiceUrlManipulator());
            if (ServiceKey == null || ServiceKey.length() == 0) {
                ServiceKey = "baseService";
            } else if (action != null) {
                ServiceKey = ServiceKey + "#" + action;
            }
        } else {
            ServiceKey = action != null ? action : "baseService";
        }
        List<ServiceDefinition> services = configurableObj.getRestServices();
        for (ServiceDefinition serviceDef : services) {
            if (!serviceDef.getName().equalsIgnoreCase(ServiceKey)) continue;
            def = serviceDef;
            break;
        }
        return def;
    }

    private String getActionProvided() {
        String action = null;
        if (this.prop.containsKey("action")) {
            action = this.prop.getProperty("action");
        }
        return action;
    }

    private String generateKey(List<String> urlkeys) {
        String fianlKey = "";
        if (urlkeys != null && !urlkeys.isEmpty()) {
            for (int i = 0; i < urlkeys.size(); ++i) {
                String key = null;
                if (this.prop.containsKey(urlkeys.get(i))) {
                    key = urlkeys.get(i);
                }
                if (key != null && fianlKey.length() > 0) {
                    fianlKey = fianlKey + "#" + key;
                }
                if (key == null || fianlKey.length() != 0) continue;
                fianlKey = fianlKey + key;
            }
        }
        return fianlKey;
    }

    private String getFilterOptions(String strComment) {
        String filter = (String)this.prop.get("excludeFilter".toLowerCase());
        String[] array = filter.split(",");
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append(strComment);
        sb.append(",");
        sb.append("\"excludeFilter\" :");
        sb.append("[");
        for (int i = 0; i < array.length; ++i) {
            sb.append("{");
            sb.append("\"excludedSource\": \"" + array[i].toString() + "\"");
            if (i != array.length - 1) {
                sb.append("},");
                continue;
            }
            sb.append("}");
        }
        sb.append("]");
        sb.append("}");
        return sb.toString();
    }

    private String getUserComment() {
        String strComment = null;
        if (this.prop.containsKey("comment")) {
            strComment = this.generateCommentJson((String)this.prop.get("comment"));
        }
        return strComment;
    }

    private String generateCommentJson(String strComment) {
        String gStr = "\"comment\" : \"" + strComment + "\"";
        return gStr;
    }

    private Map<String, List<String>> getOutputParams(LinkedHashMap<String, ?> map) {
        Map op = null;
        if (map.containsKey("Params")) {
            op = (Map)map.get("Params");
        }
        return op;
    }

    private String getRequestBody() throws FileNotFoundException {
        String requestBody = null;
        if (this.prop.containsKey("inputdata")) {
            String filename = (String)this.prop.get("inputdata");
            File file = RestUtil.LoadDataFile(filename);
            if (file != null) {
                requestBody = RestUtil.getContent(file);
            } else {
                logger.error(Message.format((String)RB.getStringResource("BatchDriver.incorrect.filepath.fmt"), (Object)filename));
            }
        }
        return requestBody;
    }

    private void AddRequestHeader(Service service, Map<String, String> map) {
        for (String key : map.keySet()) {
            String MIMEString = this.CheckForVariable(map.get(key).toString().trim());
            service.addHeader(key.toString().trim(), MIMEString);
        }
    }

    private String getEndPointURL(LinkedHashMap<String, ?> map) {
        String endurl = "";
        if (map.containsKey("ServiceEndPoint")) {
            endurl = this.CheckForVariable((String)map.get("ServiceEndPoint"));
        }
        return endurl.trim();
    }

    private String getMethod(LinkedHashMap<String, ?> map) {
        String method = "";
        if (map.containsKey("Method")) {
            method = (String)map.get("Method");
        }
        return method.trim();
    }

    private String getQueryParameter(List<String> optional) {
        String fianlKey = "";
        if (optional != null && !optional.isEmpty()) {
            for (int i = 0; i < optional.size(); ++i) {
                String key = optional.get(i);
                if (key != null && fianlKey.length() > 0) {
                    fianlKey = fianlKey + "&" + key;
                }
                if (key == null || fianlKey.length() != 0) continue;
                fianlKey = fianlKey + key;
            }
        }
        fianlKey = this.CheckForVariable(fianlKey);
        return fianlKey;
    }

    private String CheckForVariable(String input) {
        String out = "";
        for (String string : this.prop.keySet()) {
            if (input == null || !input.contains("$" + string + "$")) continue;
            input = out = input.replace("$" + string + "$", (CharSequence)this.prop.get(string));
        }
        return input.trim();
    }
}

