/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.tcpserver;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.net.ssl.SSLHandshakeException;
import org.apache.geode.distributed.internal.tcpserver.HostAndPort;
import org.apache.geode.distributed.internal.tcpserver.InfoRequest;
import org.apache.geode.distributed.internal.tcpserver.InfoResponse;
import org.apache.geode.distributed.internal.tcpserver.ShutdownRequest;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreator;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketFactory;
import org.apache.geode.distributed.internal.tcpserver.VersionRequest;
import org.apache.geode.distributed.internal.tcpserver.VersionResponse;
import org.apache.geode.internal.lang.utils.JavaWorkarounds;
import org.apache.geode.internal.lang.utils.function.Checked;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.ObjectDeserializer;
import org.apache.geode.internal.serialization.ObjectSerializer;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.VersionedDataInputStream;
import org.apache.geode.internal.serialization.VersionedDataOutputStream;
import org.apache.geode.internal.serialization.Versioning;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TcpClient {
    private static final Logger logger = LogService.getLogger();
    private static final int DEFAULT_REQUEST_TIMEOUT = 120000;
    private final ConcurrentMap<HostAndPort, Short> serverVersions = new ConcurrentHashMap<HostAndPort, Short>();
    private final TcpSocketCreator socketCreator;
    private final ObjectSerializer objectSerializer;
    private final ObjectDeserializer objectDeserializer;
    private final TcpSocketFactory socketFactory;

    public TcpClient(TcpSocketCreator socketCreator, ObjectSerializer objectSerializer, ObjectDeserializer objectDeserializer, TcpSocketFactory socketFactory) {
        this.socketCreator = socketCreator;
        this.objectSerializer = objectSerializer;
        this.objectDeserializer = objectDeserializer;
        this.socketFactory = socketFactory;
    }

    public void stop(HostAndPort hostAndPort) throws ConnectException {
        try {
            ShutdownRequest request = new ShutdownRequest();
            this.requestToServer(hostAndPort, request, 120000, true);
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (Exception ex) {
            logger.error("TcpClient.stop(): exception connecting to locator " + hostAndPort + ex);
        }
    }

    @Deprecated
    public String[] getInfo(HostAndPort hostAndPort) {
        try {
            InfoRequest request = new InfoRequest();
            InfoResponse response = (InfoResponse)Objects.requireNonNull(this.requestToServer(hostAndPort, request, 120000, true));
            return response.getInfo();
        }
        catch (ConnectException ignore) {
            return null;
        }
        catch (Exception ex) {
            logger.error("TcpClient.getInfo(): exception connecting to locator " + hostAndPort + ": " + ex);
            return null;
        }
    }

    @Nullable
    public Object requestToServer(@NotNull HostAndPort address, @NotNull Object request, int timeout, boolean replyExpected) throws IOException, ClassNotFoundException {
        String debugVersionMessage;
        long expirationTime = System.currentTimeMillis() + (long)timeout;
        short serverVersionShort = this.getServerVersion(address, timeout);
        KnownVersion serverVersion = Versioning.getKnownVersionOrDefault((Version)Versioning.getVersion((short)serverVersionShort), null);
        if (serverVersion == null) {
            serverVersion = KnownVersion.CURRENT;
            debugVersionMessage = "Remote TcpServer version: " + serverVersionShort + " is higher than local version: " + KnownVersion.CURRENT_ORDINAL + ". This is never expected as remoteVersion";
        } else {
            debugVersionMessage = null;
        }
        int newTimeout = (int)(expirationTime - System.currentTimeMillis());
        if (newTimeout <= 0) {
            return null;
        }
        return this.requestToServer(address, request, newTimeout, replyExpected, serverVersionShort, serverVersion, debugVersionMessage);
    }

    /*
     * Loose catch block
     */
    Object requestToServer(@NotNull HostAndPort address, @NotNull Object request, int timeout, boolean replyExpected, short serverVersionOrdinal, @NotNull KnownVersion serverVersion, @Nullable String debugVersionMessage) throws IOException, ClassNotFoundException {
        logger.debug("TcpClient sending {} to {}", request, (Object)address);
        Socket sock = this.socketCreator.forCluster().connect(address, timeout, null, this.socketFactory);
        try {
            Object var11_12;
            sock.setSoTimeout(timeout);
            try (DataOutputStream out = TcpClient.createDataOutputStream(sock, serverVersion);){
                this.sendRequest(out, serverVersionOrdinal, request);
                if (replyExpected) {
                    try (DataInputStream in = TcpClient.createDataInputStream(sock, serverVersion);){
                        if (debugVersionMessage != null && logger.isDebugEnabled()) {
                            logger.debug(debugVersionMessage);
                        }
                        Object object = this.receiveResponse(in, address);
                        return object;
                    }
                }
                var11_12 = null;
            }
            return var11_12;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                if (replyExpected && !sock.isClosed() && !this.socketCreator.forCluster().useSSL()) {
                    sock.setSoLinger(true, 0);
                }
                sock.close();
            }
            catch (Exception e) {
                logger.error("Error closing socket ", (Throwable)e);
            }
        }
    }

    @Nullable
    Object receiveResponse(@NotNull DataInputStream in, @NotNull HostAndPort address) throws IOException, ClassNotFoundException {
        try {
            Object response = this.objectDeserializer.readObject((DataInput)in);
            logger.debug("received response: {}", response);
            return response;
        }
        catch (EOFException ex) {
            logger.debug("requestToServer EOFException ", (Throwable)ex);
            throw TcpClient.createEOFException(address, ex);
        }
    }

    @NotNull
    static EOFException createEOFException(@NotNull HostAndPort address, @NotNull Exception cause) {
        EOFException exception = new EOFException("Locator at " + address + " did not respond. This is normal if the locator was shutdown. If it wasn't check its log for exceptions.");
        exception.initCause(cause);
        return exception;
    }

    @NotNull
    static DataInputStream createDataInputStream(@NotNull Socket sock, @NotNull KnownVersion version) throws IOException {
        DataInputStream in = new DataInputStream(new BufferedInputStream(sock.getInputStream()));
        if (version.isOlderThan((Version)KnownVersion.CURRENT)) {
            in = new VersionedDataInputStream((InputStream)in, version);
        }
        return in;
    }

    @NotNull
    static DataOutputStream createDataOutputStream(@NotNull Socket socket, @NotNull KnownVersion version) throws IOException {
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        if (version.isOlderThan((Version)KnownVersion.CURRENT)) {
            out = new VersionedDataOutputStream((OutputStream)out, version);
        }
        return out;
    }

    short getServerVersion(@NotNull HostAndPort address, int timeout) throws IOException {
        return (Short)JavaWorkarounds.computeIfAbsent(this.serverVersions, (Object)address, (Function)Checked.rethrowFunction(k -> {
            Socket socket = this.socketCreator.forCluster().connect(address, timeout, null, this.socketFactory);
            try {
                socket.setSoTimeout(timeout);
                Short s = this.getServerVersion(socket);
                return s;
            }
            finally {
                TcpClient.resetSocketAndLogExceptions(socket);
            }
        }));
    }

    /*
     * Exception decompiling
     */
    @NotNull
    Short getServerVersion(@NotNull Socket socket) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    Short getServerVersion(@NotNull DataInputStream in, @NotNull DataOutputStream out) throws IOException {
        this.sendRequest(out, KnownVersion.OLDEST.ordinal(), new VersionRequest());
        try {
            TcpClient.assertNotSslAlert(in);
            VersionResponse versionResponse = (VersionResponse)this.objectDeserializer.readObject((DataInput)in);
            return versionResponse.getVersionOrdinal();
        }
        catch (EOFException ignored) {
            return KnownVersion.OLDEST.ordinal();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Server version response invalid.", e);
        }
    }

    static void assertNotSslAlert(@NotNull DataInputStream in) throws IOException {
        in.mark(1);
        try {
            if (in.read() == 21) {
                throw new SSLHandshakeException("Server expecting SSL handshake.");
            }
        }
        finally {
            in.reset();
        }
    }

    void sendRequest(@NotNull DataOutputStream out, short ordinalVersion, @NotNull Object request) throws IOException {
        out.writeInt(1002);
        out.writeShort(ordinalVersion);
        this.objectSerializer.writeObject(request, (DataOutput)out);
        out.flush();
    }

    static void resetSocketAndLogExceptions(@NotNull Socket socket) {
        if (!socket.isClosed()) {
            try {
                socket.setSoLinger(true, 0);
            }
            catch (Exception e) {
                logger.error("Error aborting socket ", (Throwable)e);
            }
            try {
                socket.close();
            }
            catch (Exception e) {
                logger.error("Error closing socket ", (Throwable)e);
            }
        }
    }
}

