/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.decoder.compression;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.decoder.compression.BitBuffer;
import com.sas.visuals.image.decoder.compression.ImageCompressionException;

@SASScope(value="ALL")
public class CcittTree {
    static final int ZERO_CHILD = 0;
    static final int ONE_CHILD = 1;
    static final int RUN_LENGTH = 2;
    static final short[][] huffTree = new short[][]{{2, 17, -1}, {209, 221, -1}, {3, 14, -1}, {10, 4, -1}, {37, 5, -1}, {6, 33, -1}, {76, 7, -1}, {8, 142, -1}, {134, 9, -1}, {-1, -1, 0}, {40, 11, -1}, {55, 12, -1}, {53, 13, -1}, {-1, -1, 1}, {34, 15, -1}, {138, 16, -1}, {-1, -1, 2}, {18, 23, -1}, {19, 21, -1}, {20, 29, -1}, {-1, -1, 3}, {31, 22, -1}, {-1, -1, 4}, {24, 26, -1}, {25, 43, -1}, {-1, -1, 5}, {27, 28, -1}, {-1, -1, 6}, {-1, -1, 7}, {136, 30, -1}, {-1, -1, 8}, {32, 47, -1}, {-1, -1, 9}, {-1, -1, 10}, {35, 66, -1}, {36, 50, -1}, {-1, -1, 11}, {38, 58, -1}, {39, 72, -1}, {-1, -1, 12}, {61, 41, -1}, {64, 42, -1}, {-1, -1, 13}, {44, 135, -1}, {45, 46, -1}, {-1, -1, 14}, {-1, -1, 15}, {48, 49, -1}, {-1, -1, 16}, {-1, -1, 17}, {74, 51, -1}, {175, 52, -1}, {-1, -1, 18}, {54, 82, -1}, {-1, -1, 19}, {56, 88, -1}, {57, 85, -1}, {-1, -1, 20}, {95, 59, -1}, {102, 60, -1}, {-1, -1, 21}, {78, 62, -1}, {105, 63, -1}, {-1, -1, 22}, {65, 108, -1}, {-1, -1, 23}, {67, 120, -1}, {68, 70, -1}, {69, 111, -1}, {-1, -1, 24}, {114, 71, -1}, {-1, -1, 25}, {117, 73, -1}, {-1, -1, 26}, {75, 128, -1}, {-1, -1, 27}, {77, 131, -1}, {-1, -1, 28}, {183, 79, -1}, {80, 81, -1}, {-1, -1, 29}, {-1, -1, 30}, {83, 84, -1}, {-1, -1, 31}, {-1, -1, 32}, {86, 87, -1}, {-1, -1, 33}, {-1, -1, 34}, {89, 92, -1}, {90, 91, -1}, {-1, -1, 35}, {-1, -1, 36}, {93, 94, -1}, {-1, -1, 37}, {-1, -1, 38}, {96, 99, -1}, {97, 98, -1}, {-1, -1, 39}, {-1, -1, 40}, {100, 101, -1}, {-1, -1, 41}, {-1, -1, 42}, {103, 104, -1}, {-1, -1, 43}, {-1, -1, 44}, {106, 107, -1}, {-1, -1, 45}, {-1, -1, 46}, {109, 110, -1}, {-1, -1, 47}, {-1, -1, 48}, {112, 113, -1}, {-1, -1, 49}, {-1, -1, 50}, {115, 116, -1}, {-1, -1, 51}, {-1, -1, 52}, {118, 119, -1}, {-1, -1, 53}, {-1, -1, 54}, {121, 137, -1}, {122, 125, -1}, {123, 124, -1}, {-1, -1, 55}, {-1, -1, 56}, {126, 127, -1}, {-1, -1, 57}, {-1, -1, 58}, {129, 130, -1}, {-1, -1, 59}, {-1, -1, 60}, {132, 133, -1}, {-1, -1, 61}, {-1, -1, 62}, {-1, -1, 63}, {-1, -1, 64}, {-1, -1, 128}, {-1, -1, 192}, {145, 139, -1}, {150, 140, -1}, {168, 141, -1}, {-1, -1, 256}, {143, 144, -1}, {-1, -1, 320}, {-1, -1, 384}, {181, 146, -1}, {147, 153, -1}, {148, 149, -1}, {-1, -1, 448}, {-1, -1, 512}, {151, 161, -1}, {152, 158, -1}, {-1, -1, 576}, {155, 154, -1}, {-1, -1, 640}, {156, 157, -1}, {-1, -1, 704}, {-1, -1, 768}, {159, 160, -1}, {-1, -1, 832}, {-1, -1, 896}, {162, 165, -1}, {163, 164, -1}, {-1, -1, 960}, {-1, -1, 1024}, {166, 167, -1}, {-1, -1, 1088}, {-1, -1, 1152}, {169, 172, -1}, {170, 171, -1}, {-1, -1, 1216}, {-1, -1, 1280}, {173, 174, -1}, {-1, -1, 1344}, {-1, -1, 1408}, {176, 179, -1}, {177, 178, -1}, {-1, -1, 1472}, {-1, -1, 1536}, {180, 182, -1}, {-1, -1, 1600}, {-1, -1, 1664}, {-1, -1, 1728}, {416, 184, -1}, {185, 188, -1}, {186, 195, -1}, {187, 192, -1}, {-1, -1, 1792}, {189, 202, -1}, {190, 191, -1}, {-1, -1, 1856}, {-1, -1, 1920}, {193, 194, -1}, {-1, -1, 1984}, {-1, -1, 2048}, {196, 199, -1}, {197, 198, -1}, {-1, -1, 2112}, {-1, -1, 2176}, {200, 201, -1}, {-1, -1, 2240}, {-1, -1, 2304}, {203, 206, -1}, {204, 205, -1}, {-1, -1, 2368}, {-1, -1, 2432}, {207, 208, -1}, {-1, -1, 2496}, {-1, -1, 2560}, {210, 219, -1}, {211, 225, -1}, {212, 228, -1}, {237, 213, -1}, {233, 214, -1}, {215, 236, -1}, {243, 216, -1}, {259, 217, -1}, {262, 218, -1}, {-1, -1, 0}, {220, 224, -1}, {-1, -1, 1}, {223, 222, -1}, {-1, -1, 2}, {-1, -1, 3}, {-1, -1, 4}, {227, 226, -1}, {-1, -1, 5}, {-1, -1, 6}, {230, 229, -1}, {-1, -1, 7}, {232, 231, -1}, {-1, -1, 8}, {-1, -1, 9}, {234, 235, -1}, {-1, -1, 10}, {-1, -1, 11}, {-1, -1, 12}, {251, 238, -1}, {239, 241, -1}, {240, 245, -1}, {-1, -1, 13}, {248, 242, -1}, {-1, -1, 14}, {244, 256, -1}, {-1, -1, 15}, {267, 246, -1}, {336, 247, -1}, {-1, -1, 16}, {249, 264, -1}, {250, 314, -1}, {-1, -1, 17}, {390, 252, -1}, {253, 273, -1}, {254, 270, -1}, {255, 321, -1}, {-1, -1, 18}, {277, 257, -1}, {281, 258, -1}, {-1, -1, 19}, {260, 294, -1}, {261, 291, -1}, {-1, -1, 20}, {263, 304, -1}, {-1, -1, 21}, {284, 265, -1}, {301, 266, -1}, {-1, -1, 22}, {268, 307, -1}, {269, 318, -1}, {-1, -1, 23}, {333, 271, -1}, {342, 272, -1}, {-1, -1, 24}, {274, 327, -1}, {275, 324, -1}, {276, 354, -1}, {-1, -1, 25}, {350, 278, -1}, {279, 280, -1}, {-1, -1, 26}, {-1, -1, 27}, {282, 283, -1}, {-1, -1, 28}, {-1, -1, 29}, {285, 288, -1}, {286, 287, -1}, {-1, -1, 30}, {-1, -1, 31}, {289, 290, -1}, {-1, -1, 32}, {-1, -1, 33}, {292, 293, -1}, {-1, -1, 34}, {-1, -1, 35}, {295, 298, -1}, {296, 297, -1}, {-1, -1, 36}, {-1, -1, 37}, {299, 300, -1}, {-1, -1, 38}, {-1, -1, 39}, {302, 303, -1}, {-1, -1, 40}, {-1, -1, 41}, {305, 306, -1}, {-1, -1, 42}, {-1, -1, 43}, {308, 311, -1}, {309, 310, -1}, {-1, -1, 44}, {-1, -1, 45}, {312, 313, -1}, {-1, -1, 46}, {-1, -1, 47}, {315, 346, -1}, {316, 317, -1}, {-1, -1, 48}, {-1, -1, 49}, {319, 320, -1}, {-1, -1, 50}, {-1, -1, 51}, {322, 331, -1}, {323, 362, -1}, {-1, -1, 52}, {356, 325, -1}, {359, 326, -1}, {-1, -1, 53}, {328, 349, -1}, {329, 371, -1}, {330, 368, -1}, {-1, -1, 54}, {365, 332, -1}, {-1, -1, 55}, {334, 340, -1}, {335, 378, -1}, {-1, -1, 56}, {337, 344, -1}, {338, 339, -1}, {-1, -1, 57}, {-1, -1, 58}, {381, 341, -1}, {-1, -1, 59}, {343, 384, -1}, {-1, -1, 60}, {345, 353, -1}, {-1, -1, 61}, {347, 348, -1}, {-1, -1, 62}, {-1, -1, 63}, {-1, -1, 64}, {351, 352, -1}, {-1, -1, 128}, {-1, -1, 192}, {-1, -1, 256}, {387, 355, -1}, {-1, -1, 320}, {357, 358, -1}, {-1, -1, 384}, {-1, -1, 448}, {360, 361, -1}, {-1, -1, 512}, {-1, -1, 576}, {363, 364, -1}, {-1, -1, 640}, {-1, -1, 704}, {366, 367, -1}, {-1, -1, 768}, {-1, -1, 832}, {369, 370, -1}, {-1, -1, 896}, {-1, -1, 960}, {372, 375, -1}, {373, 374, -1}, {-1, -1, 1024}, {-1, -1, 1088}, {376, 377, -1}, {-1, -1, 1152}, {-1, -1, 1216}, {379, 380, -1}, {-1, -1, 1280}, {-1, -1, 1344}, {382, 383, -1}, {-1, -1, 1408}, {-1, -1, 1472}, {385, 386, -1}, {-1, -1, 1536}, {-1, -1, 1600}, {388, 389, -1}, {-1, -1, 1664}, {-1, -1, 1728}, {421, 391, -1}, {392, 395, -1}, {393, 402, -1}, {394, 399, -1}, {-1, -1, 1792}, {396, 409, -1}, {397, 398, -1}, {-1, -1, 1856}, {-1, -1, 1920}, {400, 401, -1}, {-1, -1, 1984}, {-1, -1, 2048}, {403, 406, -1}, {404, 405, -1}, {-1, -1, 2112}, {-1, -1, 2176}, {407, 408, -1}, {-1, -1, 2240}, {-1, -1, 2304}, {410, 413, -1}, {411, 412, -1}, {-1, -1, 2368}, {-1, -1, 2432}, {414, 415, -1}, {-1, -1, 2496}, {-1, -1, 2560}, {417, -1, -1}, {418, -1, -1}, {419, -1, -1}, {-1, 420, -1}, {-1, -1, 9999}, {422, -1, -1}, {423, -1, -1}, {424, -1, -1}, {-1, 425, -1}, {-1, -1, 9999}};

    public static short getRunLength(BitBuffer bbuf, boolean isWhitePixel) throws ImageCompressionException {
        int treeIndex = isWhitePixel ? 0 : 1;
        short runLength = huffTree[treeIndex][2];
        while (runLength < 0) {
            int childIndex = bbuf.extract();
            if ((treeIndex = huffTree[treeIndex][childIndex]) == -1) {
                throw new ImageCompressionException("Bad tree index");
            }
            runLength = huffTree[treeIndex][2];
        }
        return runLength;
    }
}

