/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.decoder;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.Debug;
import com.sas.visuals.image.ImageFormatException;
import com.sas.visuals.image.decoder.RAStream;
import com.sas.visuals.image.decoder.TiffField;
import com.sas.visuals.image.decoder.TiffMissingFieldException;
import java.io.EOFException;
import java.io.IOException;
import java.util.Hashtable;

@SASScope
class TiffIFD {
    int count;
    long dirOffset;
    long nextDirOffset;
    RAStream iStream;
    Hashtable imgFields;
    TiffIFD nextIFD;
    TiffIFD prevIFD;

    public TiffIFD(RAStream iStrm, long offset) throws IOException {
        this(iStrm, offset, null);
    }

    public TiffIFD(RAStream iStrm, long offset, TiffIFD previous) throws IOException {
        this.iStream = iStrm;
        this.prevIFD = previous;
        this.nextIFD = null;
        this.dirOffset = offset;
        Debug.println("TiffIFD().<init>.dirOffset=" + this.dirOffset);
    }

    public void init() throws IOException {
        this.iStream.seek(this.dirOffset);
        this.count = this.iStream.readUnsignedShort();
        Debug.println(" TiffIFD.init().count=" + this.count);
        this.imgFields = new Hashtable(this.count);
        for (int i = 0; i < this.count; ++i) {
            TiffField tField = new TiffField(this.iStream);
            this.imgFields.put(new Integer(tField.getTag()), tField);
        }
        this.nextDirOffset = this.iStream.readUnsignedInt();
        Debug.println("nextDirOffset " + this.nextDirOffset);
    }

    public boolean isInited() {
        return this.imgFields == null;
    }

    public TiffField getField(int tag) {
        return (TiffField)this.imgFields.get(new Integer(tag));
    }

    public Object getFieldValue(int tag) throws TiffMissingFieldException {
        TiffField tField = this.getField(tag);
        if (tField == null) {
            throw new TiffMissingFieldException(tag);
        }
        return tField.getValue();
    }

    public Object getFieldValue(int tag, Object def) {
        TiffField tField = this.getField(tag);
        if (tField == null) {
            return def;
        }
        return tField.getValue();
    }

    public TiffIFD getNextIFD() throws IOException {
        if (this.nextDirOffset == 0L) {
            return null;
        }
        if (this.nextIFD == null) {
            this.nextIFD = new TiffIFD(this.iStream, this.nextDirOffset, this);
        }
        return this.nextIFD;
    }

    public TiffIFD getPrevIFD() {
        return this.prevIFD;
    }

    public int getImageLength() throws TiffMissingFieldException {
        return (int)((long[])this.getFieldValue(257))[0];
    }

    public int getImageWidth() throws TiffMissingFieldException {
        return (int)((long[])this.getFieldValue(256))[0];
    }

    public int getPhotometricInterpretation() throws TiffMissingFieldException {
        return (int)((long[])this.getFieldValue(262))[0];
    }

    public int getSamplesPerPixel() {
        long[] def = new long[]{1L};
        return (int)((long[])this.getFieldValue(277, def))[0];
    }

    public int getBitsPerSample() throws ImageFormatException {
        long[] def = new long[]{1L};
        long[] val = (long[])this.getFieldValue(258, def);
        if (val.length > 1 && (val[0] != val[1] || val[0] != val[2] || val[1] != val[2])) {
            throw new ImageFormatException("Unequal BitsPerSample: " + val[0] + "," + val[1] + "," + val[2]);
        }
        return (int)val[0];
    }

    public int getCompression() {
        long[] def = new long[]{1L};
        return (int)((long[])this.getFieldValue(259, def))[0];
    }

    public int getFillOrder() {
        long[] def = new long[]{1L};
        return (int)((long[])this.getFieldValue(266, def))[0];
    }

    public int getPlanarConfiguration() {
        long[] def = new long[]{1L};
        return (int)((long[])this.getFieldValue(284, def))[0];
    }

    public byte[] getImageData() throws TiffMissingFieldException, IOException {
        long[] stripOffsets = (long[])this.getFieldValue(273);
        long[] stripByteCounts = (long[])this.getFieldValue(279);
        long imgSize = 0L;
        for (int i = 0; i < stripByteCounts.length; ++i) {
            imgSize += stripByteCounts[i];
        }
        byte[] tmpImgData = new byte[(int)imgSize];
        int cummulativeCount = 0;
        Debug.println("Tiff NumStrips=" + stripOffsets.length);
        int i = 0;
        int count = 0;
        while (i < stripOffsets.length) {
            count = (int)stripByteCounts[i];
            this.iStream.seek(stripOffsets[i]);
            while (count != 0) {
                int actuallyRead = this.iStream.read(tmpImgData, cummulativeCount, count);
                if (actuallyRead != count) {
                    Debug.println("TiffIFD.getImageData():read blocked; actualRead=" + actuallyRead + " cumulative=" + cummulativeCount);
                }
                if (actuallyRead == -1) {
                    throw new EOFException();
                }
                count -= actuallyRead;
                cummulativeCount += actuallyRead;
            }
            ++i;
            cummulativeCount += count;
        }
        return tmpImgData;
    }
}

