/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.decoder;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.decoder.RandomAccessor;
import java.io.IOException;
import java.io.RandomAccessFile;

@SASScope(value="ALL")
public class FileRandomAccessor
implements RandomAccessor {
    protected RandomAccessFile raFile;

    public FileRandomAccessor(String fName) throws IOException {
        this.raFile = new RandomAccessFile(fName, "r");
    }

    public void finalize() throws IOException {
        this.close();
    }

    @Override
    public void close() throws IOException {
        this.raFile.close();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.raFile.seek(pos);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.raFile.getFilePointer();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.raFile.read(b, off, len);
    }

    @Override
    public byte readByte() throws IOException {
        return this.raFile.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.raFile.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.raFile.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.raFile.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.raFile.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.raFile.readInt();
    }

    @Override
    public long readUnsignedInt() throws IOException {
        return 0xFFFFFFFF & this.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.raFile.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.raFile.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.raFile.readDouble();
    }
}

