/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.decoder;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.decoder.BufferedInputStream;
import com.sas.visuals.image.decoder.RandomAccessor;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

@SASScope(value="ALL")
public class BufferRandomAccessor
extends BufferedInputStream
implements RandomAccessor {
    static final int MARK_INCREMENT = 2048;

    public BufferRandomAccessor(InputStream iStrm) throws IOException {
        super(iStrm);
        this.mark(this.buf.length);
    }

    public void finalize() throws IOException {
        this.close();
    }

    @Override
    public void seek(long sPos) throws IOException {
        int bufLength = this.buf.length;
        int iPos = (int)sPos;
        if (iPos >= this.marklimit) {
            this.renewMark(iPos);
        }
        if (iPos < this.pos) {
            this.reset();
        } else {
            iPos -= this.pos;
        }
        while (iPos != 0) {
            long skippedBytes = this.skip(iPos);
            if (skippedBytes == 0L) {
                int input = this.read();
                if (input == -1) {
                    throw new EOFException();
                }
                --iPos;
            }
            iPos = (int)((long)iPos - skippedBytes);
        }
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.pos;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.pos + len >= this.marklimit) {
            this.renewMark(this.pos + len);
        }
        return super.read(b, off, len);
    }

    @Override
    public byte readByte() throws IOException {
        int tmp;
        if (this.pos >= this.marklimit) {
            this.renewMark(this.pos);
        }
        if ((tmp = this.read()) == -1) {
            throw new EOFException();
        }
        return (byte)(tmp & 0xFF);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int tmp;
        if (this.pos >= this.marklimit) {
            this.renewMark(this.pos);
        }
        if ((tmp = this.read()) == -1) {
            throw new EOFException();
        }
        return tmp;
    }

    @Override
    public short readShort() throws IOException {
        int byte1 = this.readUnsignedByte();
        int byte2 = this.readUnsignedByte();
        return (short)((byte1 << 8) + byte2);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int byte1 = this.readUnsignedByte();
        int byte2 = this.readUnsignedByte();
        return (byte1 << 8) + byte2;
    }

    @Override
    public char readChar() throws IOException {
        int byte1 = this.readUnsignedByte();
        int byte2 = this.readUnsignedByte();
        return (char)((byte1 << 8) + byte2);
    }

    @Override
    public int readInt() throws IOException {
        return this.readUnsignedShort() << 16 | this.readUnsignedShort();
    }

    @Override
    public long readUnsignedInt() throws IOException {
        return 0xFFFFFFFF & this.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return (this.readInt() << 32) + this.readInt();
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    private final void renewMark(int mPos) {
        this.marklimit = mPos + 2048;
    }
}

