/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.Debug;
import java.awt.image.RGBImageFilter;
import java.io.Serializable;
import java.util.Hashtable;

@SASScope(value="ALL")
public class Threshold1BitFilter
extends RGBImageFilter
implements Serializable {
    static final long serialVersionUID = 1741258194806349700L;
    static final double RED_WEIGHT = 0.3;
    static final double GREEN_WEIGHT = 0.59;
    static final double BLUE_WEIGHT = 0.11;
    static final int INTENSITY_THRESHOLD = 126;
    protected double redWeight;
    protected double greenWeight;
    protected double blueWeight;
    protected int intensityThreshold;
    protected double redContrib;
    protected double greenContrib;
    protected double blueContrib;

    public Threshold1BitFilter() {
        this(0.3, 0.59, 0.11, 126);
    }

    public Threshold1BitFilter(double redW, double greenW, double blueW, int iThreshold) {
        this.canFilterIndexColorModel = false;
        this.redWeight = redW;
        this.greenWeight = greenW;
        this.blueWeight = blueW;
        this.intensityThreshold = iThreshold;
        if (Debug.debug) {
            Debug.println("Threshold1BitFilter.ctor: Weights r=" + redW + " g=" + greenW + " b=" + blueW + " intensityThreshold=" + iThreshold);
        }
    }

    public void setProperties(Hashtable props) {
        String key = "Threshold1Bit";
        String val = "Yes";
        Object o = (props = (Hashtable)props.clone()).get(key);
        if (o != null && o instanceof String) {
            val = (String)o + ", " + val;
        }
        props.put(key, val);
        super.setProperties(props);
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        int intensity = (int)this.getIntensityFromRGB(rgb);
        return intensity > this.intensityThreshold ? 1 : 0;
    }

    public double getIntensityFromRGB(int rgb) {
        return (double)(rgb & 0xFF) * this.redWeight + (double)((rgb & 0xFF00) >> 8) * this.greenWeight + (double)((rgb & 0xFF0000) >> 16) * this.blueWeight;
    }
}

