/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image;

import com.sas.codepolicy.SASScope;
import java.awt.image.RGBImageFilter;
import java.io.Serializable;
import java.util.Hashtable;

@SASScope(value="ALL")
public class GammaFilter
extends RGBImageFilter
implements Serializable {
    static final long serialVersionUID = -2487370022949682150L;
    double gammaCorrector;
    static final int[] colorMask = new int[]{255, 65280, 0xFF0000};

    public GammaFilter(double gamma) {
        this.canFilterIndexColorModel = true;
        this.gammaCorrector = 1.0 / gamma;
    }

    public GammaFilter() {
        this(1.0);
    }

    public void setGamma(double gamma) {
        this.gammaCorrector = 1.0 / gamma;
    }

    public void setProperties(Hashtable props) {
        String key = "gamma";
        String val = "" + this.gammaCorrector;
        Object o = (props = (Hashtable)props.clone()).get(key);
        if (o != null && o instanceof String) {
            val = (String)o + ", " + val;
        }
        props.put(key, val);
        super.setProperties(props);
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        int transparencyInfo = rgb & 0xFF000000;
        int[] colorInfo = new int[3];
        for (int i = 0; i < 3; ++i) {
            int tmpColor = (rgb & colorMask[i]) >> 8 * i;
            colorInfo[i] = (int)(255.0 * Math.pow((double)tmpColor / 255.0, this.gammaCorrector) + 0.5);
        }
        return transparencyInfo | colorInfo[0] | colorInfo[1] << 8 | colorInfo[2] << 16;
    }
}

