/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.ImageFormatException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.PixelGrabber;

@SASScope(value="ALL")
public class FilteredPixelGrabber {
    protected PixelGrabber grabber;
    protected Object imgPixels;
    protected ColorModel cModel;

    public FilteredPixelGrabber(Image img, ImageFilter filt) {
        FilteredImageSource filtSource = new FilteredImageSource(img.getSource(), filt);
        Image filtImage = Toolkit.getDefaultToolkit().createImage(filtSource);
        this.grabber = new PixelGrabber(filtImage, 0, 0, -1, -1, false);
    }

    public boolean setup() throws InterruptedException, ImageFormatException {
        boolean rc = this.grabber.grabPixels();
        if (rc) {
            this.imgPixels = this.grabber.getPixels();
            this.cModel = this.grabber.getColorModel();
        }
        return rc;
    }

    public Object getImagePixels() {
        return this.imgPixels;
    }

    public ColorModel getColorModel() {
        return this.cModel;
    }

    public int getWidth() {
        return this.grabber.getWidth();
    }

    public int getHeight() {
        return this.grabber.getHeight();
    }
}

