/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.Debug;
import com.sas.visuals.image.Threshold1BitFilter;
import java.util.Hashtable;

@SASScope(value="ALL")
public class Dither1BitFSFilter
extends Threshold1BitFilter {
    static final long serialVersionUID = 7464688767042579089L;
    protected int width;
    protected int height;
    protected double[] scanlineErrors;
    protected double[] nextScanlineErrors;
    protected double rightWeight;
    protected double bottomLeftWeight;
    protected double bottomWeight;
    protected double bottomRightWeight;

    public Dither1BitFSFilter() {
        this(0.4375, 0.1875, 0.3125, 0.0625);
    }

    public Dither1BitFSFilter(double iRWeight, double iBLWeight, double iBWeight, double iBRWeight) {
        this.canFilterIndexColorModel = false;
        this.rightWeight = iRWeight;
        this.bottomLeftWeight = iBLWeight;
        this.bottomWeight = iBWeight;
        this.bottomRightWeight = iBRWeight;
        if (Debug.debug) {
            Debug.println("Dither1BitFSFilter.ctor:FS weights r=" + this.rightWeight + " bl=" + this.bottomLeftWeight + " b=" + this.bottomWeight + " br=" + this.bottomRightWeight);
        }
    }

    @Override
    public void setProperties(Hashtable props) {
        String key = "Dither1BitFS";
        String val = "Yes";
        Object o = (props = (Hashtable)props.clone()).get(key);
        if (o != null && o instanceof String) {
            val = (String)o + ", " + val;
        }
        props.put(key, val);
        super.setProperties(props);
    }

    @Override
    public void setDimensions(int width, int height) {
        this.scanlineErrors = new double[width];
        this.nextScanlineErrors = new double[width];
        this.width = width;
        this.height = height;
        super.setDimensions(width, height);
    }

    @Override
    public void setHints(int hints) {
        if (Debug.debug && (hints & 2) == 0) {
            Debug.println("Dither1BitFSFilter.setHints: Order != TDLR");
        }
        this.consumer.setHints(hints);
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        int[] quantizedVal = new int[]{0, 255};
        int maxX = this.width - 1;
        int maxY = this.height - 1;
        double tmpError = 0.0;
        double cummulativeError = 0.0;
        double errorDiffusedVal = this.getIntensityFromRGB(rgb) + this.scanlineErrors[x];
        if (errorDiffusedVal < 0.0) {
            errorDiffusedVal = 0.0;
        } else if (errorDiffusedVal > 255.0) {
            errorDiffusedVal = 255.0;
        }
        int bitVal = (int)errorDiffusedVal > 126 ? 1 : 0;
        double error = errorDiffusedVal - (double)quantizedVal[bitVal];
        if (x != maxX) {
            tmpError = this.rightWeight * error;
            int n = x + 1;
            this.scanlineErrors[n] = this.scanlineErrors[n] + tmpError;
            cummulativeError = tmpError;
        }
        if (y != maxY) {
            if (x != 0) {
                tmpError = this.bottomLeftWeight * error;
                int n = x - 1;
                this.nextScanlineErrors[n] = this.nextScanlineErrors[n] + tmpError;
                cummulativeError += tmpError;
            }
            tmpError = this.bottomWeight * error;
            int n = x;
            this.nextScanlineErrors[n] = this.nextScanlineErrors[n] + tmpError;
            cummulativeError += tmpError;
            if (x != maxX) {
                tmpError = this.bottomRightWeight * error;
                int n2 = x + 1;
                this.nextScanlineErrors[n2] = this.nextScanlineErrors[n2] + tmpError;
                cummulativeError += tmpError;
            }
            if (x == maxX) {
                double[] tmpArray = this.scanlineErrors;
                this.scanlineErrors = this.nextScanlineErrors;
                this.nextScanlineErrors = tmpArray;
                for (int k = 0; k < this.width; ++k) {
                    this.nextScanlineErrors[k] = 0.0;
                }
            }
        }
        return bitVal;
    }
}

