/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image;

import com.sas.codepolicy.SASScope;
import java.io.Serializable;

@SASScope(value="ALL")
public class ConvolutionMask
implements Serializable {
    static final long serialVersionUID = -8448490208549080307L;
    public static final ConvolutionMask Smooth3Rect;
    public static final ConvolutionMask Smooth3Circular;
    public static final ConvolutionMask Smooth5Circular;
    public static final ConvolutionMask Gradient3X;
    public static final ConvolutionMask Gradient3Y;
    public static final ConvolutionMask Emboss3;
    public int size;
    public double[][] mask;
    public double divisor;
    public double bias;
    public String name;

    public ConvolutionMask() {
        this.divisor = 1.0;
        this.bias = 0.0;
    }

    public ConvolutionMask(int maskSize, double[][] conMask, double divisor, double bias) {
        this.setSize(maskSize);
        this.setMask(conMask);
        this.setDivisor(divisor);
        this.setBias(bias);
    }

    public void setSize(int maskSize) {
        this.size = maskSize;
    }

    public void setMask(double[][] conMask) {
        this.mask = conMask;
    }

    public void setMask(String maskName) {
        this.name = maskName;
    }

    public void setDivisor(double divisor) {
        this.divisor = divisor == 0.0 ? 1.0 : divisor;
    }

    public void setBias(double bias) {
        this.bias = bias;
    }

    static {
        int size = 3;
        double[][] mask = new double[size][size];
        mask[2][1] = 1.0;
        mask[1][2] = 1.0;
        mask[1][1] = 1.0;
        mask[1][0] = 1.0;
        mask[0][1] = 1.0;
        mask[2][2] = 1.0;
        mask[2][0] = 1.0;
        mask[0][2] = 1.0;
        mask[0][0] = 1.0;
        Smooth3Rect = new ConvolutionMask(size, mask, 9.0, 0.0);
        ConvolutionMask.Smooth3Rect.name = "Smoothing 3x3 rectangular aperture";
        size = 3;
        mask = new double[size][size];
        mask[2][2] = 0.0;
        mask[2][0] = 0.0;
        mask[0][2] = 0.0;
        mask[0][0] = 0.0;
        mask[2][1] = 1.0;
        mask[1][2] = 1.0;
        mask[1][1] = 1.0;
        mask[1][0] = 1.0;
        mask[0][1] = 1.0;
        Smooth3Circular = new ConvolutionMask(size, mask, 5.0, 0.0);
        ConvolutionMask.Smooth3Circular.name = "Smoothing 3x3 circular aperture";
        double w1 = 1.0;
        double w2 = 0.25;
        int size2 = 5;
        double[][] mask2 = new double[size2][size2];
        mask2[4][4] = 0.0;
        mask2[4][0] = 0.0;
        mask2[0][4] = 0.0;
        mask2[0][0] = 0.0;
        double d = w1;
        mask2[3][2] = d;
        mask2[2][3] = d;
        mask2[2][2] = d;
        mask2[2][1] = d;
        mask2[1][2] = d;
        double d2 = w2;
        mask2[4][3] = d2;
        mask2[4][2] = d2;
        mask2[4][1] = d2;
        mask2[3][4] = d2;
        mask2[3][3] = d2;
        mask2[3][1] = d2;
        mask2[3][0] = d2;
        mask2[2][4] = d2;
        mask2[2][0] = d2;
        mask2[1][4] = d2;
        mask2[1][3] = d2;
        mask2[1][1] = d2;
        mask2[1][0] = d2;
        mask2[0][3] = d2;
        mask2[0][2] = d2;
        mask2[0][1] = d2;
        Smooth5Circular = new ConvolutionMask(size2, mask2, 9.0, 0.0);
        ConvolutionMask.Smooth5Circular.name = "Smoothing 5x5 circular aperture";
        size = 3;
        mask = new double[size][size];
        mask[0][2] = -1.0;
        mask[0][0] = -1.0;
        mask[2][2] = 1.0;
        mask[2][0] = 1.0;
        mask[0][1] = -2.0;
        mask[2][1] = 2.0;
        mask[1][2] = 0.0;
        mask[1][1] = 0.0;
        mask[1][0] = 0.0;
        Gradient3X = new ConvolutionMask(size, mask, 1.0, 0.0);
        ConvolutionMask.Gradient3X.name = "Gradient 3x3 X axis";
        size = 3;
        mask = new double[size][size];
        mask[2][0] = -1.0;
        mask[0][0] = -1.0;
        mask[2][2] = 1.0;
        mask[0][2] = 1.0;
        mask[1][0] = -2.0;
        mask[1][2] = 2.0;
        mask[2][1] = 0.0;
        mask[1][1] = 0.0;
        mask[0][1] = 0.0;
        Gradient3Y = new ConvolutionMask(size, mask, 1.0, 0.0);
        ConvolutionMask.Gradient3Y.name = "Gradient 3x3 Y axis";
        size = 3;
        mask = new double[size][size];
        mask[0][0] = -4.0;
        mask[0][1] = -8.0;
        mask[1][0] = -8.0;
        mask[0][2] = 0.0;
        mask[1][1] = 0.0;
        mask[2][0] = 0.0;
        mask[1][2] = 8.0;
        mask[2][1] = 8.0;
        mask[2][2] = 4.0;
        Emboss3 = new ConvolutionMask(size, mask, 10.0, 180.0);
        ConvolutionMask.Emboss3.name = "Emboss 3x3";
    }
}

