/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.Debug;
import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.io.Serializable;
import java.util.Hashtable;

@SASScope(value="ALL")
public class BufferedFilter
extends ImageFilter
implements Serializable {
    static final long serialVersionUID = -8381551134030899321L;
    protected int width;
    protected int height;
    protected String propKey;
    protected String propVal;
    protected transient boolean isByteData;
    protected transient Object srcBuffer;
    protected transient boolean isImageComplete = false;
    protected transient ColorModel majorityColorModel;
    protected int backgroundColor;
    protected transient ColorModel transformedColorModel;
    protected int[] srcSize;
    protected double[] destOriginOffset;

    public BufferedFilter(int backColor) {
        this.setBackgroundColor(backColor);
        this.propKey = "buffered";
        this.propVal = "identity";
    }

    public BufferedFilter() {
        this(0);
    }

    public void setBackgroundColor(int backColor) {
        this.backgroundColor = backColor;
    }

    public void setProperties(Hashtable props) {
        props = (Hashtable)props.clone();
        Object o = props.get(this.propKey);
        String val = this.propVal;
        if (o != null && o instanceof String) {
            val = (String)o + ", " + val;
        }
        props.put(this.propKey, val);
        super.setProperties(props);
    }

    @Override
    public void setDimensions(int iWidth, int iHeight) {
        int[][] srcCorners = new int[4][2];
        double[] destCorner = new double[2];
        double[][] extents = new double[2][2];
        srcCorners[0][1] = 0;
        srcCorners[0][0] = 0;
        int n = iWidth - 1;
        srcCorners[2][0] = n;
        srcCorners[1][0] = n;
        int n2 = iHeight - 1;
        srcCorners[3][1] = n2;
        srcCorners[2][1] = n2;
        srcCorners[3][0] = 0;
        srcCorners[1][1] = 0;
        for (int i = 0; i < 4; ++i) {
            this.transform(srcCorners[i], destCorner);
            this.checkExtents(destCorner, extents);
        }
        if (this.destOriginOffset == null) {
            this.destOriginOffset = new double[2];
            this.srcSize = new int[2];
        }
        this.destOriginOffset[0] = extents[0][0];
        this.destOriginOffset[1] = extents[1][0];
        this.srcSize[0] = iWidth;
        this.srcSize[1] = iHeight;
        this.width = (int)Math.round(extents[0][1] - extents[0][0]) + 1;
        this.height = (int)Math.round(extents[1][1] - extents[1][0]) + 1;
        Debug.println("BufferedFilter.setDimensions:w=" + this.width + " h=" + this.height);
        super.setDimensions(this.width, this.height);
    }

    private final void checkExtents(double[] corner, double[][] exts) {
        for (int i = 0; i < 2; ++i) {
            if (corner[i] < exts[i][0]) {
                exts[i][0] = corner[i];
            }
            if (!(corner[i] > exts[i][1])) continue;
            exts[i][1] = corner[i];
        }
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        Debug.println("BufferedFilter.setPixB x=" + x + " y=" + y + " w==" + w + " h=" + h);
        this.isByteData = true;
        if (this.srcBuffer == null || this.srcBuffer instanceof int[]) {
            this.srcBuffer = new byte[this.srcSize[0] * this.srcSize[1]];
        }
        this.setPixelsGeneric(x, y, w, h, model, pixels, off, scansize);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        Debug.println("BufferedFilter.setPixI x=" + x + " y=" + y + " w==" + w + " h=" + h);
        this.isByteData = false;
        if (this.srcBuffer == null || this.srcBuffer instanceof byte[]) {
            this.srcBuffer = new int[this.srcSize[0] * this.srcSize[1]];
        }
        this.setPixelsGeneric(x, y, w, h, model, pixels, off, scansize);
    }

    protected void setPixelsGeneric(int x, int y, int w, int h, ColorModel model, Object pixels, int off, int scansize) {
        if (this.majorityColorModel != model) {
            Debug.println("BufferedFilter.setPixG CModel=" + this.majorityColorModel + " newModel=" + model);
            this.majorityColorModel = model;
        }
        if (this.transformedColorModel == null) {
            this.transformedColorModel = ColorModel.getRGBdefault();
        }
        int row = 0;
        int srcOff = off;
        int destOff = x + y * this.srcSize[0];
        while (row < h) {
            System.arraycopy(pixels, srcOff, this.srcBuffer, destOff, w);
            ++row;
            srcOff += scansize;
            destOff += this.srcSize[0];
        }
        if (this.isImageComplete && x + w == this.srcSize[0] && y + h == this.srcSize[1]) {
            Debug.println("BufferedFilter.setPixG Source buffer complete");
            this.transformNsendSrcBuffer();
        }
    }

    protected void transformNsendSrcBuffer() {
        int[] transformedBuffer = new int[this.width];
        double[] tempIn = new double[2];
        double[] tempOut = new double[2];
        for (int row = 0; row < this.height; ++row) {
            int col = 0;
            int destIndx = 0;
            while (col < this.width) {
                tempIn[0] = (double)col + this.destOriginOffset[0];
                tempIn[1] = (double)row + this.destOriginOffset[1];
                this.invTransform(tempIn, tempOut);
                int sX = (int)Math.round(tempOut[0]);
                int sY = (int)Math.round(tempOut[1]);
                if (sX < 0 || sX > this.srcSize[0] - 1 || sY < 0 || sY > this.srcSize[1] - 1) {
                    transformedBuffer[destIndx] = this.backgroundColor;
                } else {
                    int srcIndex = sX + this.srcSize[0] * sY;
                    int tmpPixel = this.isByteData ? 0xFF & ((byte[])this.srcBuffer)[srcIndex] : ((int[])this.srcBuffer)[srcIndex];
                    transformedBuffer[destIndx] = this.majorityColorModel.getRGB(tmpPixel);
                }
                ++col;
                ++destIndx;
            }
            super.setPixels(0, row, this.width, 1, this.transformedColorModel, transformedBuffer, 0, this.width);
        }
    }

    @Override
    public void imageComplete(int status) {
        if (status == 3 || status == 2) {
            Debug.println("BufferedFilter.imageComplete src buff complete");
            this.isImageComplete = true;
            this.transformNsendSrcBuffer();
        }
        super.imageComplete(status);
    }

    protected void transform(int[] src, double[] dest) {
        dest[0] = src[0];
        dest[1] = src[1];
    }

    protected void invTransform(double[] dest, double[] src) {
        src[0] = dest[0];
        src[1] = dest[1];
    }
}

